/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.plugin.dendroview.TreeAnalysisNode;
import java.util.Hashtable;
import java.util.Vector;

public class AtrAnalysisNode
extends TreeAnalysisNode {
    int leafCount = -1;
    double averageIndex = -1.0;
    String name = "";

    public AtrAnalysisNode(String string) {
        super(string);
    }

    public AtrAnalysisNode(String string, TreeAnalysisNode treeAnalysisNode) {
        super(string, treeAnalysisNode);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public double getAverageSubtreeIndex() {
        double d = 0.0;
        double d2 = 0.0;
        Vector vector = new Vector();
        this.enumerate(vector);
        for (int i = 0; i < vector.size(); ++i) {
            if (!((TreeAnalysisNode)vector.elementAt(i)).isLeaf()) continue;
            d += (double)((TreeAnalysisNode)vector.elementAt(i)).getIndex();
            d2 += 1.0;
        }
        return d / d2;
    }

    public void enumerate(Vector vector) {
        if (this.left != null) {
            this.left.enumerate(vector);
        }
        if (this.isLeaf()) {
            vector.add(this);
        }
        if (this.right != null) {
            this.right.enumerate(vector);
        }
    }

    public int getLeafCount() {
        if (this.leafCount == -1) {
            if (this.isLeaf()) {
                this.leafCount = 1;
            } else {
                this.leafCount = 0;
                if (this.left != null) {
                    this.leafCount += ((AtrAnalysisNode)this.left).getLeafCount();
                } else if (this.right != null) {
                    this.leafCount += ((AtrAnalysisNode)this.right).getLeafCount();
                }
            }
        }
        return this.leafCount;
    }

    private double computeAverageIndexTree(HeaderInfo headerInfo, Hashtable hashtable) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.isLeaf()) {
            int n = 0;
            try {
                n = (Integer)hashtable.get(this.getName());
            }
            catch (NullPointerException nullPointerException) {
                this.leafCount = 0;
            }
            this.setIndex(n);
            this.averageIndex = n;
        } else {
            d = ((AtrAnalysisNode)this.left).computeAverageIndexTree(headerInfo, hashtable);
            d2 = ((AtrAnalysisNode)this.right).computeAverageIndexTree(headerInfo, hashtable);
            this.averageIndex = ((d *= (double)((AtrAnalysisNode)this.left).getLeafCount()) + (d2 *= (double)((AtrAnalysisNode)this.right).getLeafCount())) / (double)(((AtrAnalysisNode)this.left).getLeafCount() + ((AtrAnalysisNode)this.right).getLeafCount());
        }
        return this.averageIndex;
    }

    private void arrangeByAverageIndex() {
        if (this.left == null || this.right == null) {
            return;
        }
        if (((AtrAnalysisNode)this.left).getAverageIndex() > ((AtrAnalysisNode)this.right).getAverageIndex()) {
            AtrAnalysisNode atrAnalysisNode = (AtrAnalysisNode)this.left;
            this.left = this.right;
            this.right = atrAnalysisNode;
        }
        ((AtrAnalysisNode)this.left).arrangeByAverageIndex();
        ((AtrAnalysisNode)this.right).arrangeByAverageIndex();
    }

    public void indexTree(HeaderInfo headerInfo, Hashtable hashtable) {
        this.computeAverageIndexTree(headerInfo, hashtable);
        this.arrangeByAverageIndex();
    }

    public double getAverageIndex() {
        return this.averageIndex;
    }
}

