/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.CancelableSettingsDialog;
import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.MessagePanel;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.TreeSelection;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.plugin.dendroview.ATRView;
import edu.stanford.genetics.treeview.plugin.dendroview.ATRZoomView;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayNameView;
import edu.stanford.genetics.treeview.plugin.dendroview.BitmapExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.CharArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.CharColorExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.CharHeaderInfo;
import edu.stanford.genetics.treeview.plugin.dendroview.DendroView;
import edu.stanford.genetics.treeview.plugin.dendroview.GTRView;
import edu.stanford.genetics.treeview.plugin.dendroview.GlobalView;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.TextViewManager;
import edu.stanford.genetics.treeview.plugin.dendroview.ZoomView;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.JFrame;
import javax.swing.JScrollBar;

public class CharDendroView
extends DendroView {
    private HeaderInfo charHeaderInfo;

    public CharDendroView(ViewFrame viewFrame, ConfigNode configNode) {
        super(viewFrame.getDataModel(), configNode, viewFrame, "CharDendroView");
        this.setArraySelection((TreeSelectionI)new TreeSelection(this.arrayDrawer.getNumCol()));
    }

    public void populateExportMenu(Menu menu) {
        MenuItem menuItem = new MenuItem("Export to Image...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapContainer mapContainer;
                MapContainer mapContainer2;
                if (CharDendroView.this.getArraySelection().getNSelectedIndexes() != 0 || CharDendroView.this.getGeneSelection().getNSelectedIndexes() != 0) {
                    mapContainer2 = CharDendroView.this.getZoomXmap();
                    mapContainer = CharDendroView.this.getZoomYmap();
                } else {
                    mapContainer2 = CharDendroView.this.getGlobalXmap();
                    mapContainer = CharDendroView.this.getGlobalYmap();
                }
                BitmapExportPanel bitmapExportPanel = new BitmapExportPanel(CharDendroView.this.arraynameview.getHeaderInfo(), CharDendroView.this.getDataModel().getGeneHeaderInfo(), CharDendroView.this.getGeneSelection(), CharDendroView.this.getArraySelection(), CharDendroView.this.invertedTreeDrawer, CharDendroView.this.leftTreeDrawer, CharDendroView.this.arrayDrawer, mapContainer2, mapContainer, true);
                bitmapExportPanel.setSourceSet(CharDendroView.this.getDataModel().getFileSet());
                bitmapExportPanel.setGeneFont(((Component)((Object)CharDendroView.this.textview)).getFont());
                bitmapExportPanel.setArrayFont(((Component)((Object)CharDendroView.this.arraynameview)).getFont());
                bitmapExportPanel.setIncludedArrayHeaders(CharDendroView.this.arraynameview.getHeaderSummary().getIncluded());
                bitmapExportPanel.setIncludedGeneHeaders(CharDendroView.this.textview.getHeaderSummary().getIncluded());
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)CharDendroView.this.viewFrame, "Export to Image", (SettingsPanel)bitmapExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.show();
            }
        });
        menu.add(menuItem);
    }

    protected void setupViews() {
        CharColorExtractor charColorExtractor = new CharColorExtractor();
        this.hintpanel = new MessagePanel("Usage Hints");
        this.statuspanel = new MessagePanel("View Status");
        CharArrayDrawer charArrayDrawer = new CharArrayDrawer();
        charArrayDrawer.setColorExtractor(charColorExtractor);
        charArrayDrawer.setHeaderInfo(this.getDataModel().getGeneHeaderInfo(), this.getConfigNode().getAttribute("headerName", "ALN"));
        this.arrayDrawer = charArrayDrawer;
        ((Observable)this.getDataModel()).addObserver(this.arrayDrawer);
        this.globalview = new GlobalView();
        this.globalXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.globalYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.zoomYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXmap = new MapContainer();
        this.zoomXmap.setDefaultScale(12.0);
        this.zoomXmap.setScrollbar(this.zoomXscrollbar);
        this.zoomYmap = new MapContainer();
        this.zoomYmap.setDefaultScale(12.0);
        this.zoomYmap.setScrollbar(this.zoomYscrollbar);
        this.globalXmap = new MapContainer();
        this.globalXmap.setDefaultScale(2.0);
        this.globalXmap.setScrollbar(this.globalXscrollbar);
        this.globalYmap = new MapContainer();
        this.globalYmap.setDefaultScale(2.0);
        this.globalYmap.setScrollbar(this.globalYscrollbar);
        this.globalview.setXMap(this.globalXmap);
        this.globalview.setYMap(this.globalYmap);
        this.globalview.setZoomYMap(this.getZoomYmap());
        this.globalview.setZoomXMap(this.getZoomXmap());
        this.globalview.setArrayDrawer(this.arrayDrawer);
        this.charHeaderInfo = new CharHeaderInfo(this.arrayDrawer.getNumCol());
        this.arraynameview = new ArrayNameView(this.charHeaderInfo);
        this.arraynameview.setUrlExtractor(this.viewFrame.getArrayUrlExtractor());
        this.leftTreeDrawer = new LeftTreeDrawer();
        this.gtrview = new GTRView();
        this.gtrview.setMap(this.globalYmap);
        this.gtrview.setLeftTreeDrawer(this.leftTreeDrawer);
        this.gtrview.getHeaderSummary().setIncluded(new int[]{0, 3});
        this.invertedTreeDrawer = new InvertedTreeDrawer();
        this.atrview = new ATRView();
        this.atrview.setMap(this.globalXmap);
        this.atrview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.atrview.getHeaderSummary().setIncluded(new int[]{0, 3});
        this.atrzview = new ATRZoomView();
        this.atrzview.setZoomMap(this.getZoomXmap());
        this.atrzview.setHeaderSummary(this.atrview.getHeaderSummary());
        this.atrzview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.zoomview = new ZoomView();
        this.zoomview.setYMap(this.getZoomYmap());
        this.zoomview.setXMap(this.getZoomXmap());
        this.zoomview.setArrayDrawer(this.arrayDrawer);
        this.arraynameview.setMapping(this.getZoomXmap());
        this.textview = new TextViewManager(this.getDataModel().getGeneHeaderInfo(), this.viewFrame.getUrlExtractor());
        this.textview.setMap(this.getZoomYmap());
        this.doDoubleLayout();
        this.settingsFrame = null;
        this.settingsPanel = null;
        charColorExtractor.bindConfig(this.getFirst("ColorExtractor"));
        this.bindTrees();
        this.zoomview.setHeaders(this.getDataModel().getGeneHeaderInfo(), this.charHeaderInfo);
        this.zoomview.setShowVal(true);
        this.globalXmap.bindConfig(this.getFirst("GlobalXMap"));
        this.globalYmap.bindConfig(this.getFirst("GlobalYMap"));
        this.getZoomXmap().bindConfig(this.getFirst("ZoomXMap"));
        this.getZoomYmap().bindConfig(this.getFirst("ZoomYMap"));
        this.textview.bindConfig(this.getFirst("TextViewParent"));
        this.globalXmap.setIndexRange(0, this.arrayDrawer.getNumCol() - 1);
        this.globalYmap.setIndexRange(0, this.arrayDrawer.getNumRow() - 1);
        this.getZoomXmap().setIndexRange(-1, -1);
        this.getZoomYmap().setIndexRange(-1, -1);
        this.globalXmap.notifyObservers();
        this.globalYmap.notifyObservers();
        this.getZoomXmap().notifyObservers();
        this.getZoomYmap().notifyObservers();
    }
}

