/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

class ColorExtractorEditor
extends JPanel {
    private static final int UP = 0;
    private static final int ZERO = 1;
    private static final int DOWN = 2;
    private static final int MISSING = 3;
    private ColorExtractor colorExtractor;
    private ColorPanel[] colorPanel = new ColorPanel[4];

    public ColorExtractorEditor(ColorExtractor colorExtractor) {
        this.colorExtractor = colorExtractor;
        for (int i = 0; i < 4; ++i) {
            this.colorPanel[i] = new ColorPanel(i);
            this.add(this.colorPanel[i]);
        }
    }

    public void copyStateFrom(ColorSet colorSet) {
        this.colorPanel[0].setColor(colorSet.getUp());
        this.colorPanel[1].setColor(colorSet.getZero());
        this.colorPanel[2].setColor(colorSet.getDown());
        this.colorPanel[3].setColor(colorSet.getMissing());
    }

    public void copyStateTo(ColorSet colorSet) {
        colorSet.setUp(this.colorPanel[0].getColor());
        colorSet.setZero(this.colorPanel[1].getColor());
        colorSet.setDown(this.colorPanel[2].getColor());
        colorSet.setMissing(this.colorPanel[3].getColor());
    }

    class ColorIcon
    implements Icon {
        private int width;
        private int height;
        private Color color;

        ColorIcon(int n, int n2, Color color) {
            this.width = n;
            this.height = n2;
            this.color = color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.width, this.height);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, this.width, this.height);
            graphics.setColor(color);
        }
    }

    class ColorPanel
    extends JPanel {
        ColorIcon colorIcon;
        int type;

        ColorPanel(int n) {
            this.type = n;
            this.redoComps();
        }

        public void redoComps() {
            this.removeAll();
            this.colorIcon = new ColorIcon(10, 10, this.getColor());
            JButton jButton = new JButton(this.getLabel(), this.colorIcon);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(ColorExtractorEditor.this, "Pick Color for " + ColorPanel.this.getLabel(), ColorPanel.this.getColor());
                    if (color != null) {
                        ColorPanel.this.setColor(color);
                    }
                }
            });
            this.add(jButton);
        }

        private void setColor(Color color) {
            switch (this.type) {
                case 0: {
                    ColorExtractorEditor.this.colorExtractor.setUpColor(color);
                    break;
                }
                case 1: {
                    ColorExtractorEditor.this.colorExtractor.setZeroColor(color);
                    break;
                }
                case 2: {
                    ColorExtractorEditor.this.colorExtractor.setDownColor(color);
                    break;
                }
                case 3: {
                    ColorExtractorEditor.this.colorExtractor.setMissingColor(color);
                }
            }
            this.colorIcon.setColor(this.getColor());
            ColorExtractorEditor.this.colorExtractor.notifyObservers();
            this.repaint();
        }

        private String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Positive";
                }
                case 1: {
                    return "Zero";
                }
                case 2: {
                    return "Negative";
                }
                case 3: {
                    return "Missing";
                }
            }
            return null;
        }

        private Color getColor() {
            switch (this.type) {
                case 0: {
                    return ColorExtractorEditor.this.colorExtractor.getUp();
                }
                case 1: {
                    return ColorExtractorEditor.this.colorExtractor.getZero();
                }
                case 2: {
                    return ColorExtractorEditor.this.colorExtractor.getDown();
                }
                case 3: {
                    return ColorExtractorEditor.this.colorExtractor.getMissing();
                }
            }
            return null;
        }
    }
}

