/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ColorSet
implements ConfigNodePersistent {
    private String default_upColor = "#FF0000";
    private String default_zeroColor = "#000000";
    private String default_downColor = "#00FF00";
    private String default_missingColor = "#909090";
    private String default_emptyColor = "#FFFFFF";
    private String default_name = null;
    private String name;
    private Color up;
    private Color zero;
    private Color down;
    private Color missing;
    private Color empty;
    private ConfigNode root = null;

    public ColorSet() {
        this.setDefaults();
    }

    public ColorSet(String string, String string2, String string3, String string4, String string5, String string6) {
        this.setName(string);
        this.setUp(string2);
        this.setZero(string3);
        this.setDown(string4);
        this.setMissing(string5);
        this.setEmpty(string6);
    }

    private void setDefaults() {
        this.up = ColorSet.decodeColor(this.default_upColor);
        this.zero = ColorSet.decodeColor(this.default_zeroColor);
        this.down = ColorSet.decodeColor(this.default_downColor);
        this.missing = ColorSet.decodeColor(this.default_missingColor);
        this.empty = ColorSet.decodeColor(this.default_emptyColor);
    }

    public void copyStateFrom(ColorSet colorSet) {
        this.setUp(colorSet.getUp());
        this.setZero(colorSet.getZero());
        this.setDown(colorSet.getDown());
        this.setMissing(colorSet.getMissing());
        this.setEmpty(colorSet.getEmpty());
        this.setName(colorSet.getName());
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.up = ColorSet.decodeColor(configNode.getAttribute("up", this.default_upColor));
        this.zero = ColorSet.decodeColor(configNode.getAttribute("zero", this.default_zeroColor));
        this.down = ColorSet.decodeColor(configNode.getAttribute("down", this.default_downColor));
        this.missing = ColorSet.decodeColor(configNode.getAttribute("missing", this.default_missingColor));
        this.empty = ColorSet.decodeColor(configNode.getAttribute("empty", this.default_emptyColor));
        this.name = configNode.getAttribute("name", this.default_name);
    }

    public static final void main(String[] stringArray) {
        ColorSet colorSet = new ColorSet();
        try {
            colorSet.loadEisen(stringArray[0]);
            colorSet.setName(stringArray[0]);
            System.out.println(colorSet.toString());
        }
        catch (Exception exception) {
            System.out.println("Couldn't load file " + stringArray[0] + ": " + exception);
        }
        if (stringArray.length > 1) {
            try {
                colorSet.saveEisen(stringArray[1]);
            }
            catch (Exception exception) {
                System.out.println("Couldn't save file " + stringArray[1] + ": " + exception);
            }
        }
    }

    public String toString() {
        return "ColorSet " + this.getName() + "\n" + "up: " + this.getUp().toString() + "\t" + "zero: " + this.getZero().toString() + "\t" + "down: " + this.getDown().toString() + "\t" + "missing: " + this.getMissing().toString() + "\t" + "empty: " + this.getEmpty().toString() + "\t";
    }

    public void loadEisen(String string) throws IOException {
        this.loadEisen(new File(string));
    }

    public void loadEisen(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.up = this.unpackEisen(fileInputStream);
        this.zero = this.unpackEisen(fileInputStream);
        this.down = this.unpackEisen(fileInputStream);
        this.missing = this.unpackEisen(fileInputStream);
        fileInputStream.close();
    }

    public void saveEisen(String string) throws IOException {
        this.saveEisen(new File(string));
    }

    public void saveEisen(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.packEisen(this.up, fileOutputStream);
        this.packEisen(this.zero, fileOutputStream);
        this.packEisen(this.down, fileOutputStream);
        this.packEisen(this.missing, fileOutputStream);
        fileOutputStream.close();
    }

    private Color unpackEisen(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        return new Color(n, n2, n3, n4);
    }

    private void packEisen(Color color, OutputStream outputStream) throws IOException {
        outputStream.write(color.getRed());
        outputStream.write(color.getGreen());
        outputStream.write(color.getBlue());
        outputStream.write(color.getAlpha());
    }

    public Color getUp() {
        return this.up;
    }

    public Color getZero() {
        return this.zero;
    }

    public Color getDown() {
        return this.down;
    }

    public Color getMissing() {
        return this.missing;
    }

    public Color getEmpty() {
        return this.empty;
    }

    public String getName() {
        return this.name;
    }

    public void setUp(String string) {
        this.up = ColorSet.decodeColor(string);
        if (this.root != null) {
            this.root.setAttribute("up", string, this.default_upColor);
        }
    }

    public void setZero(String string) {
        this.zero = ColorSet.decodeColor(string);
        if (this.root != null) {
            this.root.setAttribute("zero", string, this.default_zeroColor);
        }
    }

    public void setDown(String string) {
        this.down = ColorSet.decodeColor(string);
        if (this.root != null) {
            this.root.setAttribute("down", string, this.default_downColor);
        }
    }

    public void setMissing(String string) {
        this.missing = ColorSet.decodeColor(string);
        if (this.root != null) {
            this.root.setAttribute("missing", string, this.default_missingColor);
        }
    }

    public void setEmpty(String string) {
        this.empty = ColorSet.decodeColor(string);
        if (this.root != null) {
            this.root.setAttribute("empty", string, this.default_emptyColor);
        }
    }

    public void setUp(Color color) {
        this.up = color;
        if (this.root != null) {
            this.root.setAttribute("up", ColorSet.encodeColor(this.up), this.default_upColor);
        }
    }

    public void setZero(Color color) {
        this.zero = color;
        if (this.root != null) {
            this.root.setAttribute("zero", ColorSet.encodeColor(this.zero), this.default_zeroColor);
        }
    }

    public void setDown(Color color) {
        this.down = color;
        if (this.root != null) {
            this.root.setAttribute("down", ColorSet.encodeColor(this.down), this.default_downColor);
        }
    }

    public void setMissing(Color color) {
        this.missing = color;
        if (this.root != null) {
            this.root.setAttribute("missing", ColorSet.encodeColor(this.missing), this.default_missingColor);
        }
    }

    public void setEmpty(Color color) {
        this.empty = color;
        if (this.root != null) {
            this.root.setAttribute("empty", ColorSet.encodeColor(this.empty), this.default_emptyColor);
        }
    }

    public void setName(String string) {
        this.name = string;
        if (this.root != null) {
            this.root.setAttribute("name", string, this.default_name);
        }
    }

    public static final Color decodeColor(String string) {
        return Color.decode(string);
    }

    public static final String encodeColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return "#" + ColorSet.hex(n) + ColorSet.hex(n2) + ColorSet.hex(n3);
    }

    private static final String hex(int n) {
        int n2 = n / 16;
        int n3 = n % 16;
        return ColorSet.hexChar(n2) + ColorSet.hexChar(n3);
    }

    private static final String hexChar(int n) {
        switch (n) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        return "F";
    }
}

