/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.BrowserControl;
import edu.stanford.genetics.treeview.CancelableSettingsDialog;
import edu.stanford.genetics.treeview.CdtFilter;
import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.DragGridPanel;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.HeaderSummaryPanel;
import edu.stanford.genetics.treeview.LoadException;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.MessagePanel;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.ModelessSettingsDialog;
import edu.stanford.genetics.treeview.ReorderedTreeSelection;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.TabbedSettingsPanel;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.UrlSettingsPanel;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.XmlConfig;
import edu.stanford.genetics.treeview.model.AtrTVModel;
import edu.stanford.genetics.treeview.model.ReorderedDataModel;
import edu.stanford.genetics.treeview.model.TVModel;
import edu.stanford.genetics.treeview.plugin.dendroview.ATRView;
import edu.stanford.genetics.treeview.plugin.dendroview.ATRZoomView;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayNameView;
import edu.stanford.genetics.treeview.plugin.dendroview.AtrAligner;
import edu.stanford.genetics.treeview.plugin.dendroview.BitmapColorBarExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.BitmapExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresets;
import edu.stanford.genetics.treeview.plugin.dendroview.DendroException;
import edu.stanford.genetics.treeview.plugin.dendroview.DendrogramFactory;
import edu.stanford.genetics.treeview.plugin.dendroview.DoubleArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSettingsPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.GTRView;
import edu.stanford.genetics.treeview.plugin.dendroview.GlobalView;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.PixelSettingsSelector;
import edu.stanford.genetics.treeview.plugin.dendroview.PostscriptColorBarExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.PostscriptExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.SummaryViewWizard;
import edu.stanford.genetics.treeview.plugin.dendroview.TextViewManager;
import edu.stanford.genetics.treeview.plugin.dendroview.TreeColorer;
import edu.stanford.genetics.treeview.plugin.dendroview.ZoomView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;

public class DendroView
extends JPanel
implements ConfigNodePersistent,
MainPanel,
Observer {
    protected ViewFrame viewFrame;
    protected ScrollPane[] panes;
    protected boolean loaded;
    private DataModel dataModel;
    private int[] arrayIndex = null;
    private int[] geneIndex = null;
    protected JScrollBar globalXscrollbar;
    protected JScrollBar globalYscrollbar;
    protected GlobalView globalview;
    protected JScrollBar zoomXscrollbar;
    protected JScrollBar zoomYscrollbar;
    protected ZoomView zoomview;
    protected TextViewManager textview;
    protected ArrayNameView arraynameview;
    protected GTRView gtrview;
    protected ATRView atrview;
    protected ATRZoomView atrzview;
    protected InvertedTreeDrawer invertedTreeDrawer;
    protected LeftTreeDrawer leftTreeDrawer;
    private TreeSelectionI geneSelection = null;
    private TreeSelectionI arraySelection = null;
    protected MapContainer globalXmap;
    protected MapContainer globalYmap;
    protected MapContainer zoomXmap;
    protected MapContainer zoomYmap;
    protected MessagePanel hintpanel;
    protected MessagePanel statuspanel;
    protected BrowserControl browserControl;
    protected ArrayDrawer arrayDrawer;
    protected ConfigNode root;
    protected JDialog settingsFrame;
    protected TabbedSettingsPanel settingsPanel;
    private static ImageIcon treeviewIcon = null;

    public DendroView(DataModel dataModel, ViewFrame viewFrame) {
        this(dataModel, null, viewFrame, "Dendrogram");
    }

    public DendroView(DataModel dataModel, ConfigNode configNode, ViewFrame viewFrame) {
        this(dataModel, configNode, viewFrame, "Dendrogram");
    }

    public DendroView(DataModel dataModel, ConfigNode configNode, ViewFrame viewFrame, String string) {
        int n;
        HeaderInfo headerInfo;
        super.setName(string);
        this.viewFrame = viewFrame;
        if (configNode == null) {
            if (dataModel.getDocumentConfig() != null) {
                this.bindConfig(dataModel.getDocumentConfig().fetchOrCreate("MainView"));
            } else {
                this.bindConfig((ConfigNode)new DummyConfigNode("MainView"));
            }
        } else {
            this.bindConfig(configNode);
        }
        if (dataModel.getArrayHeaderInfo().getIndex("GROUP") != -1) {
            headerInfo = dataModel.getArrayHeaderInfo();
            n = headerInfo.getIndex("GROUP");
            this.arrayIndex = this.getGroupVector(headerInfo, n);
        } else {
            this.arrayIndex = null;
        }
        if (dataModel.getGeneHeaderInfo().getIndex("GROUP") != -1) {
            System.err.println("got gene group header");
            headerInfo = dataModel.getGeneHeaderInfo();
            n = headerInfo.getIndex("GROUP");
            this.geneIndex = this.getGroupVector(headerInfo, n);
        } else {
            this.geneIndex = null;
        }
        if (this.arrayIndex != null || this.geneIndex != null) {
            dataModel = new ReorderedDataModel(dataModel, this.geneIndex, this.arrayIndex);
        }
        this.setDataModel(dataModel);
        this.setupViews();
        if (this.geneIndex != null) {
            this.setGeneSelection((TreeSelectionI)new ReorderedTreeSelection(this.viewFrame.getGeneSelection(), this.geneIndex));
        } else {
            this.setGeneSelection(this.viewFrame.getGeneSelection());
        }
        if (this.arrayIndex != null) {
            this.setArraySelection((TreeSelectionI)new ReorderedTreeSelection(this.viewFrame.getArraySelection(), this.arrayIndex));
        } else {
            this.setArraySelection(this.viewFrame.getArraySelection());
        }
    }

    private int[] getGroupVector(HeaderInfo headerInfo, int n) {
        int n2 = 0;
        String string = headerInfo.getHeader(0, n);
        for (int i = 0; i < headerInfo.getNumHeaders(); ++i) {
            String string2 = headerInfo.getHeader(i, n);
            if (string.equals(string2)) continue;
            string = string2;
            ++n2;
        }
        int[] nArray = new int[n2 + headerInfo.getNumHeaders()];
        n2 = 0;
        string = headerInfo.getHeader(0, n);
        for (int i = 0; i < headerInfo.getNumHeaders(); ++i) {
            String string3 = headerInfo.getHeader(i, n);
            if (!string.equals(string3)) {
                nArray[i + n2] = -1;
                string = string3;
                ++n2;
            }
            nArray[i + n2] = i;
        }
        return nArray;
    }

    protected DendroView(int n, int n2, String string) {
        super.setName(string);
    }

    protected ConfigNode getFirst(String string) {
        return this.getConfigNode().fetchOrCreate(string);
    }

    public TreeSelectionI getGeneSelection() {
        return this.geneSelection;
    }

    public TreeSelectionI getArraySelection() {
        return this.arraySelection;
    }

    protected void setArraySelection(TreeSelectionI treeSelectionI) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver((Observer)this);
        }
        this.arraySelection = treeSelectionI;
        treeSelectionI.addObserver((Observer)this);
        this.globalview.setArraySelection(treeSelectionI);
        this.zoomview.setArraySelection(treeSelectionI);
        this.atrview.setArraySelection(treeSelectionI);
        this.atrzview.setArraySelection(treeSelectionI);
        this.arraynameview.setArraySelection(treeSelectionI);
    }

    protected void setGeneSelection(TreeSelectionI treeSelectionI) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver((Observer)this);
        }
        this.geneSelection = treeSelectionI;
        treeSelectionI.addObserver((Observer)this);
        this.globalview.setGeneSelection(treeSelectionI);
        this.zoomview.setGeneSelection(treeSelectionI);
        this.gtrview.setGeneSelection(treeSelectionI);
        this.textview.setGeneSelection(treeSelectionI);
    }

    private void flipSelectedGTRNode() {
        TreeDrawerNode treeDrawerNode = this.leftTreeDrawer.getNodeById(this.getGeneSelection().getSelectedNode());
        if (treeDrawerNode == null || treeDrawerNode.isLeaf()) {
            return;
        }
        String string = treeDrawerNode.getId();
        int n = this.getDataModel().getGeneHeaderInfo().getHeaderIndex(treeDrawerNode.getLeft().getLeftLeaf().getId());
        int n2 = this.getDataModel().getGeneHeaderInfo().getHeaderIndex(treeDrawerNode.getRight().getRightLeaf().getId());
        int n3 = this.getDataModel().getDataMatrix().getNumRow();
        int[] nArray = this.SetupInvertedArray(n3, n, n2);
        ((TVModel)this.getDataModel()).reorderGenes(nArray);
        ((Observable)this.getDataModel()).notifyObservers();
        this.updateGTRDrawer(string);
    }

    private int[] SetupInvertedArray(int n, int n2, int n3) {
        int n4;
        int[] nArray = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray[n4] = n4;
        }
        for (n4 = 0; n4 <= n3 - n2; ++n4) {
            nArray[n2 + n4] = n3 - n4;
        }
        return nArray;
    }

    private void flipSelectedATRNode() {
        int n;
        TreeDrawerNode treeDrawerNode = this.invertedTreeDrawer.getNodeById(this.getArraySelection().getSelectedNode());
        if (treeDrawerNode == null || treeDrawerNode.isLeaf()) {
            return;
        }
        String string = treeDrawerNode.getId();
        int n2 = this.getDataModel().getArrayHeaderInfo().getHeaderIndex(treeDrawerNode.getLeft().getLeftLeaf().getId());
        int n3 = this.getDataModel().getArrayHeaderInfo().getHeaderIndex(treeDrawerNode.getRight().getRightLeaf().getId());
        int n4 = this.getDataModel().getDataMatrix().getNumUnappendedCol();
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = n;
        }
        for (n = 0; n <= n3 - n2; ++n) {
            nArray[n2 + n] = n3 - n;
        }
        ((TVModel)this.getDataModel()).reorderArrays(nArray);
        ((TVModel)this.getDataModel()).saveOrder(nArray);
        ((Observable)this.getDataModel()).notifyObservers();
        this.updateATRDrawer(string);
    }

    public void compareToModel(TVModel tVModel) {
        this.getDataModel().removeAppended();
        this.getDataModel().append((DataModel)tVModel);
        this.arraySelection.resize(this.getDataModel().getDataMatrix().getNumCol());
        this.arraySelection.notifyObservers();
        this.globalXmap.setIndexRange(0, this.getDataModel().getDataMatrix().getNumCol() - 1);
        this.globalXmap.notifyObservers();
        this.zoomXmap.setIndexRange(0, this.getDataModel().getDataMatrix().getNumCol() - 1);
        this.zoomXmap.notifyObservers();
        ((Observable)this.getDataModel()).notifyObservers();
    }

    public void alignAtrToModel(AtrTVModel atrTVModel) {
        try {
            String string = null;
            try {
                string = this.getArraySelection().getSelectedNode();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int[] nArray = AtrAligner.align(this.getDataModel().getAtrHeaderInfo(), this.getDataModel().getArrayHeaderInfo(), atrTVModel.getAtrHeaderInfo(), atrTVModel.getArrayHeaderInfo());
            ((TVModel)this.getDataModel()).reorderArrays(nArray);
            ((TVModel)this.getDataModel()).saveOrder(nArray);
            ((Observable)this.getDataModel()).notifyObservers();
            if (string != null) {
                this.updateATRDrawer(string);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private void updateGTRDrawer(String string) {
        TVModel tVModel;
        try {
            tVModel = (TVModel)this.getDataModel();
            this.leftTreeDrawer.setData(tVModel.getGtrHeaderInfo(), tVModel.getGeneHeaderInfo());
            HeaderInfo headerInfo = tVModel.getGtrHeaderInfo();
            if (headerInfo.getIndex("NODECOLOR") >= 0) {
                TreeColorer.colorUsingHeader(this.leftTreeDrawer.getRootNode(), headerInfo, headerInfo.getIndex("NODECOLOR"));
            }
        }
        catch (DendroException dendroException) {
            Box box = new Box(1);
            box.add(new JLabel(dendroException.getMessage()));
            box.add(new JLabel("Perhaps there is a mismatch between your ATR and CDT files?"));
            box.add(new JLabel("Ditching Gene Tree, since it's lame."));
            JOptionPane.showMessageDialog((Component)this.viewFrame, box, "Tree Construction Error", 0);
            ((JComponent)((Object)this.gtrview)).setEnabled(false);
            try {
                this.leftTreeDrawer.setData(null, null);
            }
            catch (DendroException dendroException2) {
                // empty catch block
            }
        }
        tVModel = this.leftTreeDrawer.getRootNode().findNode(string);
        this.geneSelection.setSelectedNode(tVModel.getId());
        this.gtrview.setSelectedNode((TreeDrawerNode)tVModel);
        this.geneSelection.notifyObservers();
        this.leftTreeDrawer.notifyObservers();
    }

    private void updateATRDrawer(String string) {
        TVModel tVModel;
        try {
            tVModel = (TVModel)this.getDataModel();
            this.invertedTreeDrawer.setData(tVModel.getAtrHeaderInfo(), tVModel.getArrayHeaderInfo());
            HeaderInfo headerInfo = tVModel.getAtrHeaderInfo();
            if (headerInfo.getIndex("NODECOLOR") >= 0) {
                TreeColorer.colorUsingHeader(this.invertedTreeDrawer.getRootNode(), headerInfo, headerInfo.getIndex("NODECOLOR"));
            }
        }
        catch (DendroException dendroException) {
            Box box = new Box(1);
            box.add(new JLabel(dendroException.getMessage()));
            box.add(new JLabel("Perhaps there is a mismatch between your ATR and CDT files?"));
            box.add(new JLabel("Ditching Array Tree, since it's lame."));
            JOptionPane.showMessageDialog((Component)this.viewFrame, box, "Tree Construction Error", 0);
            ((JComponent)((Object)this.atrview)).setEnabled(false);
            ((JComponent)((Object)this.atrzview)).setEnabled(false);
            try {
                this.invertedTreeDrawer.setData(null, null);
            }
            catch (DendroException dendroException2) {
                // empty catch block
            }
        }
        tVModel = this.invertedTreeDrawer.getRootNode().findNode(string);
        this.arraySelection.setSelectedNode(tVModel.getId());
        this.atrzview.setSelectedNode((TreeDrawerNode)tVModel);
        this.atrview.setSelectedNode((TreeDrawerNode)tVModel);
        this.arraySelection.notifyObservers();
        this.invertedTreeDrawer.notifyObservers();
    }

    protected AtrTVModel makeAtrModel(FileSet fileSet) throws LoadException {
        AtrTVModel atrTVModel = new AtrTVModel();
        try {
            atrTVModel.loadNew(fileSet);
        }
        catch (LoadException loadException) {
            JOptionPane.showMessageDialog(this, (Object)loadException);
            throw loadException;
        }
        return atrTVModel;
    }

    protected TVModel makeCdtModel(FileSet fileSet) throws LoadException {
        TVModel tVModel = new TVModel();
        try {
            tVModel.loadNew(fileSet);
        }
        catch (LoadException loadException) {
            JOptionPane.showMessageDialog(this, (Object)loadException);
            throw loadException;
        }
        return tVModel;
    }

    protected FileSet offerATRFileSelection() throws LoadException {
        JFileChooser jFileChooser = new JFileChooser();
        this.setupATRFileDialog(jFileChooser);
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            throw new LoadException("File Dialog closed without selection...", 7);
        }
        File file = jFileChooser.getSelectedFile();
        FileSet fileSet = new FileSet(file.getName(), file.getParent() + File.separator);
        return fileSet;
    }

    protected void setupATRFileDialog(JFileChooser jFileChooser) {
        CdtFilter cdtFilter = new CdtFilter();
        try {
            jFileChooser.addChoosableFileFilter((FileFilter)cdtFilter);
            jFileChooser.setAcceptAllFileFilterUsed(true);
        }
        catch (Exception exception) {
            jFileChooser.addChoosableFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return true;
                }

                public String getDescription() {
                    return "All Files";
                }
            });
        }
        jFileChooser.setFileFilter((FileFilter)cdtFilter);
        jFileChooser.setFileSelectionMode(0);
    }

    public MapContainer getGlobalXmap() {
        return this.globalXmap;
    }

    public MapContainer getGlobalYmap() {
        return this.globalYmap;
    }

    public MapContainer getZoomXmap() {
        return this.zoomXmap;
    }

    public MapContainer getZoomYmap() {
        return this.zoomYmap;
    }

    public void scrollToGene(int n) {
        this.getGlobalYmap().scrollToIndex(n);
        this.getGlobalYmap().notifyObservers();
    }

    public void scrollToArray(int n) {
        this.getGlobalXmap().scrollToIndex(n);
        this.getGlobalXmap().notifyObservers();
    }

    public void update(Observable observable, Object object) {
        if (observable == this.geneSelection) {
            this.gtrview.scrollToNode(this.geneSelection.getSelectedNode());
        }
    }

    protected void setupViews() {
        ColorPresets colorPresets = DendrogramFactory.getColorPresets();
        ColorExtractor colorExtractor = new ColorExtractor();
        colorExtractor.setDefaultColorSet(colorPresets.getDefaultColorSet());
        colorExtractor.setMissing(-1.0E7, -2.0E7);
        this.hintpanel = new MessagePanel("Usage Hints");
        this.statuspanel = new MessagePanel("View Status");
        DoubleArrayDrawer doubleArrayDrawer = new DoubleArrayDrawer();
        doubleArrayDrawer.setColorExtractor(colorExtractor);
        this.arrayDrawer = doubleArrayDrawer;
        ((Observable)this.getDataModel()).addObserver(this.arrayDrawer);
        this.globalview = new GlobalView();
        this.globalXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.globalYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.zoomYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXmap = new MapContainer();
        this.zoomXmap.setDefaultScale(12.0);
        this.zoomXmap.setScrollbar(this.zoomXscrollbar);
        this.zoomYmap = new MapContainer();
        this.zoomYmap.setDefaultScale(12.0);
        this.zoomYmap.setScrollbar(this.zoomYscrollbar);
        this.globalXmap = new MapContainer();
        this.globalXmap.setDefaultScale(2.0);
        this.globalXmap.setScrollbar(this.globalXscrollbar);
        this.globalYmap = new MapContainer();
        this.globalYmap.setDefaultScale(2.0);
        this.globalYmap.setScrollbar(this.globalYscrollbar);
        this.globalview.setXMap(this.globalXmap);
        this.globalview.setYMap(this.globalYmap);
        this.globalview.setZoomYMap(this.getZoomYmap());
        this.globalview.setZoomXMap(this.getZoomXmap());
        this.globalview.setArrayDrawer(this.arrayDrawer);
        this.arraynameview = new ArrayNameView(this.getDataModel().getArrayHeaderInfo());
        this.arraynameview.setUrlExtractor(this.viewFrame.getArrayUrlExtractor());
        this.arraynameview.setDataModel(this.getDataModel());
        this.leftTreeDrawer = new LeftTreeDrawer();
        this.gtrview = new GTRView();
        this.gtrview.setMap(this.globalYmap);
        this.gtrview.setLeftTreeDrawer(this.leftTreeDrawer);
        this.gtrview.getHeaderSummary().setIncluded(new int[]{0, 3});
        this.invertedTreeDrawer = new InvertedTreeDrawer();
        this.atrview = new ATRView();
        this.atrview.setMap(this.globalXmap);
        this.atrview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.atrview.getHeaderSummary().setIncluded(new int[]{0, 3});
        this.atrzview = new ATRZoomView();
        this.atrzview.setZoomMap(this.getZoomXmap());
        this.atrzview.setHeaderSummary(this.atrview.getHeaderSummary());
        this.atrzview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.zoomview = new ZoomView();
        this.zoomview.setYMap(this.getZoomYmap());
        this.zoomview.setXMap(this.getZoomXmap());
        this.zoomview.setArrayDrawer(this.arrayDrawer);
        this.arraynameview.setMapping(this.getZoomXmap());
        this.textview = new TextViewManager(this.getDataModel().getGeneHeaderInfo(), this.viewFrame.getUrlExtractor());
        this.textview.setMap(this.getZoomYmap());
        this.doDoubleLayout();
        this.settingsFrame = null;
        this.settingsPanel = null;
        colorExtractor.bindConfig(this.getFirst("ColorExtractor"));
        doubleArrayDrawer.setDataMatrix(this.getDataModel().getDataMatrix());
        doubleArrayDrawer.bindConfig(this.getFirst("ArrayDrawer"));
        this.bindTrees();
        this.zoomview.setHeaders(this.getDataModel().getGeneHeaderInfo(), this.getDataModel().getArrayHeaderInfo());
        this.globalXmap.bindConfig(this.getFirst("GlobalXMap"));
        this.globalYmap.bindConfig(this.getFirst("GlobalYMap"));
        this.getZoomXmap().bindConfig(this.getFirst("ZoomXMap"));
        this.getZoomYmap().bindConfig(this.getFirst("ZoomYMap"));
        this.textview.bindConfig(this.getFirst("TextView"));
        this.arraynameview.bindConfig(this.getFirst("ArrayNameView"));
        HeaderSummary headerSummary = this.atrview.getHeaderSummary();
        this.atrzview.setHeaderSummary(headerSummary);
        headerSummary.bindConfig(this.getFirst("AtrSummary"));
        this.gtrview.getHeaderSummary().bindConfig(this.getFirst("GtrSummary"));
        this.globalXmap.setIndexRange(0, this.dataModel.getDataMatrix().getNumCol() - 1);
        this.globalYmap.setIndexRange(0, this.dataModel.getDataMatrix().getNumRow() - 1);
        this.getZoomXmap().setIndexRange(-1, -1);
        this.getZoomYmap().setIndexRange(-1, -1);
        this.globalXmap.notifyObservers();
        this.globalYmap.notifyObservers();
        this.getZoomXmap().notifyObservers();
        this.getZoomYmap().notifyObservers();
    }

    protected void bindTrees() {
        Box box;
        HeaderInfo headerInfo;
        DataModel dataModel = this.getDataModel();
        if (dataModel != null && dataModel.aidFound()) {
            try {
                ((JComponent)((Object)this.atrview)).setEnabled(true);
                ((JComponent)((Object)this.atrzview)).setEnabled(true);
                this.invertedTreeDrawer.setData(dataModel.getAtrHeaderInfo(), dataModel.getArrayHeaderInfo());
                headerInfo = dataModel.getAtrHeaderInfo();
                if (headerInfo.getIndex("NODECOLOR") >= 0) {
                    TreeColorer.colorUsingHeader(this.invertedTreeDrawer.getRootNode(), headerInfo, headerInfo.getIndex("NODECOLOR"));
                }
            }
            catch (DendroException dendroException) {
                box = new Box(1);
                box.add(new JLabel(dendroException.getMessage()));
                box.add(new JLabel("Perhaps there is a mismatch between your ATR and CDT files?"));
                box.add(new JLabel("Ditching Array Tree, since it's lame."));
                JOptionPane.showMessageDialog((Component)this.viewFrame, box, "Tree Construction Error", 0);
                ((JComponent)((Object)this.atrview)).setEnabled(false);
                ((JComponent)((Object)this.atrzview)).setEnabled(false);
                try {
                    this.invertedTreeDrawer.setData(null, null);
                }
                catch (DendroException dendroException2) {}
            }
        } else {
            ((JComponent)((Object)this.atrview)).setEnabled(false);
            ((JComponent)((Object)this.atrzview)).setEnabled(false);
            try {
                this.invertedTreeDrawer.setData(null, null);
            }
            catch (DendroException dendroException) {
                // empty catch block
            }
        }
        this.invertedTreeDrawer.notifyObservers();
        if (dataModel != null && dataModel.gidFound()) {
            try {
                this.leftTreeDrawer.setData(dataModel.getGtrHeaderInfo(), dataModel.getGeneHeaderInfo());
                headerInfo = dataModel.getGtrHeaderInfo();
                if (headerInfo.getIndex("NODECOLOR") >= 0) {
                    TreeColorer.colorUsingHeader(this.leftTreeDrawer.getRootNode(), dataModel.getGtrHeaderInfo(), headerInfo.getIndex("NODECOLOR"));
                } else {
                    TreeColorer.colorUsingLeaf(this.leftTreeDrawer.getRootNode(), dataModel.getGeneHeaderInfo(), dataModel.getGeneHeaderInfo().getIndex("FGCOLOR"));
                }
                ((JComponent)((Object)this.gtrview)).setEnabled(true);
            }
            catch (DendroException dendroException) {
                box = new Box(1);
                box.add(new JLabel(dendroException.getMessage()));
                box.add(new JLabel("Perhaps there is a mismatch between your GTR and CDT files?"));
                box.add(new JLabel("Ditching Gene Tree, since it's lame."));
                JOptionPane.showMessageDialog((Component)this.viewFrame, box, "Tree Construction Error", 0);
                ((JComponent)((Object)this.gtrview)).setEnabled(false);
                try {
                    this.leftTreeDrawer.setData(null, null);
                }
                catch (DendroException dendroException3) {}
            }
        } else {
            ((JComponent)((Object)this.gtrview)).setEnabled(false);
            try {
                this.leftTreeDrawer.setData(null, null);
            }
            catch (DendroException dendroException) {
                // empty catch block
            }
        }
        this.leftTreeDrawer.notifyObservers();
    }

    private void doSingleLayout() {
        Rectangle rectangle = new Rectangle(0, 0, 1, 2);
        DragGridPanel dragGridPanel = new DragGridPanel(4, 3);
        dragGridPanel.setBorderWidth(2);
        dragGridPanel.setBorderHeight(2);
        dragGridPanel.setMinimumWidth(1);
        dragGridPanel.setMinimumHeight(1);
        dragGridPanel.setFocusWidth(1);
        dragGridPanel.setFocusHeight(1);
        dragGridPanel.addComponent((Component)this.statuspanel, rectangle);
        rectangle.translate(1, 0);
        dragGridPanel.addComponent((Component)((Object)this.atrview), rectangle);
        this.registerView((ModelView)this.atrview);
        rectangle.translate(1, 0);
        rectangle.setSize(1, 1);
        dragGridPanel.addComponent((Component)((Object)this.arraynameview), rectangle);
        this.registerView(this.arraynameview);
        rectangle.translate(0, 1);
        dragGridPanel.addComponent((Component)((Object)this.atrzview), rectangle);
        this.registerView(this.atrzview);
        rectangle.setSize(1, 2);
        rectangle.translate(1, -1);
        dragGridPanel.addComponent((Component)this.hintpanel, rectangle);
        rectangle = new Rectangle(0, 2, 1, 1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)((Object)this.gtrview), "Center");
        jPanel.add((Component)new JScrollBar(0, 0, 1, 0, 0), "South");
        dragGridPanel.addComponent((Component)jPanel, rectangle);
        this.gtrview.setHintPanel(this.hintpanel);
        this.gtrview.setStatusPanel(this.statuspanel);
        this.gtrview.setViewFrame(this.viewFrame);
        rectangle.translate(1, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)((Object)this.globalview), "Center");
        jPanel2.add((Component)this.globalYscrollbar, "East");
        jPanel2.add((Component)this.globalXscrollbar, "South");
        dragGridPanel.addComponent((Component)jPanel2, rectangle);
        this.globalview.setHintPanel(this.hintpanel);
        this.globalview.setStatusPanel(this.statuspanel);
        this.globalview.setViewFrame(this.viewFrame);
        rectangle.translate(1, 0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)((Object)this.zoomview), "Center");
        jPanel3.add((Component)this.zoomYscrollbar, "East");
        jPanel3.add((Component)this.zoomXscrollbar, "South");
        dragGridPanel.addComponent((Component)jPanel3, rectangle);
        this.zoomview.setHintPanel(this.hintpanel);
        this.zoomview.setStatusPanel(this.statuspanel);
        this.zoomview.setViewFrame(this.viewFrame);
        rectangle.translate(1, 0);
        dragGridPanel.addComponent((Component)((Object)this.textview), rectangle);
        this.registerView(this.textview);
        this.add((Component)dragGridPanel);
    }

    protected void doDoubleLayout() {
        DragGridPanel dragGridPanel = new DragGridPanel(2, 2);
        dragGridPanel.setName("LeftDrag");
        DragGridPanel dragGridPanel2 = new DragGridPanel(2, 3);
        dragGridPanel2.setName("RightDrag");
        dragGridPanel.setBorderWidth(2);
        dragGridPanel.setBorderHeight(2);
        dragGridPanel.setMinimumWidth(1);
        dragGridPanel.setMinimumHeight(1);
        dragGridPanel.setFocusWidth(1);
        dragGridPanel.setFocusHeight(1);
        dragGridPanel2.setBorderWidth(2);
        dragGridPanel2.setBorderHeight(2);
        dragGridPanel2.setMinimumWidth(1);
        dragGridPanel2.setMinimumHeight(1);
        dragGridPanel2.setFocusWidth(1);
        dragGridPanel2.setFocusHeight(1);
        float[] fArray = new float[]{0.15f, 0.85f};
        dragGridPanel.setHeights(fArray);
        float[] fArray2 = new float[]{0.35f, 0.65f};
        dragGridPanel.setWidths(fArray2);
        float[] fArray3 = new float[]{0.15f, 0.05f, 0.8f};
        dragGridPanel2.setHeights(fArray3);
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        dragGridPanel.addComponent((Component)this.statuspanel, rectangle);
        rectangle.translate(1, 0);
        dragGridPanel.addComponent((Component)this.atrview.getComponent(), rectangle);
        this.registerView((ModelView)this.atrview);
        rectangle.translate(-1, 0);
        dragGridPanel2.addComponent((Component)this.arraynameview.getComponent(), rectangle);
        this.registerView(this.arraynameview);
        rectangle.translate(0, 1);
        dragGridPanel2.addComponent((Component)this.atrzview.getComponent(), rectangle);
        this.registerView(this.atrzview);
        rectangle.setSize(1, 2);
        rectangle.translate(1, -1);
        dragGridPanel2.addComponent((Component)this.hintpanel, rectangle);
        rectangle = new Rectangle(0, 1, 1, 1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)((Object)this.gtrview), "Center");
        jPanel.add((Component)new JScrollBar(0, 0, 1, 0, 1), "South");
        dragGridPanel.addComponent((Component)jPanel, rectangle);
        this.gtrview.setHintPanel(this.hintpanel);
        this.gtrview.setStatusPanel(this.statuspanel);
        this.gtrview.setViewFrame(this.viewFrame);
        rectangle.translate(1, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)((Object)this.globalview), "Center");
        jPanel2.add((Component)this.globalYscrollbar, "East");
        jPanel2.add((Component)this.globalXscrollbar, "South");
        dragGridPanel.addComponent((Component)jPanel2, rectangle);
        this.registerView((ModelView)this.globalview);
        rectangle.translate(-1, 1);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)((Object)this.zoomview), "Center");
        jPanel3.add((Component)this.zoomXscrollbar, "South");
        jPanel3.add((Component)this.zoomYscrollbar, "East");
        dragGridPanel2.addComponent((Component)jPanel3, rectangle);
        this.registerView((ModelView)this.zoomview);
        rectangle.translate(1, 0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.textview.getComponent(), "Center");
        dragGridPanel2.addComponent((Component)jPanel4, rectangle);
        this.registerView(this.textview);
        JSplitPane jSplitPane = new JSplitPane(1, (Component)dragGridPanel, (Component)dragGridPanel2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(300);
        this.setLayout(new CardLayout());
        this.add((Component)jSplitPane, "running");
    }

    private void registerView(ModelView modelView) {
        modelView.setHintPanel(this.hintpanel);
        modelView.setStatusPanel(this.statuspanel);
        modelView.setViewFrame(this.viewFrame);
    }

    public void populateExportMenu(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Export to Postscript...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapContainer mapContainer;
                MapContainer mapContainer2;
                if (DendroView.this.getArraySelection().getNSelectedIndexes() != 0 || DendroView.this.getGeneSelection().getNSelectedIndexes() != 0) {
                    mapContainer2 = DendroView.this.getZoomXmap();
                    mapContainer = DendroView.this.getZoomYmap();
                } else {
                    mapContainer2 = DendroView.this.getGlobalXmap();
                    mapContainer = DendroView.this.getGlobalYmap();
                }
                PostscriptExportPanel postscriptExportPanel = new PostscriptExportPanel(DendroView.this.arraynameview.getHeaderInfo(), DendroView.this.getDataModel().getGeneHeaderInfo(), DendroView.this.getGeneSelection(), DendroView.this.getArraySelection(), DendroView.this.invertedTreeDrawer, DendroView.this.leftTreeDrawer, DendroView.this.arrayDrawer, mapContainer2, mapContainer);
                postscriptExportPanel.setSourceSet(DendroView.this.getDataModel().getFileSet());
                postscriptExportPanel.setGeneFont(((Component)((Object)DendroView.this.textview)).getFont());
                postscriptExportPanel.setArrayFont(((Component)((Object)DendroView.this.arraynameview)).getFont());
                postscriptExportPanel.setIncludedArrayHeaders(DendroView.this.arraynameview.getHeaderSummary().getIncluded());
                postscriptExportPanel.setIncludedGeneHeaders(DendroView.this.textview.getHeaderSummary().getIncluded());
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)DendroView.this.viewFrame, "Export to Postscript", (SettingsPanel)postscriptExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setAccelerator(88);
        treeviewMenuBarI.setMnemonic(88);
        treeviewMenuBarI.addMenuItem("Export to Image...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapContainer mapContainer;
                MapContainer mapContainer2;
                if (DendroView.this.getArraySelection().getNSelectedIndexes() != 0 || DendroView.this.getGeneSelection().getNSelectedIndexes() != 0) {
                    mapContainer2 = DendroView.this.getZoomXmap();
                    mapContainer = DendroView.this.getZoomYmap();
                } else {
                    mapContainer2 = DendroView.this.getGlobalXmap();
                    mapContainer = DendroView.this.getGlobalYmap();
                }
                BitmapExportPanel bitmapExportPanel = new BitmapExportPanel(DendroView.this.arraynameview.getHeaderInfo(), DendroView.this.getDataModel().getGeneHeaderInfo(), DendroView.this.getGeneSelection(), DendroView.this.getArraySelection(), DendroView.this.invertedTreeDrawer, DendroView.this.leftTreeDrawer, DendroView.this.arrayDrawer, mapContainer2, mapContainer);
                bitmapExportPanel.setSourceSet(DendroView.this.getDataModel().getFileSet());
                bitmapExportPanel.setGeneFont(((Component)((Object)DendroView.this.textview)).getFont());
                bitmapExportPanel.setArrayFont(((Component)((Object)DendroView.this.arraynameview)).getFont());
                bitmapExportPanel.setIncludedArrayHeaders(DendroView.this.arraynameview.getHeaderSummary().getIncluded());
                bitmapExportPanel.setIncludedGeneHeaders(DendroView.this.textview.getHeaderSummary().getIncluded());
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)DendroView.this.viewFrame, "Export to Image", (SettingsPanel)bitmapExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(73);
        treeviewMenuBarI.addMenuItem("Export ColorBar to Postscript...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PostscriptColorBarExportPanel postscriptColorBarExportPanel = new PostscriptColorBarExportPanel(((DoubleArrayDrawer)DendroView.this.arrayDrawer).getColorExtractor());
                postscriptColorBarExportPanel.setSourceSet(DendroView.this.getDataModel().getFileSet());
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)DendroView.this.viewFrame, "Export ColorBar to Postscript", (SettingsPanel)postscriptColorBarExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(66);
        treeviewMenuBarI.addMenuItem("Export ColorBar to Image...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BitmapColorBarExportPanel bitmapColorBarExportPanel = new BitmapColorBarExportPanel(((DoubleArrayDrawer)DendroView.this.arrayDrawer).getColorExtractor());
                bitmapColorBarExportPanel.setSourceSet(DendroView.this.getDataModel().getFileSet());
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)DendroView.this.viewFrame, "Export ColorBar to Image", (SettingsPanel)bitmapColorBarExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(77);
        treeviewMenuBarI.addSeparator();
        this.addSimpleExportOptions(treeviewMenuBarI);
    }

    private String getFilePath() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                return jFileChooser.getSelectedFile().getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            LogBuffer.println((String)("Got exception " + iOException));
        }
        return null;
    }

    private void addSimpleExportOptions(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Save Tree Image", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapContainer mapContainer = DendroView.this.getGlobalXmap();
                MapContainer mapContainer2 = DendroView.this.getGlobalYmap();
                BitmapExportPanel bitmapExportPanel = new BitmapExportPanel(DendroView.this.arraynameview.getHeaderInfo(), DendroView.this.getDataModel().getGeneHeaderInfo(), DendroView.this.getGeneSelection(), DendroView.this.getArraySelection(), DendroView.this.invertedTreeDrawer, DendroView.this.leftTreeDrawer, DendroView.this.arrayDrawer, mapContainer, mapContainer2);
                bitmapExportPanel.setGeneFont(((Component)((Object)DendroView.this.textview)).getFont());
                bitmapExportPanel.setArrayFont(((Component)((Object)DendroView.this.arraynameview)).getFont());
                bitmapExportPanel.setSourceSet(DendroView.this.getDataModel().getFileSet());
                bitmapExportPanel.setDrawSelected(false);
                bitmapExportPanel.includeData(false);
                bitmapExportPanel.includeAtr(false);
                bitmapExportPanel.deselectHeaders();
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)DendroView.this.viewFrame, "Export to Image", (SettingsPanel)bitmapExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(84);
        treeviewMenuBarI.addMenuItem("Save Thumbnail Image", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapContainer mapContainer = DendroView.this.getGlobalXmap();
                MapContainer mapContainer2 = DendroView.this.getGlobalYmap();
                BitmapExportPanel bitmapExportPanel = new BitmapExportPanel(DendroView.this.arraynameview.getHeaderInfo(), DendroView.this.getDataModel().getGeneHeaderInfo(), DendroView.this.getGeneSelection(), DendroView.this.getArraySelection(), DendroView.this.invertedTreeDrawer, DendroView.this.leftTreeDrawer, DendroView.this.arrayDrawer, mapContainer, mapContainer2);
                bitmapExportPanel.setSourceSet(DendroView.this.getDataModel().getFileSet());
                bitmapExportPanel.setGeneFont(((Component)((Object)DendroView.this.textview)).getFont());
                bitmapExportPanel.setArrayFont(((Component)((Object)DendroView.this.arraynameview)).getFont());
                bitmapExportPanel.setDrawSelected(false);
                bitmapExportPanel.includeGtr(false);
                bitmapExportPanel.includeAtr(false);
                bitmapExportPanel.deselectHeaders();
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)DendroView.this.viewFrame, "Export To Image", (SettingsPanel)bitmapExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(72);
        treeviewMenuBarI.addMenuItem("Save Zoomed Image", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapContainer mapContainer = DendroView.this.getZoomXmap();
                MapContainer mapContainer2 = DendroView.this.getZoomYmap();
                BitmapExportPanel bitmapExportPanel = new BitmapExportPanel(DendroView.this.arraynameview.getHeaderInfo(), DendroView.this.getDataModel().getGeneHeaderInfo(), DendroView.this.getGeneSelection(), DendroView.this.getArraySelection(), DendroView.this.invertedTreeDrawer, DendroView.this.leftTreeDrawer, DendroView.this.arrayDrawer, mapContainer, mapContainer2);
                bitmapExportPanel.setSourceSet(DendroView.this.getDataModel().getFileSet());
                bitmapExportPanel.setGeneFont(((Component)((Object)DendroView.this.textview)).getFont());
                bitmapExportPanel.setArrayFont(((Component)((Object)DendroView.this.arraynameview)).getFont());
                bitmapExportPanel.includeGtr(false);
                bitmapExportPanel.includeAtr(false);
                bitmapExportPanel.deselectHeaders();
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)DendroView.this.viewFrame, "Export To Image", (SettingsPanel)bitmapExportPanel);
                cancelableSettingsDialog.pack();
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(90);
    }

    public void showSubDataModel(int[] nArray) {
        this.getViewFrame().showSubDataModel(nArray, null, null);
    }

    public void populateAnalysisMenu(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Flip Array Tree Node", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((Component)((Object)DendroView.this.getGtrview())).hasFocus()) {
                    DendroView.this.flipSelectedGTRNode();
                } else {
                    DendroView.this.flipSelectedATRNode();
                }
            }
        });
        treeviewMenuBarI.setAccelerator(76);
        treeviewMenuBarI.setMnemonic(65);
        treeviewMenuBarI.addMenuItem("Flip Gene Tree Node", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DendroView.this.flipSelectedGTRNode();
            }
        });
        treeviewMenuBarI.setMnemonic(71);
        treeviewMenuBarI.addMenuItem("Align to Tree...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    try {
                        FileSet fileSet = DendroView.this.offerATRFileSelection();
                        AtrTVModel atrTVModel = DendroView.this.makeAtrModel(fileSet);
                        DendroView.this.alignAtrToModel(atrTVModel);
                    }
                    catch (LoadException loadException) {
                        if (loadException.getType() == 4 || loadException.getType() == 7) break block2;
                        LogBuffer.println((String)("Could not open file: " + loadException.getMessage()));
                        loadException.printStackTrace();
                    }
                }
            }
        });
        treeviewMenuBarI.setAccelerator(65);
        treeviewMenuBarI.setMnemonic(71);
        treeviewMenuBarI.addMenuItem("Compare to...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    try {
                        FileSet fileSet = DendroView.this.offerATRFileSelection();
                        TVModel tVModel = DendroView.this.makeCdtModel(fileSet);
                        DendroView.this.compareToModel(tVModel);
                    }
                    catch (LoadException loadException) {
                        if (loadException.getType() == 4 || loadException.getType() == 7) break block2;
                        LogBuffer.println((String)("Could not open file: " + loadException.getMessage()));
                        loadException.printStackTrace();
                    }
                }
            }
        });
        treeviewMenuBarI.setAccelerator(67);
        treeviewMenuBarI.setMnemonic(67);
        treeviewMenuBarI.addMenuItem("Remove comparison", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DendroView.this.getDataModel().removeAppended();
                DendroView.this.globalXmap.setIndexRange(0, DendroView.this.getDataModel().getDataMatrix().getNumCol() - 1);
                DendroView.this.globalXmap.notifyObservers();
                DendroView.this.zoomXmap.setIndexRange(0, DendroView.this.getDataModel().getDataMatrix().getNumCol() - 1);
                DendroView.this.zoomXmap.notifyObservers();
                ((Observable)DendroView.this.getDataModel()).notifyObservers();
            }
        });
        treeviewMenuBarI.setAccelerator(82);
        treeviewMenuBarI.setMnemonic(82);
        treeviewMenuBarI.addMenuItem("Summary Window...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SummaryViewWizard summaryViewWizard = new SummaryViewWizard(DendroView.this);
                int n = JOptionPane.showConfirmDialog(DendroView.this, summaryViewWizard, "Configure Summary", 2);
                if (n == 0) {
                    DendroView.this.showSubDataModel(summaryViewWizard.getIndexes());
                }
            }
        });
        treeviewMenuBarI.setMnemonic(83);
    }

    public void populateSettingsMenu(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Pixel Settings...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorExtractor colorExtractor = null;
                try {
                    colorExtractor = ((DoubleArrayDrawer)DendroView.this.arrayDrawer).getColorExtractor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PixelSettingsSelector pixelSettingsSelector = new PixelSettingsSelector(DendroView.this.globalXmap, DendroView.this.globalYmap, DendroView.this.getZoomXmap(), DendroView.this.getZoomYmap(), colorExtractor, DendrogramFactory.getColorPresets());
                ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)DendroView.this.viewFrame, "Pixel Settings", (SettingsPanel)pixelSettingsSelector);
                System.out.println("showing popup...");
                modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)DendroView.this.getDataModel().getDocumentConfig()));
                modelessSettingsDialog.pack();
                modelessSettingsDialog.setVisible(true);
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(88);
        treeviewMenuBarI.addMenuItem("Url Settings...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedSettingsPanel tabbedSettingsPanel = new TabbedSettingsPanel();
                UrlSettingsPanel urlSettingsPanel = new UrlSettingsPanel(DendroView.this.viewFrame.getUrlExtractor(), DendroView.this.viewFrame.getGeneUrlPresets());
                tabbedSettingsPanel.addSettingsPanel("Gene", (SettingsPanel)urlSettingsPanel);
                UrlSettingsPanel urlSettingsPanel2 = new UrlSettingsPanel(DendroView.this.viewFrame.getArrayUrlExtractor(), DendroView.this.viewFrame.getArrayUrlPresets());
                tabbedSettingsPanel.addSettingsPanel("Array", (SettingsPanel)urlSettingsPanel2);
                ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)DendroView.this.viewFrame, "Url Settings", (SettingsPanel)tabbedSettingsPanel);
                modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)DendroView.this.getDataModel().getDocumentConfig()));
                modelessSettingsDialog.pack();
                modelessSettingsDialog.setVisible(true);
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(85);
        treeviewMenuBarI.addMenuItem("Font Settings...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedSettingsPanel tabbedSettingsPanel = new TabbedSettingsPanel();
                FontSettingsPanel fontSettingsPanel = new FontSettingsPanel(DendroView.this.textview);
                tabbedSettingsPanel.addSettingsPanel("Gene", (SettingsPanel)fontSettingsPanel);
                FontSettingsPanel fontSettingsPanel2 = new FontSettingsPanel(DendroView.this.arraynameview);
                tabbedSettingsPanel.addSettingsPanel("Array", (SettingsPanel)fontSettingsPanel2);
                ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)DendroView.this.viewFrame, "Font Settings", (SettingsPanel)tabbedSettingsPanel);
                modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)DendroView.this.getDataModel().getDocumentConfig()));
                modelessSettingsDialog.pack();
                modelessSettingsDialog.setVisible(true);
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(70);
        treeviewMenuBarI.addMenuItem("Annotations...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedSettingsPanel tabbedSettingsPanel = new TabbedSettingsPanel();
                HeaderSummaryPanel headerSummaryPanel = new HeaderSummaryPanel(DendroView.this.getDataModel().getGeneHeaderInfo(), DendroView.this.textview.getHeaderSummary());
                tabbedSettingsPanel.addSettingsPanel("Gene", (SettingsPanel)headerSummaryPanel);
                HeaderSummaryPanel headerSummaryPanel2 = new HeaderSummaryPanel(DendroView.this.arraynameview.getHeaderInfo(), DendroView.this.arraynameview.getHeaderSummary());
                tabbedSettingsPanel.addSettingsPanel("Array", (SettingsPanel)headerSummaryPanel2);
                HeaderSummaryPanel headerSummaryPanel3 = new HeaderSummaryPanel(DendroView.this.getDataModel().getAtrHeaderInfo(), DendroView.this.atrview.getHeaderSummary());
                tabbedSettingsPanel.addSettingsPanel("Array Tree", (SettingsPanel)headerSummaryPanel3);
                HeaderSummaryPanel headerSummaryPanel4 = new HeaderSummaryPanel(DendroView.this.getDataModel().getGtrHeaderInfo(), DendroView.this.gtrview.getHeaderSummary());
                tabbedSettingsPanel.addSettingsPanel("Gene Tree", (SettingsPanel)headerSummaryPanel4);
                ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)DendroView.this.viewFrame, "Annotation Settings", (SettingsPanel)tabbedSettingsPanel);
                modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)DendroView.this.getDataModel().getDocumentConfig()));
                modelessSettingsDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        ((Component)((Object)(this).DendroView.this.textview)).repaint();
                        ((Component)((Object)(this).DendroView.this.arraynameview)).repaint();
                    }
                });
                modelessSettingsDialog.pack();
                modelessSettingsDialog.setVisible(true);
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(65);
    }

    public void syncConfig() {
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public void setViewFrame(ViewFrame viewFrame) {
        this.viewFrame = viewFrame;
    }

    public ViewFrame getViewFrame() {
        return this.viewFrame;
    }

    protected void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    protected DataModel getDataModel() {
        return this.dataModel;
    }

    public ConfigNode getConfigNode() {
        return this.root;
    }

    public ImageIcon getIcon() {
        if (treeviewIcon == null) {
            try {
                treeviewIcon = new ImageIcon("images/treeview.gif", "TreeView Icon");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return treeviewIcon;
    }

    public ArrayNameView getArraynameview() {
        return this.arraynameview;
    }

    public ATRView getAtrview() {
        return this.atrview;
    }

    public GTRView getGtrview() {
        return this.gtrview;
    }

    public TextViewManager getTextview() {
        return this.textview;
    }
}

