/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.DataMatrix;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import java.awt.Color;
import java.awt.Rectangle;

public class DoubleArrayDrawer
extends ArrayDrawer {
    protected ColorExtractor colorExtractor;
    protected DataMatrix dataMatrix;

    public void setColorExtractor(ColorExtractor colorExtractor) {
        if (this.colorExtractor != null) {
            this.colorExtractor.deleteObserver(this);
        }
        this.colorExtractor = colorExtractor;
        colorExtractor.addObserver(this);
        this.setChanged();
    }

    public ColorExtractor getColorExtractor() {
        return this.colorExtractor;
    }

    public void setDataMatrix(DataMatrix dataMatrix) {
        if (this.dataMatrix != dataMatrix) {
            this.dataMatrix = dataMatrix;
            this.setChanged();
        }
    }

    public void recalculateContrast() {
        double d = 0.0;
        int n = 0;
        int n2 = this.dataMatrix.getNumRow();
        int n3 = this.dataMatrix.getNumCol();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d2 = this.dataMatrix.getValue(i, j);
                if (d2 == -1.0E7 || d2 == -2.0E7) continue;
                d += Math.abs(d2);
                ++n;
            }
        }
        this.colorExtractor.setContrast((d /= (double)n) * 4.0);
        this.colorExtractor.notifyObservers();
    }

    public void paint(int[] nArray, Rectangle rectangle, Rectangle rectangle2, int n, int[] nArray2) {
        if (this.dataMatrix == null) {
            System.out.println("data matrix wasn't set");
        }
        int n2 = rectangle2.y;
        int n3 = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            n2 = rectangle2.y + (rectangle2.height + i * rectangle2.height) / rectangle.height;
            int n4 = n2;
            if (n2 == n4) continue;
            int n5 = rectangle2.x;
            int n6 = 0;
            for (int j = 0; j < rectangle.width; ++j) {
                n5 = rectangle2.x + (rectangle2.width + j * rectangle2.width) / rectangle.width;
                int n7 = n5;
                if (n5 == n7) continue;
                try {
                    int n8;
                    int n9;
                    int n10;
                    double d = 0.0;
                    int n11 = 0;
                    for (n10 = n3; n10 <= i; ++n10) {
                        for (n9 = n6; n9 <= j; ++n9) {
                            double d2;
                            n8 = rectangle.y + n10;
                            if (nArray2 != null) {
                                n8 = nArray2[n8];
                            }
                            if ((d2 = this.dataMatrix.getValue(n9 + rectangle.x, n8)) == -2.0E7) {
                                d = -2.0E7;
                                n11 = 1;
                                break;
                            }
                            if (d2 == -1.0E7) continue;
                            ++n11;
                            d += d2;
                        }
                        if (d == -2.0E7) break;
                    }
                    d = n11 == 0 ? -1.0E7 : (d /= (double)n11);
                    n10 = this.colorExtractor.getARGBColor(d);
                    for (n9 = n7; n9 < n5; ++n9) {
                        for (n8 = n4; n8 < n2; ++n8) {
                            nArray[n9 + n8 * n] = n10;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                n6 = j + 1;
            }
            n3 = i + 1;
        }
    }

    public double getValue(int n, int n2) {
        if (this.dataMatrix == null) {
            System.out.println("dataMatrix was not set in DoubleArrayDrawer");
        }
        return this.dataMatrix.getValue(n, n2);
    }

    public String getSummary(int n, int n2) {
        return "" + this.getValue(n, n2);
    }

    public boolean isMissing(int n, int n2) {
        return this.getValue(n, n2) == -1.0E7;
    }

    public boolean isEmpty(int n, int n2) {
        return this.getValue(n, n2) == -2.0E7;
    }

    public int getNumRow() {
        if (this.dataMatrix != null) {
            return this.dataMatrix.getNumRow();
        }
        return 0;
    }

    public int getNumCol() {
        if (this.dataMatrix != null) {
            return this.dataMatrix.getNumCol();
        }
        return 0;
    }

    public Color getColor(int n, int n2) {
        return this.colorExtractor.getColor(this.getValue(n, n2));
    }

    protected void setDefaults() {
        this.dataMatrix = null;
    }
}

