/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyHeaderInfo;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.LinearTransformation;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.TreeSelection;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.WaitScreen;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayNameView;
import edu.stanford.genetics.treeview.plugin.dendroview.CharArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.TestExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.TextView;
import edu.stanford.genetics.treeview.plugin.dendroview.TreeColorer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ExportPanel
extends JPanel {
    private ConfigNode root;
    private HeaderInfo arrayHeaderInfo;
    private HeaderInfo geneHeaderInfo;
    private FileSet sourceSet;
    private TreeSelectionI geneSelection;
    private TreeSelectionI arraySelection;
    private InvertedTreeDrawer arrayTreeDrawer;
    private LeftTreeDrawer geneTreeDrawer;
    private ArrayDrawer arrayDrawer;
    private MapContainer geneMap;
    private MapContainer arrayMap;
    int borderPixels = 0;
    private static int textSpacing = 2;
    boolean hasChar;
    private FilePanel filePanel;
    private InclusionPanel inclusionPanel;
    private HeaderSelectionPanel headerSelectionPanel;
    private PreviewPanel previewPanel;
    private Font geneFont = new Font("Courier", 0, 12);
    private Font arrayFont = new Font("Courier", 0, 12);
    JCheckBox selectionBox;

    protected HeaderInfo getArrayHeaderInfo() {
        return this.arrayHeaderInfo;
    }

    protected HeaderInfo getGeneHeaderInfo() {
        return this.geneHeaderInfo;
    }

    protected TreeSelectionI getGeneSelection() {
        return this.geneSelection;
    }

    protected TreeSelectionI getArraySelection() {
        return this.arraySelection;
    }

    protected ArrayDrawer getArrayDrawer() {
        return this.arrayDrawer;
    }

    public FileSet getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(FileSet fileSet) {
        this.sourceSet = fileSet;
        if (this.filePanel != null) {
            this.filePanel.setFilePath(this.getInitialFilePath());
        }
    }

    public void setBorderPixels(int n) {
        this.borderPixels = n;
    }

    public int getBorderPixels() {
        return this.borderPixels;
    }

    protected boolean hasBbox() {
        return true;
    }

    protected boolean hasChar() {
        return this.hasChar;
    }

    protected Font getGeneFont() {
        return this.geneFont;
    }

    public void setGeneFont(Font font) {
        if (font != null) {
            this.geneFont = font;
        }
    }

    protected Font getArrayFont() {
        return this.arrayFont;
    }

    public void setArrayFont(Font font) {
        if (font != null) {
            this.arrayFont = font;
        }
    }

    protected boolean includeBbox() {
        return this.inclusionPanel.useBbox();
    }

    protected double getMinGeneCorr() {
        if (this.drawSelected()) {
            TreeDrawerNode treeDrawerNode;
            String string;
            TreeSelectionI treeSelectionI;
            if (this.geneTreeDrawer == null) {
                LogBuffer.println((String)"ExportPanel.getMinGeneCorr: geneTreeDrawer null");
            }
            if ((treeSelectionI = this.getGeneSelection()) == null) {
                LogBuffer.println((String)"ExportPanel.getMinGeneCorr: selection null");
            }
            if ((string = treeSelectionI.getSelectedNode()) == null) {
                LogBuffer.println((String)"ExportPanel.getMinGeneCorr: selectedId null");
            }
            if ((treeDrawerNode = this.geneTreeDrawer.getNodeById(string)) == null) {
                LogBuffer.println((String)("ExportPanel.getMinGeneCorr: selectedNode null , id " + string));
            }
            return treeDrawerNode.getCorr();
        }
        return this.geneTreeDrawer.getCorrMin();
    }

    protected double getMinArrayCorr() {
        if (this.drawSelected()) {
            return this.arrayTreeDrawer.getNodeById(this.getArraySelection().getSelectedNode()).getCorr();
        }
        return this.arrayTreeDrawer.getCorrMin();
    }

    protected int getYmapPixel(double d) {
        double d2 = this.geneMap.getPixel(d) - this.geneMap.getPixel(0);
        double d3 = (int)(d2 * this.getYscale() / this.geneMap.getScale());
        return (int)d3;
    }

    protected int getXmapPixel(double d) {
        double d2 = this.arrayMap.getPixel(d) - this.arrayMap.getPixel(0);
        int n = (int)(d2 * this.getXscale() / this.arrayMap.getScale());
        return n;
    }

    protected boolean geneAnnoInside() {
        return this.headerSelectionPanel.geneAnnoInside();
    }

    protected boolean arrayAnnoInside() {
        return this.headerSelectionPanel.arrayAnnoInside();
    }

    protected String getGeneAnno(int n) {
        return this.headerSelectionPanel.getGeneAnno(n);
    }

    protected String getArrayAnno(int n) {
        return this.headerSelectionPanel.getArrayAnno(n);
    }

    private Color getFgColor(HeaderInfo headerInfo, int n) {
        int n2 = headerInfo.getIndex("FGCOLOR");
        if (n2 > 0) {
            String[] stringArray = headerInfo.getHeader(n);
            return TreeColorer.getColor(stringArray[n2]);
        }
        return null;
    }

    private Color getBgColor(HeaderInfo headerInfo, int n) {
        int n2 = headerInfo.getIndex("BGCOLOR");
        if (n2 > 0) {
            String[] stringArray = headerInfo.getHeader(n);
            return TreeColorer.getColor(stringArray[n2]);
        }
        return null;
    }

    protected Color getGeneFgColor(int n) {
        return this.getFgColor(this.geneHeaderInfo, n);
    }

    protected Color getArrayFgColor(int n) {
        return this.getFgColor(this.arrayHeaderInfo, n);
    }

    protected Color getGeneBgColor(int n) {
        return this.getBgColor(this.geneHeaderInfo, n);
    }

    protected Color getArrayBgColor(int n) {
        return this.getBgColor(this.arrayHeaderInfo, n);
    }

    protected TreeDrawerNode getGeneNode() {
        if (this.inclusionPanel.drawSelected()) {
            return this.geneTreeDrawer.getNodeById(this.geneSelection.getSelectedNode());
        }
        return this.getGeneRootNode();
    }

    protected TreeDrawerNode getArrayNode() {
        if (this.inclusionPanel.drawSelected()) {
            return this.arrayTreeDrawer.getNodeById(this.arraySelection.getSelectedNode());
        }
        return this.getArrayRootNode();
    }

    protected File getFile() {
        return this.filePanel.getFile();
    }

    public String getFilePath() {
        return this.filePanel.getFilePath();
    }

    public void setFilePath(String string) {
        this.filePanel.setFilePath(string);
    }

    protected TreeDrawerNode getGeneRootNode() {
        if (this.geneTreeDrawer == null) {
            return null;
        }
        return this.geneTreeDrawer.getRootNode();
    }

    protected TreeDrawerNode getArrayRootNode() {
        if (this.arrayTreeDrawer == null) {
            return null;
        }
        return this.arrayTreeDrawer.getRootNode();
    }

    protected String getInitialExtension() {
        return ".ps";
    }

    protected String getInitialFilePath() {
        String string = null;
        string = this.sourceSet == null ? System.getProperty("user.home") : this.sourceSet.getDir() + this.sourceSet.getRoot() + this.getInitialExtension();
        if (this.root == null) {
            return string;
        }
        return this.root.getAttribute("file", string);
    }

    public ExportPanel(HeaderInfo headerInfo, HeaderInfo headerInfo2, TreeSelectionI treeSelectionI, TreeSelectionI treeSelectionI2, InvertedTreeDrawer invertedTreeDrawer, LeftTreeDrawer leftTreeDrawer, ArrayDrawer arrayDrawer, MapContainer mapContainer, MapContainer mapContainer2, boolean bl) {
        this.arrayHeaderInfo = headerInfo;
        this.geneHeaderInfo = headerInfo2;
        this.geneSelection = treeSelectionI;
        this.arraySelection = treeSelectionI2;
        this.arrayTreeDrawer = invertedTreeDrawer;
        this.geneTreeDrawer = leftTreeDrawer;
        this.arrayDrawer = arrayDrawer;
        this.arrayMap = mapContainer;
        this.geneMap = mapContainer2;
        this.hasChar = bl;
        this.setupWidgets();
        this.inclusionPanel.synchSelected();
        this.inclusionPanel.synchEnabled();
    }

    public void setIncludedGeneHeaders(int[] nArray) {
        this.headerSelectionPanel.geneList.setSelectedIndices(nArray);
        this.headerSelectionPanel.setupSelected();
    }

    public void setIncludedArrayHeaders(int[] nArray) {
        this.headerSelectionPanel.arrayList.setSelectedIndices(nArray);
        this.headerSelectionPanel.setupSelected();
    }

    public static final void main(String[] stringArray) {
        DummyHeaderInfo dummyHeaderInfo = new DummyHeaderInfo();
        DummyHeaderInfo dummyHeaderInfo2 = new DummyHeaderInfo();
        MapContainer mapContainer = new MapContainer();
        mapContainer.setMap("Fixed");
        mapContainer.setScale(10.0);
        mapContainer.setIndexRange(0, dummyHeaderInfo.getNumHeaders());
        MapContainer mapContainer2 = new MapContainer();
        mapContainer2.setMap("Fixed");
        mapContainer2.setScale(12.0);
        mapContainer2.setIndexRange(0, dummyHeaderInfo2.getNumHeaders());
        TreeSelection treeSelection = new TreeSelection(dummyHeaderInfo2.getNumHeaders());
        TreeSelection treeSelection2 = new TreeSelection(dummyHeaderInfo.getNumHeaders());
        TestExportPanel testExportPanel = new TestExportPanel((HeaderInfo)dummyHeaderInfo, (HeaderInfo)dummyHeaderInfo2, (TreeSelectionI)treeSelection, (TreeSelectionI)treeSelection2, mapContainer, mapContainer2);
        JFrame jFrame = new JFrame("Test Export Panel");
        jFrame.getContentPane().add(testExportPanel);
        jFrame.pack();
        jFrame.show();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public ConfigNode createSubNode() {
        return this.root.create("File");
    }

    private void setupWidgets() {
        Box box = new Box(0);
        this.headerSelectionPanel = new HeaderSelectionPanel();
        box.add(this.headerSelectionPanel);
        this.inclusionPanel = new InclusionPanel();
        box.add(this.inclusionPanel);
        this.previewPanel = new PreviewPanel();
        box.add(this.previewPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(box);
        this.filePanel = new FilePanel(this.getInitialFilePath());
        this.add(this.filePanel);
    }

    protected boolean includeAtr() {
        return this.inclusionPanel.includeAtr();
    }

    protected void includeAtr(boolean bl) {
        this.inclusionPanel.includeAtr(bl);
    }

    protected boolean includeGtr() {
        return this.inclusionPanel.includeGtr();
    }

    protected void includeGtr(boolean bl) {
        this.inclusionPanel.includeGtr(bl);
    }

    protected boolean includeData() {
        return this.inclusionPanel.includeData();
    }

    private boolean includeChar() {
        return this.inclusionPanel.includeChar();
    }

    protected void includeData(boolean bl) {
        this.inclusionPanel.includeData(bl);
    }

    protected boolean drawSelected() {
        return this.inclusionPanel.drawSelected();
    }

    protected boolean includeGeneMap() {
        return this.includeGtr() || this.includeData() || this.numGeneHeaders() > 0;
    }

    protected boolean includeArrayMap() {
        return this.includeAtr() || this.includeData() || this.numArrayHeaders() > 0;
    }

    public double getXmapWidth() {
        return (int)((double)(this.arrayMap.getPixel(this.maxArray() + 1) - this.arrayMap.getPixel(this.minArray())) * this.getXscale() / this.arrayMap.getScale());
    }

    public double getGtrWidth() {
        return 150.0 * this.getXscale() / this.arrayMap.getScale();
    }

    public double getXscale() {
        return this.inclusionPanel.getXscale();
    }

    public double getYmapHeight() {
        double d = (double)(this.geneMap.getPixel(this.maxGene() + 1) - this.geneMap.getPixel(this.minGene())) * this.getYscale() / this.geneMap.getScale();
        return d;
    }

    public double getAtrHeight() {
        return 150.0 * this.getYscale() / this.geneMap.getScale();
    }

    public double getYscale() {
        return this.inclusionPanel.getYscale();
    }

    public int getBboxWidth() {
        return this.inclusionPanel.getBboxWidth();
    }

    public int getBboxHeight() {
        return this.inclusionPanel.getBboxHeight();
    }

    public int minGene() {
        if (this.inclusionPanel.drawSelected()) {
            return this.geneSelection.getMinIndex();
        }
        return 0;
    }

    public int minArray() {
        if (this.inclusionPanel.drawSelected()) {
            return this.arraySelection.getMinIndex();
        }
        return 0;
    }

    public int maxGene() {
        if (this.inclusionPanel.drawSelected()) {
            return this.geneSelection.getMaxIndex();
        }
        return this.geneHeaderInfo.getNumHeaders() - 1;
    }

    public int maxArray() {
        if (this.inclusionPanel.drawSelected()) {
            return this.arraySelection.getMaxIndex();
        }
        return this.arrayHeaderInfo.getNumHeaders() - 1;
    }

    public int estimateHeight() {
        int n = 2 * this.getBorderPixels();
        if (this.includeGeneMap()) {
            n += (int)this.getYmapHeight();
        }
        if (this.includeAtr()) {
            n += (int)this.getAtrHeight();
        }
        return n += this.getArrayAnnoLength();
    }

    public int estimateWidth() {
        int n = 2 * this.getBorderPixels();
        if (this.includeArrayMap()) {
            n += (int)this.getXmapWidth();
        }
        if (this.includeGtr()) {
            n += (int)this.getGtrWidth();
        }
        return n += this.getGeneAnnoLength();
    }

    protected int getGeneAnnoLength() {
        if (this.inclusionPanel == null || !this.inclusionPanel.useBbox()) {
            return this.headerSelectionPanel.geneMaxLength() + textSpacing;
        }
        return this.getBboxWidth();
    }

    protected int getArrayAnnoLength() {
        if (this.inclusionPanel == null || !this.inclusionPanel.useBbox()) {
            return this.headerSelectionPanel.arrayMaxLength() + textSpacing;
        }
        return this.getBboxHeight();
    }

    public int numArrayHeaders() {
        return this.headerSelectionPanel.numArrayHeaders();
    }

    public int numGeneHeaders() {
        return this.headerSelectionPanel.numGeneHeaders();
    }

    public void deselectHeaders() {
        this.headerSelectionPanel.deselectHeaders();
    }

    protected int getDataX() {
        int n = this.getBorderPixels();
        if (this.includeGtr()) {
            n = (int)((double)n + this.getGtrWidth());
        }
        return n;
    }

    protected int getDataY() {
        int n = this.getBorderPixels();
        if (this.includeAtr()) {
            n = (int)((double)n + this.getAtrHeight());
        }
        return n += this.getArrayAnnoLength();
    }

    public void drawAll(Graphics graphics, double d) {
        int n = this.estimateWidth();
        int n2 = this.estimateHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = (int)(d * (double)this.getDataX());
        int n4 = (int)(d * (double)this.getDataY());
        int n5 = (int)(d * (double)this.getBorderPixels());
        this.drawGtr(graphics, n5, n4, d);
        if (this.includeAtr()) {
            if (this.arrayAnnoInside()) {
                this.drawAtr(graphics, n3, n5, d);
                this.drawArrayAnno(graphics, n3, n5 + (int)(d * this.getAtrHeight()), d);
            } else {
                this.drawArrayAnno(graphics, n3, n5, d);
                this.drawAtr(graphics, n3, n4 - (int)(d * this.getAtrHeight()), d);
            }
        } else {
            this.drawArrayAnno(graphics, n3, n5, d);
        }
        this.drawData(graphics, n3, n4, d);
        if (this.includeArrayMap()) {
            this.drawGeneAnno(graphics, n3 + (int)(this.getXmapWidth() * d), n4, d);
        } else {
            this.drawGeneAnno(graphics, n3, n4, d);
        }
    }

    protected void drawGtr(Graphics graphics, int n, int n2, double d) {
        if (!this.includeGtr()) {
            return;
        }
        int n3 = (int)(this.getGtrWidth() * d);
        int n4 = (int)(this.getYmapHeight() * d);
        if (n4 == 0 || n3 == 0) {
            return;
        }
        graphics.setColor(Color.black);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(n, n2, n3, n4);
        double d2 = this.getMinGeneCorr();
        LinearTransformation linearTransformation = new LinearTransformation(d2, (double)rectangle.x, this.geneTreeDrawer.getCorrMax(), (double)(rectangle.x + rectangle.width));
        LinearTransformation linearTransformation2 = new LinearTransformation((double)this.minGene(), (double)rectangle.y, (double)(this.maxGene() + 1), (double)(rectangle.y + rectangle.height));
        this.geneTreeDrawer.paintSubtree(graphics, linearTransformation, linearTransformation2, rectangle, this.getGeneNode(), false);
    }

    protected void drawAtr(Graphics graphics, int n, int n2, double d) {
        if (!this.includeAtr()) {
            return;
        }
        int n3 = (int)(this.getXmapWidth() * d);
        int n4 = (int)(this.getAtrHeight() * d);
        if (n4 == 0 || n3 == 0) {
            return;
        }
        graphics.setColor(Color.black);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(n, n2, n3, n4);
        LinearTransformation linearTransformation = new LinearTransformation((double)this.minArray(), (double)rectangle.x, (double)(this.maxArray() + 1), (double)(rectangle.x + rectangle.width));
        double d2 = this.arrayTreeDrawer.getCorrMin();
        if (this.drawSelected()) {
            d2 = this.arrayTreeDrawer.getNodeById(this.getArraySelection().getSelectedNode()).getCorr();
        }
        LinearTransformation linearTransformation2 = new LinearTransformation(d2, (double)rectangle.y, this.arrayTreeDrawer.getCorrMax(), (double)(rectangle.y + rectangle.height));
        this.arrayTreeDrawer.paintSubtree(graphics, linearTransformation, linearTransformation2, rectangle, this.getArrayNode(), false);
    }

    protected void drawGeneAnnoBox(Graphics graphics, int n, int n2, double d) {
        int n3 = (int)((double)this.getGeneAnnoLength() * d);
        int n4 = (int)(this.getYmapHeight() * d);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = this.getFontMetrics(this.getGeneFont());
        int n5 = (int)((double)fontMetrics.getAscent() * d);
        int n6 = this.minGene();
        int n7 = this.maxGene();
        double d2 = (double)n4 / (double)(n7 - n6 + 1);
        for (int i = n6; i <= n7; ++i) {
            int n8 = n3;
            graphics.fillRect(n, n2 + (int)((double)(i - n6) * d2 + (d2 - (double)n5) / 2.0), n8, n5);
        }
    }

    public void drawArrayAnnoBox(Graphics graphics, int n, int n2, double d) {
        int n3 = (int)((double)this.getArrayAnnoLength() * d);
        int n4 = (int)(this.getXmapWidth() * d);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = this.getFontMetrics(this.getArrayFont());
        int n5 = (int)((double)fontMetrics.getAscent() * d);
        int n6 = this.minArray();
        int n7 = this.maxArray();
        double d2 = (double)n4 / (double)(n7 - n6 + 1);
        for (int i = n6; i <= n7; ++i) {
            int n8 = n3;
            int n9 = n + (int)((double)(i - n6) * d2 + (d2 - (double)n5) / 2.0);
            int n10 = n2 + n3 - n8;
            if (this.headerSelectionPanel.arrayAnnoInside()) {
                n10 = n2;
            }
            graphics.fillRect(n9, n10, n5, n8);
        }
    }

    protected void drawGeneAnno(Graphics graphics, int n, int n2, double d) {
        int n3 = (int)((double)this.getGeneAnnoLength() * d);
        int n4 = (int)(this.getYmapHeight() * d);
        if (n4 == 0 || n3 == 0) {
            return;
        }
        int n5 = this.minGene();
        int n6 = this.maxGene();
        double d2 = (double)n4 / (double)(n6 - n5 + 1);
        MapContainer mapContainer = new MapContainer("Fixed");
        mapContainer.setScale(d2);
        mapContainer.setIndexRange(n5, n6);
        mapContainer.setAvailablePixels(n4 + this.getBorderPixels());
        TextView textView = new TextView(this.geneHeaderInfo, null);
        textView.setMap(mapContainer);
        textView.setHeaderSummary(this.headerSelectionPanel.getGeneSummary());
        Image image = this.createImage(n3 + this.getBorderPixels(), n4 + this.getBorderPixels());
        System.out.println("setting font for genes to " + this.getGeneFont());
        textView.setFace(this.getGeneFont().getName());
        textView.setStyle(this.getGeneFont().getStyle());
        textView.setPoints(this.getGeneFont().getSize());
        textView.updateBuffer(image);
        graphics.drawImage(image, n + textSpacing, n2, null);
    }

    public void drawArrayAnno(Graphics graphics, int n, int n2, double d) {
        int n3 = (int)((double)this.getArrayAnnoLength() * d);
        int n4 = (int)(this.getXmapWidth() * d);
        if (n3 == 0 || n4 == 0) {
            return;
        }
        int n5 = this.minArray();
        int n6 = this.maxArray();
        double d2 = (double)n4 / (double)(n6 - n5 + 1);
        MapContainer mapContainer = new MapContainer("Fixed");
        mapContainer.setScale(d2);
        mapContainer.setIndexRange(n5, n6);
        mapContainer.setAvailablePixels(n4 + this.getBorderPixels());
        ArrayNameView arrayNameView = new ArrayNameView(this.arrayHeaderInfo);
        arrayNameView.setFace(this.getArrayFont().getName());
        arrayNameView.setStyle(this.getArrayFont().getStyle());
        arrayNameView.setPoints(this.getArrayFont().getSize());
        arrayNameView.setHeaderSummary(this.headerSelectionPanel.getArraySummary());
        arrayNameView.setMapping(mapContainer);
        Image image = this.createImage(n4 + this.getBorderPixels(), n3 + this.getBorderPixels());
        image.getGraphics().setFont(this.getArrayFont());
        arrayNameView.updateBuffer(image);
        graphics.drawImage(image, n, n2 - this.getBorderPixels() - textSpacing, null);
    }

    public void drawData(Graphics graphics, int n, int n2, double d) {
        if (!this.includeData()) {
            return;
        }
        int n3 = (int)(this.getYmapHeight() * d);
        int n4 = (int)(this.getXmapWidth() * d);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.minArray(), this.minGene(), this.maxArray() + 1 - this.minArray(), this.maxGene() + 1 - this.minGene());
        Rectangle rectangle2 = new Rectangle();
        rectangle2.setBounds(0, 0, n4, n3);
        int[] nArray = new int[n4 * n3];
        this.arrayDrawer.paint(nArray, rectangle, rectangle2, n4);
        MemoryImageSource memoryImageSource = new MemoryImageSource(n4, n3, nArray, 0, n4);
        Image image = this.createImage(memoryImageSource);
        graphics.drawImage(image, n, n2, null);
        if (this.includeChar()) {
            try {
                Image image2 = this.createImage(n4, n3);
                image2.getGraphics().drawImage(image, 0, 0, null);
                ((CharArrayDrawer)this.arrayDrawer).paintChars(image2.getGraphics(), rectangle, rectangle2);
                graphics.drawImage(image2, n, n2, null);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Problem drawing Sequence data:" + exception);
                LogBuffer.println((String)("" + exception));
                exception.printStackTrace();
                graphics.drawImage(image, n, n2, null);
            }
        } else {
            graphics.drawImage(image, n, n2, null);
        }
    }

    public boolean getDrawSelected() {
        return this.selectionBox.isSelected();
    }

    public void setDrawSelected(boolean bl) {
        this.selectionBox.setSelected(bl);
    }

    class FilePanel
    extends JPanel {
        private JTextField fileField;

        String getFilePath() {
            return this.fileField.getText();
        }

        File getFile() {
            return new File(this.getFilePath());
        }

        void setFilePath(String string) {
            this.fileField.setText(string);
            this.fileField.invalidate();
            this.fileField.revalidate();
            this.fileField.repaint();
        }

        public FilePanel(String string) {
            this.add(new JLabel("Export To: "));
            this.fileField = new JTextField(string);
            this.add(this.fileField);
            JButton jButton = new JButton("Browse");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JFileChooser jFileChooser = new JFileChooser();
                        int n = jFileChooser.showSaveDialog(ExportPanel.this);
                        if (n == 0) {
                            FilePanel.this.fileField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                        }
                    }
                    catch (IOException iOException) {
                        LogBuffer.println((String)("Got exception " + iOException));
                    }
                }
            });
            this.add(jButton);
        }
    }

    class HeaderSelectionPanel
    extends JPanel {
        private JCheckBox geneAnnoInside;
        private JCheckBox arrayAnnoInside;
        private HeaderSummary geneSummary = new HeaderSummary();
        private HeaderSummary arraySummary = new HeaderSummary();
        public JList geneList;
        public JList arrayList;

        public HeaderSummary getGeneSummary() {
            return this.geneSummary;
        }

        public HeaderSummary getArraySummary() {
            return this.arraySummary;
        }

        public String getGeneAnno(int n) {
            return this.geneSummary.getSummary(ExportPanel.this.geneHeaderInfo, n);
        }

        public String getArrayAnno(int n) {
            return this.arraySummary.getSummary(ExportPanel.this.arrayHeaderInfo, n);
        }

        public int arrayMaxLength() {
            if (ExportPanel.this.inclusionPanel == null) {
                return 100;
            }
            FontMetrics fontMetrics = this.getFontMetrics(ExportPanel.this.getArrayFont());
            int n = 0;
            boolean bl = ExportPanel.this.inclusionPanel.drawSelected();
            for (int i = ExportPanel.this.minArray(); i < ExportPanel.this.maxArray(); ++i) {
                int n2;
                String string;
                if (bl && !ExportPanel.this.arraySelection.isIndexSelected(i) || (string = this.getArrayAnno(i)) == null || (n2 = fontMetrics.stringWidth(string)) <= n) continue;
                n = n2;
            }
            return n;
        }

        public int geneMaxLength() {
            if (ExportPanel.this.inclusionPanel == null) {
                return 100;
            }
            FontMetrics fontMetrics = this.getFontMetrics(ExportPanel.this.getGeneFont());
            int n = 0;
            boolean bl = ExportPanel.this.inclusionPanel.drawSelected();
            for (int i = ExportPanel.this.minGene(); i < ExportPanel.this.maxGene(); ++i) {
                int n2 = fontMetrics.stringWidth(this.getGeneAnno(i));
                if (n2 <= n) continue;
                n = n2;
            }
            return n;
        }

        public int getLength(String string) {
            if (string == null) {
                return 0;
            }
            FontMetrics fontMetrics = this.getFontMetrics(ExportPanel.this.getGeneFont());
            return fontMetrics.stringWidth(string);
        }

        public int numArrayHeaders() {
            return this.arrayList.getSelectedIndices().length;
        }

        public int numGeneHeaders() {
            return this.geneList.getSelectedIndices().length;
        }

        public void deselectHeaders() {
            this.arrayList.clearSelection();
            this.geneList.clearSelection();
        }

        public boolean geneAnnoInside() {
            return this.geneAnnoInside.isSelected();
        }

        public boolean arrayAnnoInside() {
            return this.arrayAnnoInside.isSelected();
        }

        public void addNotify() {
            super.addNotify();
            ExportPanel.this.inclusionPanel.recalculateBbox();
        }

        HeaderSelectionPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel("Gene Headers"));
            String[] stringArray = ExportPanel.this.geneHeaderInfo.getNames();
            this.geneList = stringArray == null ? new JList<String>(new String[0]) : new JList<String>(stringArray);
            this.geneList.setVisibleRowCount(5);
            this.add(new JScrollPane(this.geneList));
            this.geneAnnoInside = new JCheckBox("Right of Tree?");
            this.add(new JLabel("Array Headers"));
            String[] stringArray2 = ExportPanel.this.arrayHeaderInfo.getNames();
            this.arrayList = stringArray2 == null ? new JList<String>(new String[0]) : new JList<String>(stringArray2);
            this.arrayList.setVisibleRowCount(5);
            this.add(new JScrollPane(this.arrayList));
            this.arrayAnnoInside = new JCheckBox("Below Tree?");
            this.arrayAnnoInside.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExportPanel.this.inclusionPanel.updateSize();
                    if (ExportPanel.this.previewPanel != null) {
                        ExportPanel.this.previewPanel.updatePreview();
                    }
                }
            });
            this.add(this.arrayAnnoInside);
            ListSelectionListener listSelectionListener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (ExportPanel.this.inclusionPanel != null) {
                        ExportPanel.this.inclusionPanel.recalculateBbox();
                        ExportPanel.this.inclusionPanel.updateSize();
                        HeaderSelectionPanel.this.geneSummary.setIncluded(HeaderSelectionPanel.this.geneList.getSelectedIndices());
                        HeaderSelectionPanel.this.arraySummary.setIncluded(HeaderSelectionPanel.this.arrayList.getSelectedIndices());
                    }
                    if (ExportPanel.this.previewPanel != null) {
                        ExportPanel.this.previewPanel.updatePreview();
                    }
                }
            };
            this.geneList.addListSelectionListener(listSelectionListener);
            this.arrayList.addListSelectionListener(listSelectionListener);
            this.arrayList.setSelectedIndex(0);
            this.geneList.setSelectedIndex(1);
            this.setupSelected();
        }

        public void setupSelected() {
            this.geneSummary.setIncluded(this.geneList.getSelectedIndices());
            this.arraySummary.setIncluded(this.arrayList.getSelectedIndices());
            if (ExportPanel.this.inclusionPanel != null) {
                ExportPanel.this.inclusionPanel.updateSize();
            }
        }
    }

    class InclusionPanel
    extends JPanel {
        JCheckBox gtrBox;
        JCheckBox atrBox;
        JCheckBox dataBox;
        JCheckBox bboxBox;
        JCheckBox charBox;
        JTextField xScaleField;
        JTextField yScaleField;
        JTextField borderField;
        BboxRow bboxRow;
        SizeRow sizeRow;
        DocumentListener documentListener = null;

        public boolean useBbox() {
            return this.bboxBox.isSelected();
        }

        public boolean includeAtr() {
            return this.atrBox.isSelected();
        }

        public void includeAtr(boolean bl) {
            this.atrBox.setSelected(bl);
        }

        public boolean includeGtr() {
            return this.gtrBox.isSelected();
        }

        public void includeGtr(boolean bl) {
            this.gtrBox.setSelected(bl);
        }

        public boolean includeData() {
            return this.dataBox.isSelected();
        }

        public boolean includeChar() {
            if (this.charBox == null) {
                return false;
            }
            boolean bl = this.charBox.isSelected();
            return bl;
        }

        public void includeData(boolean bl) {
            this.dataBox.setSelected(bl);
        }

        public double getXscale() {
            return this.extractDouble(this.xScaleField.getText());
        }

        public double getYscale() {
            return this.extractDouble(this.yScaleField.getText());
        }

        public int getBorderPixels() {
            return (int)this.extractDouble(this.borderField.getText());
        }

        private double extractDouble(String string) {
            try {
                Double d = new Double(string);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }

        public int getBboxWidth() {
            return this.bboxRow.xSize();
        }

        public int getBboxHeight() {
            return this.bboxRow.ySize();
        }

        public boolean drawSelected() {
            return ExportPanel.this.selectionBox.isSelected();
        }

        public void synchEnabled() {
            ExportPanel.this.selectionBox.setEnabled(ExportPanel.this.geneSelection.getNSelectedIndexes() != 0 || ExportPanel.this.arraySelection.getNSelectedIndexes() != 0);
            this.bboxRow.setEnabled(this.bboxBox.isSelected());
            if (ExportPanel.this.getArrayRootNode() == null) {
                this.atrBox.setSelected(false);
                this.atrBox.setEnabled(false);
            } else if (ExportPanel.this.selectionBox.isSelected()) {
                if (ExportPanel.this.arraySelection.getSelectedNode() == null) {
                    this.atrBox.setSelected(false);
                    this.atrBox.setEnabled(false);
                } else {
                    this.atrBox.setEnabled(true);
                }
            } else {
                this.atrBox.setEnabled(true);
            }
            if (ExportPanel.this.getGeneRootNode() == null) {
                this.gtrBox.setSelected(false);
                this.gtrBox.setEnabled(false);
            } else if (ExportPanel.this.selectionBox.isSelected()) {
                if (ExportPanel.this.geneSelection.getSelectedNode() == null) {
                    this.gtrBox.setSelected(false);
                    this.gtrBox.setEnabled(false);
                } else {
                    this.gtrBox.setEnabled(true);
                }
            } else {
                this.gtrBox.setEnabled(true);
            }
            if (ExportPanel.this.arrayDrawer == null) {
                this.dataBox.setSelected(false);
                this.dataBox.setEnabled(false);
            }
            this.updateSize();
            if (ExportPanel.this.previewPanel != null) {
                ExportPanel.this.previewPanel.updatePreview();
            }
        }

        public void synchSelected() {
            ExportPanel.this.selectionBox.setSelected(ExportPanel.this.geneSelection.getNSelectedIndexes() != 0 || ExportPanel.this.arraySelection.getNSelectedIndexes() != 0);
            if (ExportPanel.this.selectionBox.isSelected()) {
                this.atrBox.setSelected(ExportPanel.this.arraySelection.getSelectedNode() != null);
                this.gtrBox.setSelected(ExportPanel.this.geneSelection.getSelectedNode() != null);
            } else {
                this.atrBox.setSelected(ExportPanel.this.getArrayRootNode() != null);
                this.gtrBox.setSelected(ExportPanel.this.getGeneRootNode() != null);
            }
            this.dataBox.setSelected(ExportPanel.this.arrayDrawer != null);
            this.updateSize();
            if (ExportPanel.this.previewPanel != null) {
                ExportPanel.this.previewPanel.updatePreview();
            }
        }

        public void recalculateBbox() {
            if (ExportPanel.this.headerSelectionPanel == null) {
                this.bboxRow.setXsize(2);
                this.bboxRow.setYsize(2);
            } else {
                this.bboxRow.setXsize(ExportPanel.this.headerSelectionPanel.geneMaxLength());
                this.bboxRow.setYsize(ExportPanel.this.headerSelectionPanel.arrayMaxLength());
            }
        }

        public void updateSize() {
            try {
                this.sizeRow.setXsize(ExportPanel.this.estimateWidth());
                this.sizeRow.setYsize(ExportPanel.this.estimateHeight());
                ExportPanel.this.setBorderPixels(this.getBorderPixels());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        InclusionPanel() {
            this.documentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    InclusionPanel.this.updateSize();
                    if (ExportPanel.this.previewPanel != null) {
                        ExportPanel.this.previewPanel.updatePreview();
                    }
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    InclusionPanel.this.updateSize();
                    if (ExportPanel.this.previewPanel != null) {
                        ExportPanel.this.previewPanel.updatePreview();
                    }
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    InclusionPanel.this.updateSize();
                    if (ExportPanel.this.previewPanel != null) {
                        ExportPanel.this.previewPanel.updatePreview();
                    }
                }
            };
            this.setupWidgets();
            this.recalculateBbox();
        }

        private void setupWidgets() {
            this.setLayout(new BoxLayout(this, 1));
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InclusionPanel.this.synchEnabled();
                }
            };
            this.add(new JLabel("Include"));
            ExportPanel.this.selectionBox = new JCheckBox("Selection Only");
            ExportPanel.this.selectionBox.addActionListener(actionListener);
            JPanel jPanel = new JPanel();
            jPanel.add(ExportPanel.this.selectionBox);
            this.add(jPanel);
            this.gtrBox = new JCheckBox("Gene Tree");
            this.gtrBox.addActionListener(actionListener);
            jPanel = new JPanel();
            jPanel.add(this.gtrBox);
            this.add(jPanel);
            this.atrBox = new JCheckBox("Array Tree");
            this.atrBox.addActionListener(actionListener);
            jPanel = new JPanel();
            jPanel.add(this.atrBox);
            this.add(jPanel);
            this.dataBox = new JCheckBox("Data Matrix");
            this.dataBox.addActionListener(actionListener);
            jPanel = new JPanel();
            jPanel.add(this.dataBox);
            this.add(jPanel);
            if (ExportPanel.this.hasChar) {
                this.charBox = new JCheckBox("Sequence");
                this.charBox.addActionListener(actionListener);
                jPanel = new JPanel();
                jPanel.add(this.charBox);
                this.add(jPanel);
            }
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            JPanel jPanel3 = new JPanel();
            this.xScaleField = new JTextField(Double.toString(ExportPanel.this.arrayMap.getScale()));
            jPanel3.add(new JLabel("x scale"));
            jPanel3.add(this.xScaleField);
            jPanel2.add(jPanel3);
            this.yScaleField = new JTextField(Double.toString(ExportPanel.this.geneMap.getScale()));
            JPanel jPanel4 = new JPanel();
            jPanel4.add(new JLabel("y scale"));
            jPanel4.add(this.yScaleField);
            jPanel2.add(jPanel4);
            this.borderField = new JTextField(Double.toString(ExportPanel.this.getBorderPixels()));
            JPanel jPanel5 = new JPanel();
            jPanel5.add(new JLabel("Border "));
            jPanel5.add(this.borderField);
            jPanel2.add(jPanel5);
            jPanel2.add(new JLabel("Use apple key to select multiple headers"));
            this.add(jPanel2);
            this.xScaleField.getDocument().addDocumentListener(this.documentListener);
            this.yScaleField.getDocument().addDocumentListener(this.documentListener);
            this.borderField.getDocument().addDocumentListener(this.documentListener);
            this.bboxBox = new JCheckBox("Bounding Box?", ExportPanel.this.hasBbox());
            this.bboxBox.addActionListener(actionListener);
            jPanel = new JPanel();
            jPanel.add(this.bboxBox);
            this.bboxRow = new BboxRow();
            if (ExportPanel.this.hasBbox()) {
                this.add(jPanel);
                this.add(this.bboxRow);
            }
            this.sizeRow = new SizeRow();
            this.add(this.sizeRow);
        }

        class SizeRow
        extends JPanel {
            JTextField xSize;
            JTextField ySize;
            double conversionFactor = 1.0;

            public SizeRow() {
                this.setupWidgets();
            }

            protected void setupWidgets() {
                this.add(new JLabel("Total Size:"));
                this.xSize = new JTextField("2", 5);
                this.ySize = new JTextField("2", 5);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(pixels)"));
            }

            int xSize() {
                return (int)(InclusionPanel.this.extractDouble(this.xSize.getText()) * this.conversionFactor);
            }

            int ySize() {
                return (int)(InclusionPanel.this.extractDouble(this.ySize.getText()) * this.conversionFactor);
            }

            void setXsize(int n) {
                this.xSize.setText(this.convert(n));
            }

            void setYsize(int n) {
                this.ySize.setText(this.convert(n));
            }

            private String convert(int n) {
                Double d = new Double(Math.rint((double)n * 100.0 / this.conversionFactor) / 100.0);
                return d.toString();
            }

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.xSize.setEnabled(bl);
                this.ySize.setEnabled(bl);
            }
        }

        class BboxRow
        extends SizeRow {
            BboxRow() {
            }

            protected void setupWidgets() {
                DocumentListener documentListener = new DocumentListener(){

                    public void changedUpdate(DocumentEvent documentEvent) {
                        InclusionPanel.this.updateSize();
                        if (ExportPanel.this.previewPanel != null) {
                            ExportPanel.this.previewPanel.updatePreview();
                        }
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        InclusionPanel.this.updateSize();
                        if (ExportPanel.this.previewPanel != null) {
                            ExportPanel.this.previewPanel.updatePreview();
                        }
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        InclusionPanel.this.updateSize();
                        if (ExportPanel.this.previewPanel != null) {
                            ExportPanel.this.previewPanel.updatePreview();
                        }
                    }
                };
                this.add(new JLabel("BBox size:"));
                this.xSize = new JTextField("2", 4);
                this.ySize = new JTextField("2", 4);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(pixels)"));
                this.xSize.getDocument().addDocumentListener(documentListener);
                this.ySize.getDocument().addDocumentListener(documentListener);
            }
        }
    }

    class PreviewPanel
    extends JPanel {
        JCheckBox drawPreview;
        DrawingPanel drawingPanel;
        WaitScreen waitingPanel;

        public void updatePreview() {
            if (this.drawPreview == null || this.drawPreview.isSelected()) {
                this.remove((Component)this.waitingPanel);
                this.add((Component)this.drawingPanel, "Center");
            } else {
                this.remove(this.drawingPanel);
                this.add((Component)this.waitingPanel, "Center");
            }
            this.repaint();
        }

        PreviewPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Preview"), "North");
            this.drawingPanel = new DrawingPanel();
            this.waitingPanel = new WaitScreen(new String[]{"Check Box to", "Display Preview"});
            this.add((Component)this.waitingPanel, "Center");
            this.drawPreview = new JCheckBox("Draw Preview");
            this.drawPreview.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreviewPanel.this.updatePreview();
                }
            });
            this.drawPreview.setSelected(false);
            this.add((Component)this.drawPreview, "South");
        }

        class DrawingPanel
        extends JPanel {
            DrawingPanel() {
            }

            public void paintComponent(Graphics graphics) {
                Dimension dimension = this.getSize();
                int n = ExportPanel.this.estimateWidth();
                int n2 = ExportPanel.this.estimateHeight();
                if (n == 0 || n2 == 0) {
                    return;
                }
                if (n * dimension.height > n2 * dimension.width) {
                    n2 = n2 * dimension.width / n;
                    n = dimension.width;
                } else {
                    n = n * dimension.height / n2;
                    n2 = dimension.height;
                }
                if (PreviewPanel.this.drawPreview == null || PreviewPanel.this.drawPreview.isSelected()) {
                    double d = (double)n / (double)ExportPanel.this.estimateWidth();
                    int n3 = (int)(d * (double)ExportPanel.this.getDataX());
                    int n4 = (int)(d * (double)ExportPanel.this.getDataY());
                    ExportPanel.this.drawGtr(graphics, 0, n4, d);
                    if (ExportPanel.this.includeAtr()) {
                        if (ExportPanel.this.headerSelectionPanel.arrayAnnoInside()) {
                            ExportPanel.this.drawAtr(graphics, n3, 0, d);
                            ExportPanel.this.drawArrayAnnoBox(graphics, n3, (int)(d * ExportPanel.this.getAtrHeight()), d);
                        } else {
                            ExportPanel.this.drawArrayAnnoBox(graphics, n3, 0, d);
                            ExportPanel.this.drawAtr(graphics, n3, n4 - (int)(d * ExportPanel.this.getAtrHeight()), d);
                        }
                    } else {
                        ExportPanel.this.drawArrayAnnoBox(graphics, n3, 0, d);
                    }
                    ExportPanel.this.drawData(graphics, n3, n4, d);
                    if (ExportPanel.this.includeArrayMap()) {
                        ExportPanel.this.drawGeneAnnoBox(graphics, n3 + (int)(ExportPanel.this.getXmapWidth() * d), n4, d);
                    } else {
                        ExportPanel.this.drawGeneAnnoBox(graphics, n3, n4, d);
                    }
                    graphics.setColor(Color.blue);
                    graphics.drawOval(n3 - 2, n4 - 2, 5, 5);
                    graphics.setColor(Color.black);
                } else {
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[4];
                    nArray[0] = 0;
                    nArray[1] = 5;
                    nArray[2] = n;
                    nArray[3] = n - 5;
                    nArray2[0] = 5;
                    nArray2[1] = 0;
                    nArray2[2] = n2 - 5;
                    nArray2[3] = n2;
                    graphics.fillPolygon(nArray, nArray2, 4);
                    nArray2[0] = n2 - 5;
                    nArray2[1] = n2;
                    nArray2[2] = 5;
                    nArray2[3] = 0;
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
    }
}

