/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.LinearTransformation;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.plugin.dendroview.TreeDrawer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Stack;

class InvertedTreeDrawer
extends TreeDrawer {
    InvertedTreeDrawer() {
    }

    public void paint(Graphics graphics, LinearTransformation linearTransformation, LinearTransformation linearTransformation2, Rectangle rectangle, TreeDrawerNode treeDrawerNode) {
        if (this.getRootNode() == null || this.getRootNode().isLeaf()) {
            System.out.println("Root node is null or leaf!");
        } else {
            NodeDrawer nodeDrawer = new NodeDrawer(graphics, linearTransformation, linearTransformation2, treeDrawerNode, rectangle);
            nodeDrawer.draw(this.getRootNode());
        }
    }

    public void paintSubtree(Graphics graphics, LinearTransformation linearTransformation, LinearTransformation linearTransformation2, Rectangle rectangle, TreeDrawerNode treeDrawerNode, boolean bl) {
        if (treeDrawerNode == null || treeDrawerNode.isLeaf() || linearTransformation == null || linearTransformation2 == null) {
            return;
        }
        NodeDrawer nodeDrawer = new NodeDrawer(graphics, linearTransformation, linearTransformation2, null, rectangle);
        nodeDrawer.isSelected = bl;
        nodeDrawer.draw(treeDrawerNode);
    }

    public void paintSubtree(Graphics graphics, LinearTransformation linearTransformation, LinearTransformation linearTransformation2, Rectangle rectangle, TreeDrawerNode treeDrawerNode, TreeDrawerNode treeDrawerNode2) {
        if (treeDrawerNode == null || treeDrawerNode.isLeaf()) {
            return;
        }
        NodeDrawer nodeDrawer = new NodeDrawer(graphics, linearTransformation, linearTransformation2, treeDrawerNode2, rectangle);
        nodeDrawer.draw(treeDrawerNode);
    }

    public void paintSingle(Graphics graphics, LinearTransformation linearTransformation, LinearTransformation linearTransformation2, Rectangle rectangle, TreeDrawerNode treeDrawerNode, boolean bl) {
        if (treeDrawerNode == null || treeDrawerNode.isLeaf()) {
            return;
        }
        NodeDrawer nodeDrawer = new NodeDrawer(graphics, linearTransformation, linearTransformation2, null, rectangle);
        nodeDrawer.isSelected = bl;
        if (!treeDrawerNode.isLeaf()) {
            nodeDrawer.drawSingle(treeDrawerNode);
        } else {
            System.err.println("Root was leaf?");
        }
    }

    class NodeDrawer {
        boolean isSelected = false;
        private Color sel_color = Color.red;
        private Graphics graphics;
        private TreeDrawerNode selected;
        private LinearTransformation xT;
        private LinearTransformation yT;
        private double minInd;
        private double maxInd;
        private Rectangle dest;

        public NodeDrawer(Graphics graphics, LinearTransformation linearTransformation, LinearTransformation linearTransformation2, TreeDrawerNode treeDrawerNode, Rectangle rectangle) {
            this.graphics = graphics;
            this.selected = treeDrawerNode;
            this.xT = linearTransformation;
            this.yT = linearTransformation2;
            this.dest = rectangle;
            this.minInd = (int)linearTransformation.inverseTransform((double)this.dest.x);
            this.maxInd = (int)linearTransformation.inverseTransform((double)(this.dest.x + this.dest.width)) + 1;
        }

        public void draw(TreeDrawerNode treeDrawerNode) {
            Stack<TreeDrawerNode> stack = new Stack<TreeDrawerNode>();
            stack.push(treeDrawerNode);
            while (!stack.empty()) {
                TreeDrawerNode treeDrawerNode2 = (TreeDrawerNode)stack.pop();
                if (treeDrawerNode2.getMaxIndex() < this.minInd || treeDrawerNode2.getMinIndex() > this.maxInd) continue;
                if (treeDrawerNode2 == this.selected) {
                    if (!this.isSelected) {
                        this.isSelected = true;
                        stack.push(this.selected);
                    } else {
                        this.isSelected = false;
                        continue;
                    }
                }
                TreeDrawerNode treeDrawerNode3 = treeDrawerNode2.getLeft();
                TreeDrawerNode treeDrawerNode4 = treeDrawerNode2.getRight();
                if (!treeDrawerNode3.isLeaf()) {
                    stack.push(treeDrawerNode3);
                }
                if (!treeDrawerNode4.isLeaf()) {
                    stack.push(treeDrawerNode4);
                }
                this.drawSingle(treeDrawerNode2);
            }
        }

        private void drawSingle(TreeDrawerNode treeDrawerNode) {
            TreeDrawerNode treeDrawerNode2 = treeDrawerNode.getLeft();
            TreeDrawerNode treeDrawerNode3 = treeDrawerNode.getRight();
            if (this.xT == null) {
                System.err.println("xt was null");
            }
            if (treeDrawerNode3 == null) {
                System.err.println("right was null");
            }
            int n = (int)this.yT.transform(treeDrawerNode3.getCorr());
            int n2 = (int)this.yT.transform(treeDrawerNode2.getCorr());
            int n3 = (int)this.yT.transform(treeDrawerNode.getCorr());
            int n4 = (int)this.xT.transform(treeDrawerNode3.getIndex() + 0.5);
            int n5 = (int)this.xT.transform(treeDrawerNode2.getIndex() + 0.5);
            int n6 = (int)this.xT.transform(treeDrawerNode.getIndex() + 0.5);
            if (this.isSelected) {
                this.graphics.setColor(this.sel_color);
            } else {
                this.graphics.setColor(treeDrawerNode.getColor());
            }
            this.graphics.drawPolyline(new int[]{n4, n4, n5, n5}, new int[]{n, n3, n3, n2}, 4);
        }
    }
}

