/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.PluginFactory;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.SettingsPanelHolder;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.core.PluginManager;
import edu.stanford.genetics.treeview.model.KnnModel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresetEditor;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresets;
import edu.stanford.genetics.treeview.plugin.dendroview.KnnDendroView;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class KnnDendrogramFactory
extends PluginFactory {
    private static ColorPresets colorPresets = new ColorPresets();
    private ColorPresetEditor cpresetEditor = new ColorPresetEditor(colorPresets);
    private JFrame cpresetFrame = null;

    public String getPluginName() {
        return "KnnDendrogram";
    }

    public MainPanel restorePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        KnnDendroView knnDendroView = new KnnDendroView((DataModel)((KnnModel)viewFrame.getDataModel()), configNode, viewFrame);
        knnDendroView.setName(this.getPluginName());
        return knnDendroView;
    }

    public void setGlobalNode(ConfigNode configNode) {
        super.setGlobalNode(configNode);
        colorPresets.bindConfig(configNode.fetchOrCreate("KnnColorPresets"));
        if (colorPresets.getNumPresets() == 0) {
            colorPresets.addDefaultPresets();
        }
        this.cpresetEditor.synchronizeFrom();
    }

    public void addPluginConfig(TreeviewMenuBarI treeviewMenuBarI, final ViewFrame viewFrame) {
        super.addPluginConfig(treeviewMenuBarI, viewFrame);
        treeviewMenuBarI.addMenuItem("KnnDendrogram Color Presets...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (KnnDendrogramFactory.this.cpresetFrame == null) {
                    KnnDendrogramFactory.this.cpresetFrame = new JFrame("KnnDendrogram Color Presets");
                    SettingsPanelHolder settingsPanelHolder = new SettingsPanelHolder((Window)KnnDendrogramFactory.this.cpresetFrame, viewFrame.getApp().getGlobalConfig().getRoot());
                    settingsPanelHolder.addSettingsPanel((SettingsPanel)KnnDendrogramFactory.this.cpresetEditor);
                    KnnDendrogramFactory.this.cpresetFrame.getContentPane().add((Component)settingsPanelHolder);
                }
                KnnDendrogramFactory.this.cpresetFrame.pack();
                ((Component)KnnDendrogramFactory.this.cpresetFrame).setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(78);
    }

    public SettingsPanel getPresetEditor() {
        return this.cpresetEditor;
    }

    public static ColorPresets getColorPresets() {
        return colorPresets;
    }

    public boolean configurePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        return true;
    }

    static {
        PluginManager.registerPlugin((PluginFactory)new KnnDendrogramFactory());
    }
}

