/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractorEditor;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresets;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;
import edu.stanford.genetics.treeview.plugin.dendroview.ContrastSelector;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PixelSettingsSelector
extends JPanel
implements SettingsPanel {
    ScalePanel m_xscale;
    ScalePanel m_yscale;
    ScalePanel m_xZscale;
    ScalePanel m_yZscale;
    ContrastSelector m_contrast;
    LogScaleSelector m_logscale;
    MapContainer m_xmap;
    MapContainer m_ymap;
    MapContainer m_xZmap;
    MapContainer m_yZmap;
    ColorExtractor m_drawer;
    ColorPresets m_presets;
    ColorExtractorEditor colorExtractorEditor;
    ColorPresetsPanel colorPresetsPanel;

    public PixelSettingsSelector(MapContainer mapContainer, MapContainer mapContainer2, MapContainer mapContainer3, MapContainer mapContainer4, ConfigNode configNode, ColorExtractor colorExtractor, ColorPresets colorPresets) {
        this(mapContainer, mapContainer2, mapContainer3, mapContainer4, colorExtractor, colorPresets);
    }

    public PixelSettingsSelector(MapContainer mapContainer, MapContainer mapContainer2, MapContainer mapContainer3, MapContainer mapContainer4, ColorExtractor colorExtractor, ColorPresets colorPresets) {
        this.setLayout(new BoxLayout(this, 1));
        this.m_xmap = mapContainer;
        this.m_ymap = mapContainer2;
        this.m_xZmap = mapContainer3;
        this.m_yZmap = mapContainer4;
        this.m_drawer = colorExtractor;
        this.m_presets = colorPresets;
        this.setupWidgets();
    }

    private void setupWidgets() {
        this.removeAll();
        Border border = BorderFactory.createEtchedBorder();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)new JLabel("Global:"), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(border);
        this.m_xscale = new ScalePanel(this.m_xmap, "X:");
        jPanel.add(this.m_xscale);
        this.m_yscale = new ScalePanel(this.m_ymap, "Y:");
        jPanel.add(this.m_yscale);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.add((Component)new JLabel("Zoom:"), gridBagConstraints);
        jPanel = new JPanel();
        jPanel.setBorder(border);
        this.m_xZscale = new ScalePanel(this.m_xZmap, "X:");
        jPanel.add(this.m_xZscale);
        this.m_yZscale = new ScalePanel(this.m_yZmap, "Y:");
        jPanel.add(this.m_yZscale);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        if (this.m_drawer != null) {
            this.add((Component)new JLabel("Contrast:"), gridBagConstraints);
            this.m_contrast = new ContrastSelector(this.m_drawer);
            this.m_contrast.setBorder(border);
            gridBagConstraints.gridx = 1;
            this.add((Component)this.m_contrast, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            this.add((Component)new JLabel("LogScale:"), gridBagConstraints);
            this.m_logscale = new LogScaleSelector();
            this.m_logscale.setBorder(border);
            gridBagConstraints.gridx = 1;
            this.add((Component)this.m_logscale, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add((Component)new JLabel("Colors:"), gridBagConstraints);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(border);
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            this.colorExtractorEditor = new ColorExtractorEditor(this.m_drawer);
            jPanel2.add(this.colorExtractorEditor);
            jPanel2.add(new CEEButtons());
            this.colorPresetsPanel = new ColorPresetsPanel();
            jPanel2.add(new JScrollPane(this.colorPresetsPanel, 20, 32));
            gridBagConstraints.gridx = 1;
            this.add((Component)jPanel2, gridBagConstraints);
        }
    }

    public void synchronizeFrom() {
        this.setupWidgets();
    }

    public void synchronizeTo() {
    }

    public JDialog showDialog(JFrame jFrame, String string) {
        final JDialog jDialog = new JDialog((Frame)jFrame, string);
        jDialog.setLayout(new BorderLayout());
        jDialog.add((Component)this, "Center");
        final JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    PixelSettingsSelector.this.synchronizeTo();
                    jDialog.dispose();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jDialog.add((Component)jPanel, "South");
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PixelSettingsSelector.this.synchronizeTo();
                jDialog.dispose();
            }
        });
        jDialog.pack();
        return jDialog;
    }

    class ColorPresetsPanel
    extends JPanel {
        ColorPresetsPanel() {
            this.redoLayout();
        }

        public void redoLayout() {
            this.removeAll();
            int n = PixelSettingsSelector.this.m_presets.getNumPresets();
            JButton[] jButtonArray = new JButton[n];
            int n2 = 0;
            while (n2 < n) {
                JButton jButton = new JButton(PixelSettingsSelector.this.m_presets.getPresetNames()[n2]);
                final int n3 = n2++;
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((ColorPresetsPanel)ColorPresetsPanel.this).PixelSettingsSelector.this.colorExtractorEditor.copyStateFrom(((ColorPresetsPanel)ColorPresetsPanel.this).PixelSettingsSelector.this.m_presets.getColorSet(n3));
                    }
                });
                this.add(jButton);
                jButtonArray[n3] = jButton;
            }
        }
    }

    class LogScaleSelector
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField logTextField;
        private JCheckBox logCheckBox = new JCheckBox("Log (base 2)");

        LogScaleSelector() {
            this.logCheckBox.setSelected(PixelSettingsSelector.this.m_drawer.getLogTransform());
            this.logCheckBox.addActionListener(new ActionListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    ((LogScaleSelector)LogScaleSelector.this).PixelSettingsSelector.this.m_drawer.setLogTransform(LogScaleSelector.this.logCheckBox.isSelected());
                    LogScaleSelector.this.logTextField.setEnabled(LogScaleSelector.this.logCheckBox.isSelected());
                    ((LogScaleSelector)LogScaleSelector.this).PixelSettingsSelector.this.m_drawer.notifyObservers();
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((LogScaleSelector)LogScaleSelector.this).PixelSettingsSelector.this.m_drawer.setLogTransform(LogScaleSelector.this.logCheckBox.isSelected());
                    LogScaleSelector.this.logTextField.setEnabled(LogScaleSelector.this.logCheckBox.isSelected());
                    ((LogScaleSelector)LogScaleSelector.this).PixelSettingsSelector.this.m_drawer.setLogBase(2.0);
                    ((LogScaleSelector)LogScaleSelector.this).PixelSettingsSelector.this.m_drawer.notifyObservers();
                }
            });
            this.add(this.logCheckBox);
            this.logTextField = new JTextField(10);
            this.logTextField.setText("" + PixelSettingsSelector.this.m_drawer.getLogCenter());
            this.add(new JLabel("Center:"));
            this.logTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    LogScaleSelector.this.textBoxChanged();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    LogScaleSelector.this.textBoxChanged();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    LogScaleSelector.this.textBoxChanged();
                }
            });
            this.add(this.logTextField);
            this.logTextField.setEnabled(this.logCheckBox.isSelected());
        }

        private void textBoxChanged() {
            try {
                Double d = new Double(this.logTextField.getText());
                PixelSettingsSelector.this.m_drawer.setLogCenter(d);
                PixelSettingsSelector.this.m_drawer.notifyObservers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ColorSelector
    extends JPanel {
        private static final long serialVersionUID = 1L;

        ColorSelector() {
            this.add(new ColorExtractorEditor(PixelSettingsSelector.this.m_drawer));
        }
    }

    class CEEButtons
    extends JPanel {
        CEEButtons() {
            JButton jButton = new JButton("Load...");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(CEEButtons.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        try {
                            ColorSet colorSet = new ColorSet();
                            colorSet.loadEisen(file);
                            ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.colorExtractorEditor.copyStateFrom(colorSet);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(CEEButtons.this, "Could not load from " + file.toString() + "\n" + iOException);
                        }
                    }
                }
            });
            this.add(jButton);
            JButton jButton2 = new JButton("Save...");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showSaveDialog(CEEButtons.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        try {
                            ColorSet colorSet = new ColorSet();
                            ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.colorExtractorEditor.copyStateTo(colorSet);
                            colorSet.saveEisen(file);
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(CEEButtons.this, "Could not save to " + file.toString() + "\n" + iOException);
                        }
                    }
                }
            });
            this.add(jButton2);
            JButton jButton3 = new JButton("Make Preset");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorSet colorSet = new ColorSet();
                    ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.colorExtractorEditor.copyStateTo(colorSet);
                    colorSet.setName("UserDefined");
                    ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.m_presets.addColorSet(colorSet);
                    ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.colorPresetsPanel.redoLayout();
                    ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.colorPresetsPanel.invalidate();
                    ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.colorPresetsPanel.revalidate();
                    ((CEEButtons)CEEButtons.this).PixelSettingsSelector.this.colorPresetsPanel.repaint();
                }
            });
            this.add(jButton3);
        }
    }

    class ScalePanel
    extends JPanel {
        private ButtonGroup type;
        private JRadioButton fixed;
        private JRadioButton fill;
        private JTextField value;
        private MapContainer ymap;

        public ScalePanel(MapContainer mapContainer, String string) {
            this.ymap = mapContainer;
            this.setLayout(new GridLayout(3, 2));
            this.add(new JLabel(string));
            this.add(new JPanel());
            this.type = new ButtonGroup();
            this.fixed = new JRadioButton("Fixed Scale");
            this.type.add(this.fixed);
            this.add(this.fixed);
            this.value = new JTextField(Double.toString(this.ymap.getScale()), 5);
            this.add(this.value);
            this.fill = new JRadioButton("Fill");
            this.type.add(this.fill);
            this.add(this.fill);
            if (mapContainer.getCurrent().type().equals("Fixed")) {
                this.fixed.setSelected(true);
            } else {
                this.fill.setSelected(true);
            }
            this.fill.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ScalePanel.this.updateCheck();
                }
            });
            this.fixed.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ScalePanel.this.updateCheck();
                }
            });
            this.value.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.updateValue();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.updateValue();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.updateValue();
                }
            });
        }

        public void updateCheck() {
            if (this.fixed.isSelected()) {
                this.ymap.setMap("Fixed");
                this.value.setEnabled(true);
            } else {
                this.ymap.setMap("Fill");
                this.value.setEnabled(false);
            }
            this.value.setText(Double.toString(this.ymap.getScale()));
            this.ymap.notifyObservers();
        }

        public void updateValue() {
            if (this.fixed.isSelected()) {
                try {
                    Double d = new Double(this.value.getText());
                    this.ymap.setScale(d);
                    this.ymap.notifyObservers();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

