/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.ExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.TreeColorer;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Stack;

public class PostscriptExportPanel
extends ExportPanel
implements SettingsPanel {
    public PostscriptExportPanel(HeaderInfo headerInfo, HeaderInfo headerInfo2, TreeSelectionI treeSelectionI, TreeSelectionI treeSelectionI2, InvertedTreeDrawer invertedTreeDrawer, LeftTreeDrawer leftTreeDrawer, ArrayDrawer arrayDrawer, MapContainer mapContainer, MapContainer mapContainer2) {
        super(headerInfo, headerInfo2, treeSelectionI, treeSelectionI2, invertedTreeDrawer, leftTreeDrawer, arrayDrawer, mapContainer, mapContainer2, false);
    }

    protected Font getGeneFont() {
        return new Font("Courier", 0, 8);
    }

    protected Font getArrayFont() {
        return new Font("Courier", 0, 8);
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.getFile())));
            DendroPSWriter dendroPSWriter = new DendroPSWriter();
            dendroPSWriter.write(printStream);
            printStream.close();
        }
        catch (Exception exception) {
            LogBuffer.println((String)("PostscriptExportPanel.save() caught exception " + exception));
            exception.printStackTrace();
        }
    }

    class DendroPSWriter {
        private double scaleGTR;
        private double corrGTR;
        private int offsetGTR = 5;
        private double scaleATR;
        private double corrATR;
        private int offsetATR = 5;

        DendroPSWriter() {
        }

        private void writeHeader(PrintStream printStream) {
            int n = PostscriptExportPanel.this.estimateWidth();
            int n2 = PostscriptExportPanel.this.estimateHeight();
            printStream.println("%!PS-Adobe-3.0");
            if (PostscriptExportPanel.this.includeBbox()) {
                printStream.println("%%BoundingBox: 0 0 " + n + " " + n2);
            }
            printStream.println("%%Creator: DendroPSWriter (a Java TreeView Component)");
            printStream.println("%%CreationDate: " + new Date().toString());
            printStream.println("%%Pages: (atend)");
            printStream.println("%%EndComments");
            printStream.println("%%BeginSetup");
            printStream.println("/ln { newpath moveto lineto stroke closepath } bind def");
            printStream.println("/tx { newpath moveto show closepath } bind def");
            printStream.println("/sl { setlinewidth } def");
            printStream.println("/sc { setlinecap } def");
            printStream.println("/sr { setrgbcolor } def");
            printStream.println("/sf { exch findfont exch scalefont setfont } def");
            printStream.println("/tr { translate } def");
            printStream.println("/sp { 1 sc 1 sl 0.0 0.0 0.0 sr 18.00000 13.00000 tr 0.96000 0.98205 scale tr } def");
            printStream.println("/fb {exch dup 0 rlineto exch 0 exch rlineto neg 0 rlineto closepath fill } bind def");
            printStream.println("/consLineTo {1 index 1 index lineto stroke moveto} bind def");
            printStream.println("/snGTR {1 index moveto 1 index exch consLineTo 1 index consLineTo lineto stroke} bind def");
            printStream.println("/snATR {1 index exch moveto 1 index consLineTo 1 index exch consLineTo exch lineto stroke } bind def");
            printStream.println("%%EndSetup");
            printStream.println("%%Page: tree 1");
            printStream.println("%%PageResources: (atend)");
            printStream.println("%%BeginPageSetup");
            printStream.println("/pgsave save def");
            printStream.println("%%EndPageSetup");
        }

        private void writeBoxes(PrintStream printStream) {
            int n = (int)PostscriptExportPanel.this.getYmapHeight();
            int n2 = (int)PostscriptExportPanel.this.getXmapWidth();
            if (PostscriptExportPanel.this.includeGtr()) {
                printStream.println("% make room for gtrview");
                printStream.println(PostscriptExportPanel.this.getGtrWidth() + " 0 translate");
            }
            int n3 = PostscriptExportPanel.this.getYmapPixel((double)PostscriptExportPanel.this.minGene() - 0.5);
            int n4 = -PostscriptExportPanel.this.getXmapPixel((double)PostscriptExportPanel.this.minArray() - 0.5);
            printStream.println("% account for offset into data matrix");
            printStream.println(n4 + " " + n3 + " translate");
            int n5 = PostscriptExportPanel.this.maxGene();
            for (int i = PostscriptExportPanel.this.minGene(); i <= PostscriptExportPanel.this.maxGene(); ++i) {
                int n6 = PostscriptExportPanel.this.maxArray();
                for (int j = PostscriptExportPanel.this.minArray(); j <= n6; ++j) {
                    Color color = PostscriptExportPanel.this.getArrayDrawer().getColor(j, i);
                    printStream.println(this.convertColor(color) + " sr");
                    int n7 = PostscriptExportPanel.this.getXmapPixel((double)j - 0.5);
                    int n8 = PostscriptExportPanel.this.getYmapPixel((double)i - 0.5);
                    int n9 = PostscriptExportPanel.this.getXmapPixel((double)j + 0.5);
                    int n10 = PostscriptExportPanel.this.getYmapPixel((double)i + 0.5);
                    printStream.println(n7 + " " + (n - n10) + " moveto");
                    int n11 = n9 - n7;
                    int n12 = n10 - n8;
                    printStream.println(n11 + " " + n12 + " fb");
                }
            }
            printStream.println(-n4 + " " + -n3 + " translate");
            if (PostscriptExportPanel.this.includeGtr()) {
                printStream.println(-PostscriptExportPanel.this.getGtrWidth() + " 0 translate");
            }
        }

        private Color getColor(HeaderInfo headerInfo, int n) {
            int n2 = headerInfo.getIndex("FGCOLOR");
            if (n2 > 0) {
                String[] stringArray = headerInfo.getHeader(n);
                return TreeColorer.getColor(stringArray[n2]);
            }
            return Color.black;
        }

        private void writeGeneNames(PrintStream printStream) {
            int n;
            if (PostscriptExportPanel.this.getGeneAnnoLength() <= 0) {
                return;
            }
            if (PostscriptExportPanel.this.includeArrayMap()) {
                printStream.println(PostscriptExportPanel.this.getXmapWidth() + " 0 translate");
            }
            if (PostscriptExportPanel.this.includeGtr()) {
                printStream.println(PostscriptExportPanel.this.getGtrWidth() + " 0 translate");
            }
            printStream.println(" /Courier findfont");
            printStream.println("8 scalefont");
            printStream.println("setfont");
            int n2 = PostscriptExportPanel.this.getYmapPixel((double)PostscriptExportPanel.this.minGene() - 0.5);
            int n3 = 0;
            printStream.println("% account for offset into data matrix");
            printStream.println(n3 + " " + n2 + " translate");
            int n4 = (int)PostscriptExportPanel.this.getYmapHeight();
            int n5 = PostscriptExportPanel.this.maxGene();
            for (n = PostscriptExportPanel.this.minGene(); n <= n5; ++n) {
                Color color = PostscriptExportPanel.this.getGeneBgColor(n);
                if (color == null) continue;
                int n6 = 0;
                int n7 = PostscriptExportPanel.this.getYmapPixel((double)n - 0.5);
                int n8 = PostscriptExportPanel.this.getGeneAnnoLength();
                int n9 = PostscriptExportPanel.this.getYmapPixel((double)n + 0.5);
                printStream.println(this.convertColor(color) + " sr");
                printStream.println(n6 + " " + (n4 - n9) + " moveto");
                int n10 = n8 - n6;
                int n11 = n9 - n7;
                printStream.println(n10 + " " + n11 + " fb");
            }
            for (n = PostscriptExportPanel.this.minGene(); n <= n5; ++n) {
                int n12 = PostscriptExportPanel.this.getYmapPixel((double)n + 0.25);
                String string = PostscriptExportPanel.this.getGeneAnno(n);
                Color color = PostscriptExportPanel.this.getGeneFgColor(n);
                if (string == null) continue;
                if (color != null) {
                    printStream.println(this.convertColor(color) + " sr");
                }
                printStream.println("0 " + (n4 - n12) + " moveto");
                printStream.println("( " + this.psEscape(string) + " ) show");
            }
            printStream.println(-n3 + " " + -n2 + " translate");
            if (PostscriptExportPanel.this.includeGtr()) {
                printStream.println(-PostscriptExportPanel.this.getGtrWidth() + " 0 translate");
            }
            if (PostscriptExportPanel.this.includeArrayMap()) {
                printStream.println(-PostscriptExportPanel.this.getXmapWidth() + " 0 translate");
            }
        }

        private void writeArrayNames(PrintStream printStream) {
            int n;
            if (PostscriptExportPanel.this.getArrayAnnoLength() <= 0) {
                return;
            }
            int n2 = 0;
            int n3 = 0;
            if (PostscriptExportPanel.this.includeGeneMap()) {
                n2 = (int)((double)n2 + PostscriptExportPanel.this.getYmapHeight());
            }
            if (PostscriptExportPanel.this.includeAtr() && !PostscriptExportPanel.this.arrayAnnoInside()) {
                n2 = (int)((double)n2 + PostscriptExportPanel.this.getAtrHeight());
            }
            if (PostscriptExportPanel.this.includeGtr()) {
                n3 = (int)((double)n3 + PostscriptExportPanel.this.getGtrWidth());
            }
            printStream.println(n3 + " " + n2 + " translate");
            int n4 = -PostscriptExportPanel.this.getXmapPixel((double)PostscriptExportPanel.this.minArray() - 0.5);
            int n5 = 0;
            printStream.println("% account for offset into data matrix");
            printStream.println(n4 + " " + n5 + " translate");
            printStream.println("0 0 0 sr");
            printStream.println(" /Courier findfont");
            printStream.println("8 scalefont");
            printStream.println("setfont");
            printStream.println("90 rotate");
            int n6 = PostscriptExportPanel.this.maxArray();
            for (n = PostscriptExportPanel.this.minArray(); n <= n6; ++n) {
                Color color = PostscriptExportPanel.this.getArrayBgColor(n);
                if (color == null) continue;
                int n7 = 0;
                int n8 = PostscriptExportPanel.this.getXmapPixel((double)n - 0.5);
                int n9 = PostscriptExportPanel.this.getArrayAnnoLength();
                int n10 = PostscriptExportPanel.this.getXmapPixel((double)n + 0.5);
                printStream.println(this.convertColor(color) + " sr");
                printStream.println(n7 + " " + -n10 + " moveto");
                int n11 = n9 - n7;
                int n12 = n10 - n8;
                printStream.println(n11 + " " + n12 + " fb");
            }
            for (n = PostscriptExportPanel.this.minArray(); n <= n6; ++n) {
                int n13 = PostscriptExportPanel.this.getXmapPixel((double)n + 0.25);
                String string = PostscriptExportPanel.this.getArrayAnno(n);
                Color color = PostscriptExportPanel.this.getArrayFgColor(n);
                if (string == null) continue;
                if (color != null) {
                    printStream.println(this.convertColor(color) + " sr");
                }
                printStream.println("0 " + -n13 + " moveto");
                printStream.println("( " + this.psEscape(string) + " ) show");
            }
            printStream.println("-90 rotate");
            printStream.println(-n4 + " " + -n5 + " translate");
            printStream.println(-n3 + " " + -n2 + " translate");
        }

        private String psEscape(String string) {
            String string2 = "()";
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (string2.indexOf(c) >= 0) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        private String convertColor(Color color) {
            return this.convertRGB(color.getRed()) + " " + this.convertRGB(color.getGreen()) + " " + this.convertRGB(color.getBlue());
        }

        private float convertRGB(int n) {
            return (float)n / 255.0f;
        }

        private void writeFooter(PrintStream printStream) {
            printStream.println("showpage");
        }

        private void writeGTR(PrintStream printStream) {
            if (!PostscriptExportPanel.this.includeGtr()) {
                return;
            }
            this.corrGTR = PostscriptExportPanel.this.getMinGeneCorr();
            this.scaleGTR = (PostscriptExportPanel.this.getGtrWidth() - (double)this.offsetGTR) / (1.0 - this.corrGTR);
            printStream.println(this.offsetGTR / 2 + " 0 translate");
            int n = PostscriptExportPanel.this.getYmapPixel((double)PostscriptExportPanel.this.minGene() - 0.5);
            int n2 = 0;
            printStream.println("% account for offset into data matrix");
            printStream.println(n2 + " " + n + " translate");
            this.interateGTR(printStream, PostscriptExportPanel.this.getGeneNode());
            printStream.println(this.convertColor(Color.black) + " sr");
            printStream.println(-n2 + " " + -n + " translate");
            printStream.println(-this.offsetGTR / 2 + " 0 translate");
        }

        private void writeATR(PrintStream printStream) {
            if (!PostscriptExportPanel.this.includeAtr()) {
                return;
            }
            this.corrATR = PostscriptExportPanel.this.getMinArrayCorr();
            this.scaleATR = (PostscriptExportPanel.this.getAtrHeight() - (double)this.offsetATR) / (1.0 - this.corrATR);
            int n = 0;
            int n2 = 0;
            if (PostscriptExportPanel.this.includeGtr()) {
                n = (int)((double)n + PostscriptExportPanel.this.getGtrWidth());
            }
            if (PostscriptExportPanel.this.includeGeneMap()) {
                n2 = (int)((double)n2 + PostscriptExportPanel.this.getYmapHeight());
            }
            if (PostscriptExportPanel.this.arrayAnnoInside()) {
                n2 += PostscriptExportPanel.this.getArrayAnnoLength();
            }
            printStream.println(n + " " + (n2 - this.offsetATR / 2) + " translate");
            int n3 = -PostscriptExportPanel.this.getXmapPixel((double)PostscriptExportPanel.this.minArray() - 0.5);
            int n4 = 0;
            printStream.println("% account for offset into data matrix");
            printStream.println(n3 + " " + n4 + " translate");
            this.recurseATR(printStream, PostscriptExportPanel.this.getArrayNode());
            printStream.println(this.convertColor(Color.black) + " sr");
            printStream.println(-n3 + " " + -n4 + " translate");
            printStream.println(-n + " " + (-n2 + this.offsetATR / 2) + " translate");
        }

        private void interateGTR(PrintStream printStream, TreeDrawerNode treeDrawerNode) {
            int n = (int)PostscriptExportPanel.this.getYmapHeight();
            Stack<TreeDrawerNode> stack = new Stack<TreeDrawerNode>();
            stack.push(treeDrawerNode);
            while (!stack.empty()) {
                TreeDrawerNode treeDrawerNode2 = (TreeDrawerNode)stack.pop();
                TreeDrawerNode treeDrawerNode3 = treeDrawerNode2.getLeft();
                TreeDrawerNode treeDrawerNode4 = treeDrawerNode2.getRight();
                int n2 = (int)(this.scaleGTR * (treeDrawerNode4.getCorr() - this.corrGTR));
                int n3 = (int)(this.scaleGTR * (treeDrawerNode3.getCorr() - this.corrGTR));
                int n4 = (int)(this.scaleGTR * (treeDrawerNode2.getCorr() - this.corrGTR));
                int n5 = PostscriptExportPanel.this.getYmapPixel(treeDrawerNode4.getIndex());
                int n6 = PostscriptExportPanel.this.getYmapPixel(treeDrawerNode3.getIndex());
                Color color = treeDrawerNode2.getColor();
                printStream.println(this.convertColor(color) + " sr");
                printStream.println(n2 + " " + (n - n5) + " " + n4 + " " + (n - n6) + " " + n3 + " snGTR");
                if (!treeDrawerNode3.isLeaf()) {
                    stack.push(treeDrawerNode3);
                }
                if (treeDrawerNode4.isLeaf()) continue;
                stack.push(treeDrawerNode4);
            }
        }

        private void recurseATR(PrintStream printStream, TreeDrawerNode treeDrawerNode) {
            int n = (int)PostscriptExportPanel.this.getAtrHeight();
            TreeDrawerNode treeDrawerNode2 = treeDrawerNode.getLeft();
            TreeDrawerNode treeDrawerNode3 = treeDrawerNode.getRight();
            int n2 = (int)(this.scaleATR * (treeDrawerNode3.getCorr() - this.corrATR));
            int n3 = (int)(this.scaleATR * (treeDrawerNode2.getCorr() - this.corrATR));
            int n4 = (int)(this.scaleATR * (treeDrawerNode.getCorr() - this.corrATR));
            int n5 = PostscriptExportPanel.this.getXmapPixel(treeDrawerNode3.getIndex());
            int n6 = PostscriptExportPanel.this.getXmapPixel(treeDrawerNode2.getIndex());
            Color color = treeDrawerNode.getColor();
            printStream.println(this.convertColor(color) + " sr");
            printStream.println(n - n2 + " " + n5 + " " + (n - n4) + " " + n6 + " " + (n - n3) + " snATR");
            if (!treeDrawerNode2.isLeaf()) {
                this.recurseATR(printStream, treeDrawerNode2);
            }
            if (!treeDrawerNode3.isLeaf()) {
                this.recurseATR(printStream, treeDrawerNode3);
            }
        }

        public void write(PrintStream printStream) {
            this.writeHeader(printStream);
            if (PostscriptExportPanel.this.includeGtr()) {
                this.writeGTR(printStream);
            }
            if (PostscriptExportPanel.this.includeAtr()) {
                this.writeATR(printStream);
            }
            this.writeArrayNames(printStream);
            this.writeGeneNames(printStream);
            if (PostscriptExportPanel.this.includeData()) {
                this.writeBoxes(printStream);
            }
            this.writeFooter(printStream);
            if (printStream.checkError()) {
                LogBuffer.println((String)"Some error occured during PostScript export");
            }
        }
    }
}

