/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.DataMatrix;

class SimpleDataMatrix
implements DataMatrix {
    int nRow;
    int nCol;
    double[] dataMatrix;
    int appendIndex = -1;

    public SimpleDataMatrix(double[] dArray, int n, int n2) {
        this.dataMatrix = dArray;
        this.nRow = n;
        this.nCol = n2;
    }

    public int getNumRow() {
        return this.nRow;
    }

    public int getNumCol() {
        return this.nCol;
    }

    public int getNumUnappendedCol() {
        return this.appendIndex == -1 ? this.getNumCol() : this.appendIndex;
    }

    public double getValue(int n, int n2) {
        return this.dataMatrix[n + n2 * this.nCol];
    }

    public void removeAppended() {
        if (this.appendIndex == -1) {
            return;
        }
        double[] dArray = new double[this.nRow * this.appendIndex];
        for (int i = 0; i < this.nRow * this.appendIndex; ++i) {
            dArray[i] = this.dataMatrix[i];
        }
        this.appendIndex = -1;
    }

    public void append(DataMatrix dataMatrix) {
        double[] dArray = new double[this.dataMatrix.length + dataMatrix.getNumRow() * dataMatrix.getNumCol()];
        for (int i = 0; i < this.dataMatrix.length; ++i) {
            dArray[i] = this.dataMatrix[i];
        }
        for (int i = 0; i < dataMatrix.getNumCol(); ++i) {
            for (int j = 0; j < dataMatrix.getNumRow(); ++j) {
                dArray[i++] = dataMatrix.getValue(j, i);
            }
        }
        this.appendIndex = this.nCol;
        this.nCol += dataMatrix.getNumCol();
        this.dataMatrix = dArray;
    }

    public void setValue(double d, int n, int n2) {
        this.dataMatrix[n + n2 * this.nCol] = d;
    }
}

