/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import java.util.Vector;

public abstract class TreeAnalysisNode {
    TreeAnalysisNode left;
    TreeAnalysisNode right;
    TreeAnalysisNode parent;
    String id;
    int index;

    TreeAnalysisNode(String string) {
        this.id = string;
        this.left = null;
        this.right = null;
        this.parent = null;
    }

    TreeAnalysisNode(String string, TreeAnalysisNode treeAnalysisNode) {
        this.id = string;
        this.left = null;
        this.right = null;
        this.parent = treeAnalysisNode;
    }

    public String getID() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    public TreeAnalysisNode getLeftLeaf() {
        if (this.isLeaf()) {
            return this;
        }
        if (this.left != null) {
            return this.left.getLeftLeaf();
        }
        return this.right.getLeftLeaf();
    }

    public TreeAnalysisNode getRightLeaf() {
        if (this.isLeaf()) {
            return this;
        }
        if (this.right != null) {
            return this.right.getRightLeaf();
        }
        return this.left.getRightLeaf();
    }

    public void flip() {
        TreeAnalysisNode treeAnalysisNode = this.left;
        this.left = this.right;
        this.right = treeAnalysisNode;
    }

    public void enumerate(Vector vector) {
        if (this.left != null) {
            this.left.enumerate(vector);
        }
        vector.add(this);
        if (this.right != null) {
            this.right.enumerate(vector);
        }
    }

    public TreeAnalysisNode findRoot() {
        if (this.isRoot()) {
            return this;
        }
        return this.parent.findRoot();
    }

    public TreeAnalysisNode find(String string) {
        TreeAnalysisNode treeAnalysisNode;
        if (this.getID().equals(string)) {
            return this;
        }
        if (this.left != null && (treeAnalysisNode = this.left.find(string)) != null) {
            return treeAnalysisNode;
        }
        if (this.right != null && (treeAnalysisNode = this.right.find(string)) != null) {
            return treeAnalysisNode;
        }
        return null;
    }

    public void setLeft(TreeAnalysisNode treeAnalysisNode) {
        this.left = treeAnalysisNode;
    }

    public TreeAnalysisNode getLeft() {
        return this.left;
    }

    public void setRight(TreeAnalysisNode treeAnalysisNode) {
        this.right = treeAnalysisNode;
    }

    public TreeAnalysisNode getRight() {
        return this.right;
    }

    public void setParent(TreeAnalysisNode treeAnalysisNode) {
        this.parent = treeAnalysisNode;
    }

    public TreeAnalysisNode getParent() {
        return this.parent;
    }
}

