/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoView;

class Averager {
    public static final int SIMPLE = 0;
    public static final int NEAREST = 1;
    public static final int NEIGHBOR = 2;
    public static final int INTERVAL = 3;
    protected KaryoView karyoView;
    private ConfigNode configNode = new DummyConfigNode("Averager");
    protected String[] message = new String[2];

    Averager() {
    }

    public void setKaryoView(KaryoView karyoView) {
        this.karyoView = karyoView;
    }

    public KaryoView getKaryoView() {
        return this.karyoView;
    }

    public void bindConfig(ConfigNode configNode) {
        this.configNode = configNode;
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public String[] getDescription(ChromosomeLocus chromosomeLocus, int n) {
        int n2 = chromosomeLocus.getCdtIndex();
        this.message[0] = "Gene " + this.getKaryoView().getGeneInfo().getHeader(n2, "YORF");
        this.message[1] = "No averaging";
        return this.message;
    }

    public double getValue(ChromosomeLocus chromosomeLocus, int n) {
        int n2 = chromosomeLocus.getCdtIndex();
        int n3 = this.karyoView.getNumCol();
        return this.karyoView.getDataMatrix().getValue(n, n2);
    }

    public int getType() {
        return 0;
    }

    public String getArg() {
        return null;
    }
}

