/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.Util;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;

public class CoordinatesPresets {
    private ConfigNode root = new DummyConfigNode("Coordinates");
    private static final int dIndex = -1;

    public CoordinatesPresets(ConfigNode configNode) {
        this.bindConfig(configNode);
        if (this.getPresetNames().length == 0) {
            this.addDefaultPresets();
        }
    }

    public CoordinatesPresets() {
    }

    public int getDefaultIndex() {
        return this.root.getAttribute("default", -1);
    }

    public boolean isDefaultEnabled() {
        return this.getDefaultIndex() != -1;
    }

    public FileSet getDefaultFileSet() {
        int n = this.getDefaultIndex();
        try {
            return this.getFileSet(n);
        }
        catch (Exception exception) {
            return this.getFileSet(0);
        }
    }

    public void setDefaultIndex(int n) {
        this.root.setAttribute("default", n, -1);
    }

    public void addDefaultPresets() {
    }

    public String[] getPresetNames() {
        ConfigNode[] configNodeArray = this.root.fetch("FileSet");
        String[] stringArray = new String[configNodeArray.length];
        for (int i = 0; i < configNodeArray.length; ++i) {
            FileSet fileSet = new FileSet(configNodeArray[i]);
            stringArray[i] = fileSet.getName();
        }
        return stringArray;
    }

    public int getNumPresets() {
        ConfigNode[] configNodeArray = this.root.fetch("FileSet");
        return configNodeArray.length;
    }

    public String toString() {
        ConfigNode[] configNodeArray = this.root.fetch("FileSet");
        String string = "";
        string = this.getDefaultIndex() < 0 ? "Default is to parse file\n" : "Default is " + this.getPresetNames()[this.getDefaultIndex()] + " index " + this.getDefaultIndex() + "\n";
        for (int i = 0; i < configNodeArray.length; ++i) {
            FileSet fileSet = new FileSet(configNodeArray[i]);
            string = string + fileSet.getName() + " " + fileSet.toString() + "\n";
        }
        return string;
    }

    public FileSet getFileSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("FileSet");
        try {
            FileSet fileSet = new FileSet(configNodeArray[n]);
            return fileSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileSet getFileSet(String string) {
        ConfigNode[] configNodeArray = this.root.fetch("FileSet");
        for (int i = 0; i < configNodeArray.length; ++i) {
            FileSet fileSet = new FileSet(configNodeArray[i]);
            if (!string.equals(fileSet.getName())) continue;
            return fileSet;
        }
        return null;
    }

    public void addFileSet(String string) {
        FileSet fileSet = new FileSet(this.root.create("FileSet"));
        fileSet.setName(string);
    }

    public void addFileSet(FileSet fileSet) {
        FileSet fileSet2 = new FileSet(this.root.create("FileSet"));
        fileSet2.copyState(fileSet);
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public void removeFileSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("FileSet");
        this.root.remove(configNodeArray[n]);
    }

    private ConfigNode createSubNode() {
        return this.root.create("FileSet");
    }

    public void scanUrl(URL uRL) {
        if (uRL.getProtocol().startsWith("file")) {
            FileFilter fileFilter;
            File file = new File(Util.URLtoFilePath((String)uRL.getPath()));
            File[] fileArray = file.listFiles(fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return !file.getName().startsWith(".");
                }
            });
            if (fileArray == null) {
                JOptionPane.showMessageDialog(null, "Could not list " + file.toString());
            } else {
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        FileSet fileSet = new FileSet(fileArray[i].getName(), file.getCanonicalPath() + File.separator);
                        fileSet.setName(fileSet.getRoot());
                        this.addFileSet(fileSet);
                        continue;
                    }
                    catch (HeadlessException headlessException) {
                        headlessException.printStackTrace();
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }
}

