/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ColorIcon;
import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.LinkedViewFrame;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.TreeSelection;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.app.LinkedViewApp;
import edu.stanford.genetics.treeview.model.TVModel;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoColorPresets;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoColorSet;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoDrawer;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DisplaySettingsPanel
extends JPanel
implements SettingsPanel {
    private KaryoColorPresets presets;
    private KaryoPanel karyoPanel;
    private ViewFrame frame = null;
    private ColorConfigPanel colorPanel;
    private ColorPresetsPanel colorPresetsPanel;
    private DrawPanel drawPanel;
    private ScalePanel scalePanel;
    private SelectedPanel selectedPanel;

    public void setPresets(KaryoColorPresets karyoColorPresets) {
        this.presets = karyoColorPresets;
    }

    public KaryoColorPresets getPresets() {
        return this.presets;
    }

    public void setKaryoPanel(KaryoPanel karyoPanel) {
        this.karyoPanel = karyoPanel;
    }

    public KaryoPanel getKaryoPanel() {
        return this.karyoPanel;
    }

    public static final void main(String[] stringArray) {
        LinkedViewApp linkedViewApp = new LinkedViewApp();
        LinkedViewFrame linkedViewFrame = new LinkedViewFrame(linkedViewApp);
        KaryoPanel karyoPanel = new KaryoPanel((DataModel)new TVModel(), (TreeSelectionI)new TreeSelection(2), (ViewFrame)linkedViewFrame, (ConfigNode)new DummyConfigNode("Display Settings Panel"));
        KaryoColorPresets karyoColorPresets = new KaryoColorPresets();
        DisplaySettingsPanel displaySettingsPanel = new DisplaySettingsPanel(karyoPanel, karyoColorPresets, (ViewFrame)linkedViewFrame);
        displaySettingsPanel.revalidate();
        JFrame jFrame = new JFrame("Test Display Settings Panel");
        jFrame.getContentPane().add(displaySettingsPanel);
        jFrame.pack();
        jFrame.show();
    }

    public DisplaySettingsPanel(KaryoPanel karyoPanel, KaryoColorPresets karyoColorPresets, ViewFrame viewFrame) {
        this.setKaryoPanel(karyoPanel);
        this.setPresets(karyoColorPresets);
        this.setFrame(viewFrame);
        this.addWidgets();
    }

    public void setFrame(ViewFrame viewFrame) {
        this.frame = viewFrame;
    }

    public ViewFrame getFrame() {
        return this.frame;
    }

    private void addWidgets() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)new JLabel("Draw"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.drawPanel = new DrawPanel();
        this.add((Component)this.drawPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel("Scale Lines"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.scalePanel = new ScalePanel();
        this.add((Component)this.scalePanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)new JLabel("Colors"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.colorPanel = new ColorConfigPanel();
        this.add((Component)this.colorPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)new JLabel("Selected"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.selectedPanel = new SelectedPanel();
        this.add((Component)this.selectedPanel, gridBagConstraints);
    }

    public void synchronizeTo() {
        this.selectedPanel.setValues();
        this.drawPanel.setValues();
        this.scalePanel.setValues();
    }

    public void synchronizeFrom() {
        this.selectedPanel.getValues();
        this.drawPanel.getValues();
        this.scalePanel.getValues();
    }

    private static String reformatInt(int n) {
        Integer n2 = new Integer(n);
        return n2.toString();
    }

    private static String reformatDouble(double d) {
        int n = 1;
        if (Math.abs(d) < 1.0E-7) {
            return "0.0000";
        }
        while (Math.abs(d * (double)n) < 1000.0) {
            n *= 10;
        }
        int n2 = (int)(d * (double)n);
        Double d2 = new Double((double)n2 / (double)n);
        return d2.toString();
    }

    class SelectedPanel
    extends JPanel {
        JComboBox iconBox;
        JComboBox iconSize;
        private KaryoDrawer karyoDrawer = null;

        public SelectedPanel() {
            if (DisplaySettingsPanel.this.karyoPanel != null) {
                this.karyoDrawer = DisplaySettingsPanel.this.karyoPanel.getKaryoDrawer();
            }
            this.iconBox = new JComboBox();
            String[] stringArray = this.karyoDrawer.getIconTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                this.iconBox.addItem(stringArray[i]);
            }
            this.iconSize = new JComboBox();
            int[] nArray = this.karyoDrawer.getIconSizes();
            for (int i = 0; i < nArray.length; ++i) {
                this.iconSize.addItem(DisplaySettingsPanel.reformatInt(nArray[i]));
            }
            this.add(new JLabel("Highlight Selected with "));
            this.add(this.iconBox);
            this.add(this.iconSize);
            this.getValues();
            this.iconBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SelectedPanel.this.setValues();
                }
            });
            this.iconSize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SelectedPanel.this.setValues();
                }
            });
        }

        public void getValues() {
            if (this.karyoDrawer != null) {
                this.iconBox.setSelectedIndex(this.karyoDrawer.getIconType());
                this.iconSize.setSelectedIndex(this.karyoDrawer.getIconSize());
                this.revalidate();
            }
        }

        public void setValues() {
            if (this.karyoDrawer != null) {
                this.karyoDrawer.setIconType(this.iconBox.getSelectedIndex());
                this.karyoDrawer.setIconSize(this.iconSize.getSelectedIndex());
                this.karyoDrawer.notifyObservers();
            }
        }
    }

    public class ColorPanel
    extends JPanel {
        ColorIcon colorIcon;
        int type;

        public ColorPanel(int n) {
            this.type = n;
            this.redoComps();
        }

        public void redoColor() {
            this.colorIcon.setColor(this.getColor());
        }

        public void redoComps() {
            this.removeAll();
            this.colorIcon = new ColorIcon(10, 10, this.getColor());
            JButton jButton = new JButton(this.getLabel(), (Icon)this.colorIcon);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(ColorPanel.this, "Pick Color for " + ColorPanel.this.getLabel(), ColorPanel.this.getColor());
                    if (color != null) {
                        ColorPanel.this.setColor(color);
                        ((Component)((Object)DisplaySettingsPanel.this.karyoPanel.getKaryoView())).repaint();
                    }
                }
            });
            this.add(jButton);
        }

        private void setColor(Color color) {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.getKaryoPanel().getKaryoDrawer();
            KaryoColorSet karyoColorSet = karyoDrawer.getKaryoColorSet();
            karyoColorSet.setColor(this.type, color);
            this.colorIcon.setColor(this.getColor());
            this.repaint();
        }

        private String getLabel() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.getKaryoPanel().getKaryoDrawer();
            KaryoColorSet karyoColorSet = karyoDrawer.getKaryoColorSet();
            return karyoColorSet.getType(this.type);
        }

        private Color getColor() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.getKaryoPanel().getKaryoDrawer();
            KaryoColorSet karyoColorSet = karyoDrawer.getKaryoColorSet();
            return karyoColorSet.getColor(this.type);
        }
    }

    class ColorPresetsPanel
    extends JPanel {
        ColorPresetsPanel() {
            this.redoLayout();
        }

        public void redoLayout() {
            this.removeAll();
            int n = DisplaySettingsPanel.this.presets.getNumPresets();
            JButton[] jButtonArray = new JButton[n];
            int n2 = 0;
            while (n2 < n) {
                JButton jButton = new JButton(DisplaySettingsPanel.this.presets.getPresetNames()[n2]);
                final int n3 = n2++;
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DisplaySettingsPanel.this.colorPanel.copyStateFrom(DisplaySettingsPanel.this.presets.getColorSet(n3));
                    }
                });
                this.add(jButton);
                jButtonArray[n3] = jButton;
            }
        }
    }

    class ColorConfigPanel
    extends JPanel {
        private final ColorPanel[] colorPanels = new ColorPanel[6];

        ColorConfigPanel() {
            try {
                this.setBorder(BorderFactory.createEtchedBorder(1));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            for (int i = 0; i < 6; ++i) {
                this.colorPanels[i] = new ColorPanel(i);
            }
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.add(this.colorPanels[0]);
            jPanel.add(this.colorPanels[1]);
            jPanel.add(this.colorPanels[2]);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.colorPanels[3]);
            jPanel2.add(this.colorPanels[4]);
            jPanel2.add(this.colorPanels[5]);
            this.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            JButton jButton = new JButton("Load...");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(DisplaySettingsPanel.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.getKaryoPanel().getKaryoDrawer();
                        KaryoColorSet karyoColorSet = karyoDrawer.getKaryoColorSet();
                        karyoColorSet.load(file.getPath());
                        for (int i = 0; i < 6; ++i) {
                            ColorConfigPanel.this.colorPanels[i].redoColor();
                        }
                        ColorConfigPanel.this.repaint();
                        ((Component)((Object)DisplaySettingsPanel.this.karyoPanel.getKaryoView())).repaint();
                    }
                }
            });
            jPanel3.add(jButton);
            JButton jButton2 = new JButton("Save...");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showSaveDialog(DisplaySettingsPanel.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.getKaryoPanel().getKaryoDrawer();
                        KaryoColorSet karyoColorSet = karyoDrawer.getKaryoColorSet();
                        karyoColorSet.save(file.getPath());
                    }
                }
            });
            jPanel3.add(jButton2);
            JButton jButton3 = new JButton("Make Preset");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoColorSet karyoColorSet = new KaryoColorSet();
                    KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.getKaryoPanel().getKaryoDrawer();
                    KaryoColorSet karyoColorSet2 = karyoDrawer.getKaryoColorSet();
                    karyoColorSet.copyStateFrom(karyoColorSet2);
                    karyoColorSet.setName("UserDefined");
                    DisplaySettingsPanel.this.presets.addColorSet(karyoColorSet);
                    DisplaySettingsPanel.this.colorPresetsPanel.redoLayout();
                    DisplaySettingsPanel.this.colorPresetsPanel.invalidate();
                    DisplaySettingsPanel.this.colorPresetsPanel.revalidate();
                    DisplaySettingsPanel.this.colorPresetsPanel.repaint();
                }
            });
            jPanel3.add(jButton3);
            this.add(jPanel3);
            DisplaySettingsPanel.this.colorPresetsPanel = new ColorPresetsPanel();
            this.add(new JScrollPane(DisplaySettingsPanel.this.colorPresetsPanel));
        }

        public void copyStateFrom(KaryoColorSet karyoColorSet) {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.getKaryoPanel().getKaryoDrawer();
            KaryoColorSet karyoColorSet2 = karyoDrawer.getKaryoColorSet();
            karyoColorSet2.copyStateFrom(karyoColorSet);
            for (int i = 0; i < 6; ++i) {
                this.colorPanels[i].redoColor();
            }
            this.repaint();
            ((Component)((Object)DisplaySettingsPanel.this.karyoPanel.getKaryoView())).repaint();
        }

        public void getValues() {
        }

        public void setValues() {
        }
    }

    class ScalePanel
    extends JPanel {
        JCheckBox aboveBox;
        JCheckBox belowBox;
        JTextField baseField;
        JTextField maxField;

        ScalePanel() {
            this.setAlignmentX(0.0f);
            this.aboveBox = new JCheckBox("above");
            this.belowBox = new JCheckBox("below");
            this.baseField = new JTextField("2.0");
            this.maxField = new JTextField("5");
            this.add(this.aboveBox);
            this.add(this.belowBox);
            this.add(new JLabel(" base"));
            this.add(this.baseField);
            this.add(new JLabel(" #"));
            this.add(this.maxField);
            this.aboveBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalePanel.this.setValues();
                }
            });
            this.belowBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScalePanel.this.setValues();
                }
            });
            this.baseField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setBase();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setBase();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setBase();
                }
            });
            this.maxField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setMax();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setMax();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setMax();
                }
            });
        }

        public void getValues() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.karyoPanel.getKaryoDrawer();
            this.aboveBox.setSelected(karyoDrawer.getLinesAbove());
            this.belowBox.setSelected(karyoDrawer.getLinesBelow());
            this.baseField.setText(DisplaySettingsPanel.reformatDouble(karyoDrawer.getLinesBase()));
            int n = karyoDrawer.getLinesMax();
            this.maxField.setText(DisplaySettingsPanel.reformatInt(n));
            this.revalidate();
        }

        public void setBase() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.karyoPanel.getKaryoDrawer();
            try {
                Double d = new Double(this.baseField.getText());
                karyoDrawer.setLinesBase(d);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            karyoDrawer.notifyObservers();
        }

        public void setMax() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.karyoPanel.getKaryoDrawer();
            try {
                Integer n = new Integer(this.maxField.getText());
                karyoDrawer.setLinesMax(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            karyoDrawer.notifyObservers();
        }

        public void setValues() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.karyoPanel.getKaryoDrawer();
            karyoDrawer.setLinesAbove(this.aboveBox.isSelected());
            karyoDrawer.setLinesBelow(this.belowBox.isSelected());
            this.setBase();
            this.setMax();
            karyoDrawer.notifyObservers();
        }
    }

    class DrawPanel
    extends JPanel {
        JCheckBox lineBox;
        JCheckBox barBox;

        DrawPanel() {
            this.setAlignmentX(0.0f);
            this.lineBox = new JCheckBox("lines");
            this.barBox = new JCheckBox("bars");
            this.add(this.lineBox);
            this.add(this.barBox);
            this.lineBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DrawPanel.this.setValues();
                }
            });
            this.barBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DrawPanel.this.setValues();
                }
            });
        }

        public void getValues() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.karyoPanel.getKaryoDrawer();
            this.lineBox.setSelected(karyoDrawer.getLineChart());
            this.barBox.setSelected(karyoDrawer.getBarChart());
            this.revalidate();
        }

        public void setValues() {
            KaryoDrawer karyoDrawer = DisplaySettingsPanel.this.karyoPanel.getKaryoDrawer();
            karyoDrawer.setLineChart(this.lineBox.isSelected());
            karyoDrawer.setBarChart(this.barBox.isSelected());
            karyoDrawer.notifyObservers();
        }
    }
}

