/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.GroupAverager;

class IntervalAverager
extends GroupAverager {
    double defaultWidth = 1.0;

    public void setWidth(double d) {
        this.getConfigNode().setAttribute("width", d, this.defaultWidth);
    }

    public double getWidth() {
        return this.getConfigNode().getAttribute("width", this.defaultWidth);
    }

    public IntervalAverager() {
    }

    public IntervalAverager(double d) {
        this.setWidth(d);
    }

    public int getType() {
        return 3;
    }

    public String getArg() {
        return "" + this.getWidth();
    }

    protected String getPre() {
        return "Interval size " + this.getWidth() + " units around ";
    }

    protected ChromosomeLocus[] getContributors(ChromosomeLocus chromosomeLocus) {
        ChromosomeLocus chromosomeLocus2 = chromosomeLocus.getLeft();
        ChromosomeLocus chromosomeLocus3 = chromosomeLocus.getRight();
        int n = 0;
        if (!this.isNodata(chromosomeLocus)) {
            ++n;
        }
        double d = this.getWidth() / 2.0;
        while (chromosomeLocus2 != null && this.getDist(chromosomeLocus2, chromosomeLocus) < d) {
            if (!this.isNodata(chromosomeLocus2)) {
                ++n;
            }
            chromosomeLocus2 = chromosomeLocus2.getLeft();
        }
        while (chromosomeLocus3 != null && this.getDist(chromosomeLocus3, chromosomeLocus) < d) {
            if (!this.isNodata(chromosomeLocus3)) {
                ++n;
            }
            chromosomeLocus3 = chromosomeLocus3.getRight();
        }
        ChromosomeLocus[] chromosomeLocusArray = new ChromosomeLocus[n];
        chromosomeLocus2 = chromosomeLocus.getLeft();
        chromosomeLocus3 = chromosomeLocus.getRight();
        n = 0;
        if (!this.isNodata(chromosomeLocus)) {
            chromosomeLocusArray[n++] = chromosomeLocus;
        }
        while (chromosomeLocus2 != null && this.getDist(chromosomeLocus2, chromosomeLocus) < d) {
            if (!this.isNodata(chromosomeLocus2)) {
                chromosomeLocusArray[n++] = chromosomeLocus2;
            }
            chromosomeLocus2 = chromosomeLocus2.getLeft();
        }
        while (chromosomeLocus3 != null && this.getDist(chromosomeLocus3, chromosomeLocus) < d) {
            if (!this.isNodata(chromosomeLocus3)) {
                chromosomeLocusArray[n++] = chromosomeLocus3;
            }
            chromosomeLocus3 = chromosomeLocus3.getRight();
        }
        return chromosomeLocusArray;
    }
}

