/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.GroupAverager;

class NearestAverager
extends GroupAverager {
    int defaultNum = 5;

    public void setNum(int n) {
        this.getConfigNode().setAttribute("num", n, this.defaultNum);
    }

    public int getNum() {
        return this.getConfigNode().getAttribute("num", this.defaultNum);
    }

    public NearestAverager() {
    }

    public NearestAverager(int n) {
        this.setNum(n);
    }

    public int getType() {
        return 1;
    }

    public String getArg() {
        return "" + this.getNum();
    }

    protected String getPre() {
        return "Nearest " + this.getNum() + " of ";
    }

    protected ChromosomeLocus[] getContributors(ChromosomeLocus chromosomeLocus) {
        ChromosomeLocus[] chromosomeLocusArray = new ChromosomeLocus[this.getNum()];
        ChromosomeLocus chromosomeLocus2 = chromosomeLocus.getLeft();
        ChromosomeLocus chromosomeLocus3 = chromosomeLocus.getRight();
        int n = this.getNum();
        int n2 = 0;
        if (!this.isNodata(chromosomeLocus)) {
            chromosomeLocusArray[n2++] = chromosomeLocus;
        }
        while (n2 < n && chromosomeLocus2 != chromosomeLocus3) {
            double d;
            while (chromosomeLocus2 != null && this.isNodata(chromosomeLocus2)) {
                chromosomeLocus2 = chromosomeLocus2.getLeft();
            }
            while (chromosomeLocus3 != null && this.isNodata(chromosomeLocus3)) {
                chromosomeLocus3 = chromosomeLocus3.getRight();
            }
            if (chromosomeLocus2 == null && chromosomeLocus3 != null) {
                chromosomeLocusArray[n2++] = chromosomeLocus3;
                chromosomeLocus3 = chromosomeLocus3.getRight();
            }
            if (chromosomeLocus2 != null && chromosomeLocus3 == null) {
                chromosomeLocusArray[n2++] = chromosomeLocus2;
                chromosomeLocus2 = chromosomeLocus2.getLeft();
            }
            if (chromosomeLocus2 == null || chromosomeLocus3 == null) continue;
            double d2 = this.getDist(chromosomeLocus2, chromosomeLocus);
            if (d2 < (d = this.getDist(chromosomeLocus3, chromosomeLocus))) {
                chromosomeLocusArray[n2++] = chromosomeLocus2;
                if ((chromosomeLocus2 = chromosomeLocus2.getLeft()) == null) continue;
                d2 = this.getDist(chromosomeLocus2, chromosomeLocus);
                continue;
            }
            chromosomeLocusArray[n2++] = chromosomeLocus3;
            if ((chromosomeLocus3 = chromosomeLocus3.getRight()) == null) continue;
            d = this.getDist(chromosomeLocus3, chromosomeLocus);
        }
        return chromosomeLocusArray;
    }
}

