/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.plugin.scatterview.AxisParameter;

class AxisInfo {
    private ConfigNode configNode;
    private String title;
    private String defaultType = "No Type";
    private AxisParameter[] axisParameters;

    public void setConfigNode(ConfigNode configNode) {
        this.configNode = configNode;
        this.initParameters();
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.configNode.getAttribute("type", this.defaultType);
    }

    public void setType(String string) {
        this.configNode.setAttribute("type", string, this.defaultType);
    }

    AxisInfo(ConfigNode configNode) {
        this.setConfigNode(configNode);
    }

    private void initParameters() {
        AxisParameter axisParameter;
        int n;
        this.axisParameters = new AxisParameter[4];
        for (int i = 0; i < this.axisParameters.length; ++i) {
            this.axisParameters[i] = null;
        }
        ConfigNode[] configNodeArray = this.configNode.fetch("AxisParameter");
        for (n = 0; n < configNodeArray.length; ++n) {
            this.axisParameters[axisParameter.getType()] = axisParameter = new AxisParameter(configNodeArray[n]);
        }
        for (n = 0; n < this.axisParameters.length; ++n) {
            if (this.axisParameters[n] != null) continue;
            axisParameter = this.configNode.create("AxisParameter");
            this.axisParameters[n] = new AxisParameter((ConfigNode)axisParameter);
            this.axisParameters[n].setType(n);
        }
    }

    public AxisParameter getAxisParameter(int n) {
        return this.axisParameters[n];
    }

    public void copyStateFrom(AxisInfo axisInfo) {
        this.setType(axisInfo.getType());
        for (int i = 0; i < this.axisParameters.length; ++i) {
            this.axisParameters[i].copyStateFrom(axisInfo.getAxisParameter(i));
        }
    }
}

