/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.ConfigNode;

class AxisParameter {
    private ConfigNode configNode;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int MINOR = 2;
    public static final int MAJOR = 3;
    private int defaultType = 0;
    private int defaultEnabled = 0;
    private double defaultValue = 1.0;

    public void setConfigNode(ConfigNode configNode) {
        this.configNode = configNode;
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public int getType() {
        return this.configNode.getAttribute("type", this.defaultType);
    }

    public void setType(int n) {
        this.configNode.setAttribute("type", n, this.defaultType);
    }

    public String getName() {
        switch (this.getType()) {
            case 0: {
                return "Min";
            }
            case 1: {
                return "Max";
            }
            case 2: {
                return "Minor";
            }
            case 3: {
                return "Major";
            }
        }
        return "Unknown";
    }

    public boolean getEnabled() {
        return this.configNode.getAttribute("enabled", this.defaultEnabled) == 1;
    }

    public void setEnabled(boolean bl) {
        int n = bl ? 1 : 0;
        this.configNode.setAttribute("enabled", n, this.defaultEnabled);
    }

    public double getValue() {
        return this.configNode.getAttribute("value", this.defaultValue);
    }

    public void setValue(double d) {
        this.configNode.setAttribute("value", d, this.defaultValue);
    }

    AxisParameter(ConfigNode configNode) {
        this.setConfigNode(configNode);
    }

    public void copyStateFrom(AxisParameter axisParameter) {
        this.setType(axisParameter.getType());
        this.setEnabled(axisParameter.getEnabled());
        this.setValue(axisParameter.getValue());
    }
}

