/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.BitmapWriter;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterView;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterViewExportPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class BitmapScatterViewExportPanel
extends ScatterViewExportPanel {
    JComboBox formatPulldown = new JComboBox<String>(BitmapWriter.formats);

    BitmapScatterViewExportPanel(ScatterView scatterView) {
        super(scatterView);
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox("Append Extension?", true);
        this.formatPulldown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    BitmapScatterViewExportPanel.this.appendExtension();
                }
            }
        });
        jPanel.add(new JLabel("Image Format:"));
        jPanel.add(this.formatPulldown);
        jPanel.add(jCheckBox);
        this.add(jPanel);
    }

    private void appendExtension() {
        int n;
        String string = this.getFilePath();
        int n2 = string.lastIndexOf(46);
        if (n2 > (n = string.lastIndexOf(File.separatorChar))) {
            this.setFilePath(string.substring(0, n2) + "." + this.formatPulldown.getSelectedItem());
        } else {
            this.setFilePath(string + "." + this.formatPulldown.getSelectedItem());
        }
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            BufferedImage bufferedImage = this.generateImage();
            String string = (String)this.formatPulldown.getSelectedItem();
            boolean bl = BitmapWriter.writeBitmap((BufferedImage)bufferedImage, (String)string, (OutputStream)bufferedOutputStream, (JComponent)this);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, new JTextArea("Scatterplot export had problem " + exception));
            LogBuffer.println((String)("Exception " + exception));
            exception.printStackTrace();
        }
    }
}

