/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import com.gurge.amd.GIFEncoder;
import com.gurge.amd.Quantize;
import com.gurge.amd.TestQuantize;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterView;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterViewExportPanel;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

class GifScatterViewExportPanel
extends ScatterViewExportPanel {
    GifScatterViewExportPanel(ScatterView scatterView) {
        super(scatterView);
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            this.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            LogBuffer.println((String)("GIF ColorBar Export Panel caught exception " + exception));
        }
    }

    public void write(OutputStream outputStream) {
        BufferedImage bufferedImage = this.generateImage();
        try {
            int[][] nArray = TestQuantize.getPixels((Image)bufferedImage);
            int[] nArray2 = Quantize.quantizeImage((int[][])nArray, (int)256);
            GIFEncoder gIFEncoder = new GIFEncoder(this.createImage(TestQuantize.makeImage((int[])nArray2, (int[][])nArray)));
            gIFEncoder.Write(outputStream);
        }
        catch (Exception exception) {
            LogBuffer.println((String)("In GifScatterViewExportPanel.synchronizeTo() got exception " + exception));
        }
    }
}

