/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.CancelableSettingsDialog;
import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DataMatrix;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LinkedViewFrame;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.ModelessSettingsDialog;
import edu.stanford.genetics.treeview.NoValueException;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.XmlConfig;
import edu.stanford.genetics.treeview.plugin.scatterview.BitmapScatterViewExportPanel;
import edu.stanford.genetics.treeview.plugin.scatterview.DisplaySettingsPanel;
import edu.stanford.genetics.treeview.plugin.scatterview.SPDataSource;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorPresets;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterParameterPanel;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterView;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterplotFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScatterPanel
extends JPanel
implements MainPanel,
Observer {
    private ConfigNode configNode;
    ScatterView scatterPane;
    ScatterParameterPanel scatterParameterPanel;
    private LinkedViewFrame viewFrame;
    TreeSelectionI selection;
    public static final int INDEX = 0;
    public static final int RATIO = 1;
    public static final int PREFIX = 2;
    private static ImageIcon scatterIcon = null;

    public String[] getHints() {
        String[] stringArray = new String[]{"Click to select points"};
        return stringArray;
    }

    public void setConfigNode(ConfigNode configNode) {
        this.configNode = configNode;
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public void setScatterPane(ScatterView scatterView) {
        this.scatterPane = scatterView;
    }

    public ScatterView getScatterPane() {
        return this.scatterPane;
    }

    public void setViewFrame(LinkedViewFrame linkedViewFrame) {
        this.viewFrame = linkedViewFrame;
    }

    public LinkedViewFrame getViewFrame() {
        return this.viewFrame;
    }

    public void scaleScatterPane() {
        System.out.println("scatterPane resized");
    }

    public ScatterPanel(LinkedViewFrame linkedViewFrame, ConfigNode configNode) {
        this.setViewFrame(linkedViewFrame);
        this.setLayout(new BorderLayout());
        this.setConfigNode(configNode);
        int n = configNode.getAttribute("xtype", 0);
        int n2 = configNode.getAttribute("ytype", 0);
        int n3 = configNode.getAttribute("xindex", 0);
        int n4 = configNode.getAttribute("yindex", 0);
        DataModelSource dataModelSource = new DataModelSource(n, n2, n3, n4);
        this.scatterPane = new ScatterView(dataModelSource);
        ScatterColorPresets scatterColorPresets = ScatterplotFactory.getColorPresets();
        this.scatterPane.setDefaultColorSet(scatterColorPresets.getDefaultColorSet());
        this.scatterPane.setConfigNode(this.getFirst("ScatterView"));
        this.add((Component)this.scatterPane.getComponent(), "Center");
        this.scatterParameterPanel = new ScatterParameterPanel(this.scatterPane, this);
        this.add((Component)this.scatterParameterPanel, "North");
    }

    public void showDisplayPopup() {
        DisplaySettingsPanel displaySettingsPanel = new DisplaySettingsPanel(this.scatterPane, ScatterplotFactory.getColorPresets(), (ViewFrame)this.viewFrame);
        ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)this.viewFrame, "Display", (SettingsPanel)displaySettingsPanel);
        modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)this.getViewFrame().getDataModel().getDocumentConfig()));
        modelessSettingsDialog.pack();
        modelessSettingsDialog.show();
    }

    public void update(Observable observable, Object object) {
        if (observable == this.selection) {
            this.scatterPane.selectionChanged();
        } else {
            System.out.println("Scatterview got funny update!");
        }
    }

    public void setSelection(TreeSelectionI treeSelectionI) {
        if (this.selection != null) {
            this.selection.deleteObserver((Observer)this);
        }
        this.selection = treeSelectionI;
        this.selection.addObserver((Observer)this);
    }

    public void syncConfig() {
    }

    public void populateSettingsMenu(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Display...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScatterPanel.this.showDisplayPopup();
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(68);
    }

    public void populateAnalysisMenu(TreeviewMenuBarI treeviewMenuBarI) {
    }

    public void populateExportMenu(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Export to Image...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BitmapScatterViewExportPanel bitmapScatterViewExportPanel = new BitmapScatterViewExportPanel(ScatterPanel.this.scatterPane);
                bitmapScatterViewExportPanel.setSourceSet(ScatterPanel.this.viewFrame.getDataModel().getFileSet());
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)ScatterPanel.this.viewFrame, "Export to Image...", (SettingsPanel)bitmapScatterViewExportPanel);
                cancelableSettingsDialog.setSize(500, 300);
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(73);
    }

    public void scrollToGene(int n) {
        LogBuffer.println((String)"ScatterPanel.scrollToGene not implemented");
    }

    public void scrollToArray(int n) {
        LogBuffer.println((String)"ScatterPanel.scrollToArray not implemented");
    }

    private ConfigNode getFirst(String string) {
        ConfigNode configNode = this.getConfigNode().fetchFirst(string);
        return configNode == null ? this.getConfigNode().create(string) : configNode;
    }

    public ImageIcon getIcon() {
        if (scatterIcon == null) {
            try {
                scatterIcon = new ImageIcon("images/plot.gif", "Plot Icon");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return scatterIcon;
    }

    class DataModelSource
    implements SPDataSource {
        private int xIndex;
        private int xType;
        private int yIndex;
        private int yType;
        double[] xVals = null;
        double[] yVals = null;

        public int getNumPoints() {
            return ScatterPanel.this.getViewFrame().getDataModel().getDataMatrix().getNumRow();
        }

        public double getX(int n) throws NoValueException {
            if (this.xVals == null) {
                this.setupVals();
            }
            if (this.xVals[n] == -1.0E7) {
                throw new NoValueException("NODATA");
            }
            if (this.xVals[n] == -2.0E7) {
                throw new NoValueException("EMPTY");
            }
            return this.xVals[n];
        }

        public double getY(int n) throws NoValueException {
            if (this.yVals == null) {
                this.setupVals();
            }
            if (this.yVals[n] == -1.0E7) {
                throw new NoValueException("NODATA");
            }
            return this.yVals[n];
        }

        public String getLabel(int n) {
            DataModel dataModel = ScatterPanel.this.getViewFrame().getDataModel();
            HeaderInfo headerInfo = dataModel.getGeneHeaderInfo();
            return headerInfo.getHeader(n)[headerInfo.getIndex("YORF")];
        }

        public Color getColor(int n) {
            if (ScatterPanel.this.getViewFrame().geneIsSelected(n)) {
                return ScatterPanel.this.scatterPane.getColorSet().getColor("Selected");
            }
            return ScatterPanel.this.scatterPane.getColorSet().getColor("Data");
        }

        public String getTitle() {
            return this.getXLabel() + " vs. " + this.getYLabel();
        }

        public String getXLabel() {
            return this.getName(this.xType, this.xIndex);
        }

        public String getYLabel() {
            return this.getName(this.yType, this.yIndex);
        }

        public void select(int n) {
            ScatterPanel.this.getViewFrame().extendRange(n);
        }

        private void setupVals() {
            int n = this.getNumPoints();
            this.xVals = new double[n];
            this.yVals = new double[n];
            for (int i = 0; i < n; ++i) {
                this.xVals[i] = this.getSimpleValue(this.xType, this.xIndex, i);
                this.yVals[i] = this.getSimpleValue(this.yType, this.yIndex, i);
            }
        }

        public void select(double d, double d2, double d3, double d4) {
            if (this.xVals == null) {
                this.setupVals();
            }
            int n = this.getNumPoints();
            int n2 = -1;
            int n3 = -1;
            TreeSelectionI treeSelectionI = ScatterPanel.this.selection;
            for (int i = 0; i < n; ++i) {
                double d5;
                double d6 = this.xVals[i];
                if (d6 == -1.0E7 || (d5 = this.yVals[i]) == -1.0E7 || !(d6 > d) || !(d6 < d3) || !(d5 > d2) || !(d5 < d4)) continue;
                treeSelectionI.setIndex(i, true);
                n3 = i;
                if (n2 != -1) continue;
                n2 = i;
            }
            if (n3 != -1) {
                if (treeSelectionI.getMinIndex() == -1) {
                    ScatterPanel.this.getViewFrame().seekGene(n2);
                }
                treeSelectionI.notifyObservers();
                ScatterPanel.this.getViewFrame().scrollToGene(n2);
            }
        }

        public void deselectAll() {
            ScatterPanel.this.getViewFrame().deselectAll();
        }

        public boolean isSelected(int n) {
            return ScatterPanel.this.getViewFrame().geneIsSelected(n);
        }

        public DataModelSource(int n, int n2, int n3, int n4) {
            this.xType = n;
            this.yType = n2;
            this.xIndex = n3;
            this.yIndex = n4;
        }

        public double getValue(int n, int n2, int n3) throws NoValueException {
            if (n == 0) {
                return n3;
            }
            DataModel dataModel = ScatterPanel.this.getViewFrame().getDataModel();
            if (n == 1) {
                DataMatrix dataMatrix = dataModel.getDataMatrix();
                double d = dataMatrix.getValue(n2, n3);
                if (d == -1.0E7) {
                    throw new NoValueException("NODATA");
                }
                return d;
            }
            if (n == 2) {
                HeaderInfo headerInfo = dataModel.getGeneHeaderInfo();
                String string = headerInfo.getHeader(n3)[n2];
                if (string == null) {
                    throw new NoValueException("NODATA");
                }
                Double d = new Double(string);
                return d;
            }
            System.out.println("Illegal Type Specified");
            throw new NoValueException("Illegal Type Specified");
        }

        public double getSimpleValue(int n, int n2, int n3) {
            DataModel dataModel = ScatterPanel.this.getViewFrame().getDataModel();
            switch (n) {
                case 0: {
                    return n3;
                }
                case 1: {
                    DataMatrix dataMatrix = dataModel.getDataMatrix();
                    return dataMatrix.getValue(n2, n3);
                }
                case 2: {
                    HeaderInfo headerInfo = dataModel.getGeneHeaderInfo();
                    String string = headerInfo.getHeader(n3)[n2];
                    if (string == null) {
                        return -1.0E7;
                    }
                    Double d = new Double(string);
                    return d;
                }
            }
            System.out.println("Illegal Type Specified");
            return -1.0E7;
        }

        public String getName(int n, int n2) {
            if (n == 0) {
                return "INDEX";
            }
            DataModel dataModel = ScatterPanel.this.getViewFrame().getDataModel();
            if (n == 1) {
                HeaderInfo headerInfo = dataModel.getArrayHeaderInfo();
                return headerInfo.getHeader(n2)[0];
            }
            if (n == 2) {
                HeaderInfo headerInfo = dataModel.getGeneHeaderInfo();
                return headerInfo.getNames()[n2];
            }
            return null;
        }
    }
}

