/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.plugin.scatterview.ScatterPanel;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ScatterParameterPanel
extends JPanel {
    ScatterView scatterPane;
    ScatterPanel scatterPanel;
    private static final String[] sizeInts = new String[]{"1", "3", "5", "7"};
    DrawPanel drawPanel;
    SizePanel sizePanel;
    ColorPanel colorPanel;
    ZoomPanel zoomPanel;

    public void setScatterView(ScatterView scatterView) {
        this.scatterPane = scatterView;
    }

    public ScatterView getScatterView() {
        return this.scatterPane;
    }

    public void setScatterPanel(ScatterPanel scatterPanel) {
        this.scatterPanel = scatterPanel;
    }

    public ScatterPanel getScatterPanel() {
        return this.scatterPanel;
    }

    public ScatterParameterPanel(ScatterView scatterView, ScatterPanel scatterPanel) {
        this.setScatterView(scatterView);
        this.setScatterPanel(scatterPanel);
        this.setupWidgets();
        this.getValues();
    }

    public void setupWidgets() {
        this.drawPanel = new DrawPanel();
        this.add(this.drawPanel);
        this.sizePanel = new SizePanel();
        this.add(this.sizePanel);
        this.zoomPanel = new ZoomPanel();
        this.add(this.zoomPanel);
        this.colorPanel = new ColorPanel();
        this.add(this.colorPanel);
    }

    public void getValues() {
        this.drawPanel.getValues();
        this.sizePanel.getValues();
    }

    public void setValues() {
        this.drawPanel.setValues();
        this.sizePanel.setValues();
    }

    private static String reformatInt(int n) {
        Integer n2 = new Integer(n);
        return n2.toString();
    }

    private static String reformatDouble(double d) {
        int n = 1;
        if (Math.abs(d) < 1.0E-7) {
            return "0.0000";
        }
        while (Math.abs(d * (double)n) < 1000.0) {
            n *= 10;
        }
        int n2 = (int)(d * (double)n);
        Double d2 = new Double((double)n2 / (double)n);
        return d2.toString();
    }

    class ZoomPanel
    extends JPanel {
        JCheckBox zoomBox = new JCheckBox("Dimension");
        JTextField widthField;
        JTextField heightField;

        ZoomPanel() {
            this.add(this.zoomBox);
            this.widthField = new JTextField("" + ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).getWidth(), 5);
            this.heightField = new JTextField("" + ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).getHeight(), 5);
            this.add(this.widthField);
            this.add(new JLabel("x"));
            this.add(this.heightField);
            this.addListeners();
        }

        private void addListeners() {
            this.zoomBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ZoomPanel.this.setValues();
                }
            });
            this.widthField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                    ZoomPanel.this.zoomBox.setSelected(true);
                    ZoomPanel.this.setEnabledValue();
                }
            });
            this.widthField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    ZoomPanel.this.setZoomValues();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ZoomPanel.this.setZoomValues();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    ZoomPanel.this.setZoomValues();
                }
            });
            this.heightField.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                    ZoomPanel.this.zoomBox.setSelected(true);
                    ZoomPanel.this.setEnabledValue();
                }
            });
            this.heightField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    ZoomPanel.this.setZoomValues();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ZoomPanel.this.setZoomValues();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    ZoomPanel.this.setZoomValues();
                }
            });
        }

        public void setValues() {
            this.setEnabledValue();
            this.setZoomValues();
        }

        public void setEnabledValue() {
            if (!this.zoomBox.isSelected()) {
                ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).setPreferredSize(null);
            }
            ((Container)((Object)ScatterParameterPanel.this.scatterPane)).invalidate();
            ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).revalidate();
            ScatterParameterPanel.this.scatterPane.getComponent().repaint();
        }

        void setZoomValues() {
            if (this.zoomBox.isSelected()) {
                try {
                    Integer n = new Integer(this.widthField.getText());
                    Integer n2 = new Integer(this.heightField.getText());
                    ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).setPreferredSize(new Dimension(n, n2));
                    ((Container)((Object)ScatterParameterPanel.this.scatterPane)).invalidate();
                    ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).revalidate();
                    ScatterParameterPanel.this.scatterPane.getComponent().repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void getValues() {
            this.widthField.setText("" + ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).getWidth());
            this.heightField.setText("" + ((JComponent)((Object)ScatterParameterPanel.this.scatterPane)).getHeight());
        }
    }

    class DrawPanel
    extends JPanel {
        JComboBox drawCombo;

        DrawPanel() {
            this.add(new JLabel("Draw"));
            this.drawCombo = new JComboBox<String>(ScatterView.drawStrings);
            this.drawCombo.setEditable(false);
            this.drawCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DrawPanel.this.setValues();
                }
            });
            this.add(this.drawCombo);
        }

        void setValues() {
            ScatterParameterPanel.this.scatterPane.setDrawOrder(this.drawCombo.getSelectedIndex());
            ((Component)((Object)ScatterParameterPanel.this.scatterPane)).repaint();
        }

        void getValues() {
            this.drawCombo.setSelectedIndex(ScatterParameterPanel.this.scatterPane.getDrawOrder());
        }
    }

    class SizePanel
    extends JPanel {
        JComboBox sizeCombo;

        SizePanel() {
            this.add(new JLabel(" Size"));
            this.sizeCombo = new JComboBox<String>(sizeInts);
            this.sizeCombo.setEditable(true);
            this.sizeCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SizePanel.this.setValues();
                }
            });
            this.add(this.sizeCombo);
        }

        void setValues() {
            try {
                Integer n = new Integer((String)this.sizeCombo.getSelectedItem());
                ScatterParameterPanel.this.scatterPane.setDrawSize(n);
                ((Component)((Object)ScatterParameterPanel.this.scatterPane)).repaint();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        void getValues() {
            this.sizeCombo.setSelectedItem("" + ScatterParameterPanel.this.scatterPane.getDrawSize());
        }
    }

    class ColorPanel
    extends JPanel {
        JButton colorsButton = new JButton("Display...");
        JButton autoButton;

        ColorPanel() {
            this.colorsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((ColorPanel)ColorPanel.this).ScatterParameterPanel.this.scatterPanel.showDisplayPopup();
                }
            });
            this.add(this.colorsButton);
        }
    }
}

