/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.CancelableSettingsDialog;
import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterView;
import edu.stanford.genetics.treeview.plugin.scatterview.TestExportPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class ScatterViewExportPanel
extends JPanel
implements SettingsPanel {
    private ConfigNode root;
    private ScatterView scatterView;
    private FileSet sourceSet;
    private FilePanel filePanel;
    private InclusionPanel inclusionPanel;
    private PreviewPanel previewPanel;

    public FileSet getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(FileSet fileSet) {
        this.sourceSet = fileSet;
        if (this.filePanel != null) {
            this.filePanel.setFilePath(this.getInitialFilePath());
        }
    }

    protected File getFile() {
        return this.filePanel.getFile();
    }

    public String getFilePath() {
        return this.filePanel.getFilePath();
    }

    public void setFilePath(String string) {
        this.filePanel.setFilePath(string);
    }

    protected String getInitialExtension() {
        return ".png";
    }

    protected String getInitialFilePath() {
        String string = null;
        string = this.sourceSet == null ? System.getProperty("user.home") + System.getProperty("file.separator") + "scatterplot" + this.getInitialExtension() : this.sourceSet.getDir() + this.sourceSet.getRoot() + this.getInitialExtension();
        if (this.root == null) {
            return string;
        }
        return this.root.getAttribute("file", string);
    }

    public ScatterViewExportPanel(ScatterView scatterView) {
        this.scatterView = scatterView;
        this.setupWidgets();
        this.inclusionPanel.synchSelected();
        this.inclusionPanel.synchEnabled();
    }

    public static final void main(String[] stringArray) {
        final JFrame jFrame = new JFrame("ScatterView Export Test");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ScatterView scatterView = new ScatterView();
        jPanel.add((Component)((Object)scatterView), "Center");
        JButton jButton = new JButton("Export...");
        final TestExportPanel testExportPanel = new TestExportPanel(scatterView);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog(jFrame, "Export to Bitmap", (SettingsPanel)testExportPanel);
                cancelableSettingsDialog.setSize(500, 500);
                cancelableSettingsDialog.show();
            }
        });
        jPanel.add((Component)jButton, "South");
        jFrame.getContentPane().add(jPanel);
        ((Component)jFrame).setSize(500, 500);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.show();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public ConfigNode createSubNode() {
        return this.root.create("File");
    }

    private void setupWidgets() {
        this.inclusionPanel = new InclusionPanel();
        this.previewPanel = new PreviewPanel();
        this.previewPanel.setMinimumSize(new Dimension(100, 100));
        Box box = new Box(0);
        this.inclusionPanel.setAlignmentY(0.5f);
        box.add(this.inclusionPanel);
        this.previewPanel.setAlignmentY(0.5f);
        box.add(this.previewPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(box);
        this.filePanel = new FilePanel(this.getInitialFilePath());
        this.add(this.filePanel);
    }

    public int estimateHeight() {
        return ((JComponent)((Object)this.scatterView)).getHeight();
    }

    public int estimateWidth() {
        return ((JComponent)((Object)this.scatterView)).getWidth();
    }

    protected BufferedImage generateImage() {
        BufferedImage bufferedImage = new BufferedImage(this.estimateWidth(), this.estimateHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        Rectangle rectangle = new Rectangle(0, 0, this.estimateWidth(), this.estimateHeight());
        graphics.setClip(rectangle);
        this.scatterView.updateBuffer(graphics);
        return bufferedImage;
    }

    public abstract /* synthetic */ void synchronizeFrom();

    public abstract /* synthetic */ void synchronizeTo();

    class FilePanel
    extends JPanel {
        private JTextField fileField;

        String getFilePath() {
            return this.fileField.getText();
        }

        File getFile() {
            return new File(this.getFilePath());
        }

        void setFilePath(String string) {
            this.fileField.setText(string);
            this.fileField.invalidate();
            this.fileField.revalidate();
            this.fileField.repaint();
        }

        public FilePanel(String string) {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Export To: "), "West");
            this.fileField = new JTextField(string);
            this.add((Component)this.fileField, "Center");
            JButton jButton = new JButton("Browse");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JFileChooser jFileChooser = new JFileChooser();
                        int n = jFileChooser.showSaveDialog(ScatterViewExportPanel.this);
                        if (n == 0) {
                            FilePanel.this.fileField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                        }
                    }
                    catch (IOException iOException) {
                        LogBuffer.println((String)("Got exception " + iOException));
                    }
                }
            });
            this.add((Component)jButton, "East");
        }
    }

    class InclusionPanel
    extends JPanel {
        public void synchEnabled() {
        }

        public void synchSelected() {
        }

        public void recalculateBbox() {
        }

        public void updateSize() {
        }

        InclusionPanel() {
            this.setupWidgets();
        }

        private void setupWidgets() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel("No options supported yet."));
            this.add(new JLabel("Exported image will be exactly "));
            this.add(new JLabel("same size as screen image."));
        }
    }

    class PreviewPanel
    extends JPanel {
        JCheckBox drawPreview;

        public void updatePreview() {
            this.repaint();
        }

        PreviewPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Preview"), "North");
            this.add((Component)new DrawingPanel(), "Center");
            this.drawPreview = new JCheckBox("Draw Preview");
            this.drawPreview.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreviewPanel.this.updatePreview();
                }
            });
            this.drawPreview.setSelected(true);
            this.add((Component)this.drawPreview, "South");
        }

        class DrawingPanel
        extends JPanel {
            DrawingPanel() {
            }

            public void paintComponent(Graphics graphics) {
                Dimension dimension = this.getSize();
                int n = ScatterViewExportPanel.this.estimateWidth();
                int n2 = ScatterViewExportPanel.this.estimateHeight();
                if (n == 0 || n2 == 0) {
                    return;
                }
                BufferedImage bufferedImage = ScatterViewExportPanel.this.generateImage();
                if (n * dimension.height > n2 * dimension.width) {
                    n2 = n2 * dimension.width / n;
                    n = dimension.width;
                } else {
                    n = n * dimension.height / n2;
                    n2 = dimension.height;
                }
                if (PreviewPanel.this.drawPreview == null || PreviewPanel.this.drawPreview.isSelected()) {
                    graphics.drawImage(bufferedImage, 0, 0, n, n2, Color.white, null);
                } else {
                    graphics.setColor(Color.red);
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[4];
                    nArray[0] = 0;
                    nArray[1] = 5;
                    nArray[2] = n;
                    nArray[3] = n - 5;
                    nArray2[0] = 5;
                    nArray2[1] = 0;
                    nArray2[2] = n2 - 5;
                    nArray2[3] = n2;
                    graphics.fillPolygon(nArray, nArray2, 4);
                    nArray2[0] = n2 - 5;
                    nArray2[1] = n2;
                    nArray2[2] = 5;
                    nArray2[3] = 0;
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
    }
}

