/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.treeanno;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.TreeSelectionI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NamedNodeView
extends ModelView {
    private TreeSelectionI selection;
    private HeaderInfo headerInfo;
    private AnnotatedListModel nodeListModel = new AnnotatedListModel();
    private JList nodeList = new JList(this.nodeListModel);

    public void setSelection(TreeSelectionI treeSelectionI) {
        if (this.selection != null) {
            this.selection.deleteObserver((Observer)((Object)this));
        }
        this.selection = treeSelectionI;
        this.selection.addObserver((Observer)((Object)this));
        if (this.selection != null) {
            this.update(this.selection, null);
        }
    }

    public String viewName() {
        return "Annotated Nodes";
    }

    protected void updateBuffer(Graphics graphics) {
    }

    public NamedNodeView(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
        this.headerInfo.addObserver((Observer)((Object)this));
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.rebuildNodeList();
        this.nodeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = NamedNodeView.this.nodeList.getSelectedIndex();
                if (n >= 0) {
                    String string = NamedNodeView.this.nodeListModel.getId(n);
                    NamedNodeView.this.selection.setSelectedNode(string);
                    NamedNodeView.this.selection.notifyObservers();
                }
            }
        });
        ((Container)((Object)this)).add(new JScrollPane(this.nodeList), "Center");
    }

    public void update(Observable observable, Object object) {
        this.update((Object)observable, object);
    }

    public void update(Object object, Object object2) {
        if (object == this.selection) {
            int n;
            int n2;
            String string = this.selection.getSelectedNode();
            if (string != null && (n2 = this.headerInfo.getHeaderIndex(string)) >= 0 && (n = this.nodeListModel.getListIndex(n2)) >= 0) {
                this.nodeList.setSelectedIndex(n);
                return;
            }
            this.nodeList.clearSelection();
        } else if (object == this.headerInfo) {
            this.rebuildNodeList();
        }
    }

    private void rebuildNodeList() {
        int n = 0;
        int n2 = this.headerInfo.getIndex("NAME");
        if (n2 >= 0) {
            for (int i = 0; i < this.headerInfo.getNumHeaders(); ++i) {
                String string = this.headerInfo.getHeader(i, n2);
                if (string == null || string.equals("")) continue;
                ++n;
            }
            int[] nArray = new int[n];
            n = 0;
            for (int i = 0; i < this.headerInfo.getNumHeaders(); ++i) {
                String string = this.headerInfo.getHeader(i, n2);
                if (string == null || string.equals("")) continue;
                nArray[n++] = i;
            }
            this.nodeListModel.setAnnotated(nArray);
        } else {
            this.nodeListModel.setAnnotated(new int[0]);
        }
    }

    public class AnnotatedListModel
    extends AbstractListModel {
        int[] annotated = new int[0];

        public int getSize() {
            return this.annotated.length;
        }

        public Object getElementAt(int n) {
            return NamedNodeView.this.headerInfo.getHeader(this.annotated[n], "NAME");
        }

        public void setAnnotated(int[] nArray) {
            this.annotated = nArray;
            this.fireContentsChanged(this, 0, nArray.length);
        }

        public String getId(int n) {
            return NamedNodeView.this.headerInfo.getHeader(this.annotated[n], 0);
        }

        public int getListIndex(int n) {
            for (int i = 0; i < this.annotated.length; ++i) {
                if (this.annotated[i] != n) continue;
                return i;
            }
            return -1;
        }
    }
}

