/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.treeanno;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.TreeSelectionI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SingleNodeView
extends ModelView {
    private TreeSelectionI selection;
    private HeaderInfo headerInfo;
    private int editingIndex;
    private JTextField nameF = new JTextField(10);
    private JTextField annoF = new JTextField(20);

    public void setSelection(TreeSelectionI treeSelectionI) {
        if (this.selection != null) {
            this.selection.deleteObserver((Observer)((Object)this));
        }
        this.selection = treeSelectionI;
        this.selection.addObserver((Observer)((Object)this));
        if (this.selection != null) {
            this.update(this.selection, null);
        }
    }

    public SingleNodeView(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
        this.headerInfo.addObserver((Observer)((Object)this));
        this.annoF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleNodeView.this.headerInfo.setHeader(SingleNodeView.this.editingIndex, "ANNOTATION", SingleNodeView.this.annoF.getText());
            }
        });
        this.nameF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleNodeView.this.headerInfo.setHeader(SingleNodeView.this.editingIndex, "NAME", SingleNodeView.this.nameF.getText());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Name"));
        jPanel.add(this.nameF);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Annotation"));
        jPanel2.add(this.annoF);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add(jPanel3);
    }

    public String viewName() {
        return "Single Node Editor";
    }

    protected void updateBuffer(Graphics graphics) {
    }

    public void update(Observable observable, Object object) {
        this.update((Object)observable, object);
    }

    public void update(Object object, Object object2) {
        if (object == this.selection) {
            int n;
            String string = this.selection.getSelectedNode();
            if (string != null && (n = this.headerInfo.getHeaderIndex(string)) >= 0) {
                this.editingIndex = n;
                this.synchronizeFrom();
            }
        } else if (object == this.headerInfo) {
            this.synchronizeFrom();
        }
    }

    private void synchronizeFrom() {
        this.nameF.setText(this.headerInfo.getHeader(this.editingIndex, "NAME"));
        this.annoF.setText(this.headerInfo.getHeader(this.editingIndex, "ANNOTATION"));
    }
}

