/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.treeanno;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.GTRView;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class TableNodeView
extends ModelView
implements ListSelectionListener {
    private NodeTableModel tableModel;
    private TreeSelectionI selection;
    private JTable nodeTable;
    private HeaderInfo headerInfo;
    GTRView trView = null;

    public void setSelection(TreeSelectionI treeSelectionI) {
        if (this.selection != null) {
            this.selection.deleteObserver((Observer)((Object)this));
        }
        this.selection = treeSelectionI;
        this.selection.addObserver((Observer)((Object)this));
        if (this.selection != null) {
            this.update(this.selection, null);
        }
    }

    public TableNodeView(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
        this.headerInfo.addObserver((Observer)((Object)this));
        this.tableModel = new NodeTableModel();
        this.nodeTable = new JTable(this.tableModel);
        this.nodeTable.getSelectionModel().addListSelectionListener(this);
        this.nodeTable.setAutoResizeMode(0);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add(new JScrollPane(this.nodeTable), "Center");
    }

    public String viewName() {
        return "Tree Node Editor";
    }

    protected void updateBuffer(Graphics graphics) {
    }

    public void update(Observable observable, Object object) {
        this.update((Object)observable, object);
    }

    public void update(Object object, Object object2) {
        if (object == this.selection) {
            int n;
            this.nodeTable.clearSelection();
            String string = this.selection.getSelectedNode();
            if (string != null && (n = this.headerInfo.getHeaderIndex(string)) >= 0) {
                this.nodeTable.changeSelection(n, 0, false, false);
                this.nodeTable.changeSelection(n, this.headerInfo.getNumNames(), false, true);
            }
            if (this.trView != null) {
                this.trView.scrollToNode(string);
            }
        } else if (object == this.headerInfo) {
            int n = this.nodeTable.getSelectedRow();
            this.tableModel.fireTableStructureChanged();
            this.nodeTable.changeSelection(n, 0, false, false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.nodeTable.getSelectedRow();
        if (n >= 0) {
            String string = this.headerInfo.getHeader(n, 0);
            this.selection.setSelectedNode(string);
            this.selection.notifyObservers();
        }
    }

    public void setTree(GTRView gTRView) {
        this.trView = gTRView;
    }

    private class NodeTableModel
    extends AbstractTableModel {
        private NodeTableModel() {
        }

        public int getRowCount() {
            return TableNodeView.this.headerInfo.getNumHeaders();
        }

        public String getColumnName(int n) {
            return TableNodeView.this.headerInfo.getNames()[n];
        }

        public int getColumnCount() {
            return TableNodeView.this.headerInfo.getNumNames();
        }

        public Object getValueAt(int n, int n2) {
            return TableNodeView.this.headerInfo.getHeader(n, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            TableNodeView.this.headerInfo.setHeader(n, TableNodeView.this.headerInfo.getNames()[n2], (String)object);
        }

        public boolean isCellEditable(int n, int n2) {
            String[] stringArray = TableNodeView.this.headerInfo.getNames();
            if (stringArray[n2].equals("NODEID")) {
                return false;
            }
            if (stringArray[n2].equals("LEFT")) {
                return false;
            }
            if (stringArray[n2].equals("RIGHT")) {
                return false;
            }
            return !stringArray[n2].equals("CORRELATION");
        }
    }
}

