/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.treeanno;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.plugin.treeanno.NamedNodeView;
import edu.stanford.genetics.treeview.plugin.treeanno.SingleNodeView;
import edu.stanford.genetics.treeview.plugin.treeanno.TableNodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class TreeAnnoPanel
extends JPanel
implements MainPanel {
    private ViewFrame viewFrame;
    private DataModel dataModel;
    private NamedNodeView namedNodeView;
    private SingleNodeView singleView;
    private TreeSelectionI selection;
    private HeaderInfo nodeInfo;
    private TableNodeView tableNodeView;
    private int type;
    public static final int GENE_TREE = 0;
    public static final int ARRAY_TREE = 1;
    public static final int DEFAULT_TYPE = 0;
    private ConfigNode root;
    private static ImageIcon treeviewIcon = null;

    public TreeAnnoPanel(DataModel dataModel, ViewFrame viewFrame, int n) {
        this.viewFrame = viewFrame;
        this.dataModel = dataModel;
        if (this.dataModel.getDocumentConfig() != null) {
            this.bindConfig(this.dataModel.getDocumentConfig().fetchOrCreate("TreeAnno"));
        } else {
            this.bindConfig((ConfigNode)new DummyConfigNode("TreeAnno"));
        }
        this.nodeInfo = n == 0 ? this.dataModel.getGtrHeaderInfo() : this.dataModel.getAtrHeaderInfo();
        this.setupViews();
        if (n == 0) {
            this.setSelection(this.viewFrame.getGeneSelection());
        } else {
            this.setSelection(this.viewFrame.getArraySelection());
        }
    }

    public TreeAnnoPanel(ViewFrame viewFrame, ConfigNode configNode) {
        this.viewFrame = viewFrame;
        this.dataModel = viewFrame.getDataModel();
        this.bindConfig(configNode);
        this.nodeInfo = this.type == 0 ? this.dataModel.getGtrHeaderInfo() : this.dataModel.getAtrHeaderInfo();
        this.setupViews();
        if (this.type == 0) {
            this.setSelection(this.viewFrame.getGeneSelection());
        } else {
            this.setSelection(this.viewFrame.getArraySelection());
        }
    }

    private void setupViews() {
        this.namedNodeView = new NamedNodeView(this.nodeInfo);
        this.namedNodeView.setViewFrame(this.viewFrame);
        this.singleView = new SingleNodeView(this.nodeInfo);
        this.singleView.setViewFrame(this.viewFrame);
        this.tableNodeView = new TableNodeView(this.nodeInfo);
        this.tableNodeView.setViewFrame(this.viewFrame);
        this.doSingleLayout();
    }

    private void doSingleLayout() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)((Object)this.namedNodeView));
        JSplitPane jSplitPane = new JSplitPane(0, (Component)((Object)this.singleView), (Component)((Object)this.tableNodeView));
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setOneTouchExpandable(true);
        JSplitPane jSplitPane2 = new JSplitPane(1, jPanel, jSplitPane);
        jSplitPane2.setResizeWeight(0.5);
        jSplitPane2.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)jSplitPane2, "Center");
    }

    public int getType() {
        return this.type;
    }

    private void setType(int n) {
        this.type = n;
        if (this.root != null) {
            this.root.setAttribute("tree_type", n, 0);
        }
    }

    public TreeSelectionI getSelection() {
        return this.selection;
    }

    public void setSelection(TreeSelectionI treeSelectionI) {
        if (this.selection != null) {
            // empty if block
        }
        this.selection = treeSelectionI;
        this.namedNodeView.setSelection(treeSelectionI);
        this.singleView.setSelection(treeSelectionI);
        this.tableNodeView.setSelection(treeSelectionI);
    }

    public void syncConfig() {
    }

    public ConfigNode getConfigNode() {
        return this.root;
    }

    public void populateSettingsMenu(TreeviewMenuBarI treeviewMenuBarI) {
    }

    public void populateAnalysisMenu(TreeviewMenuBarI treeviewMenuBarI) {
    }

    public void populateExportMenu(TreeviewMenuBarI treeviewMenuBarI) {
    }

    public void scrollToGene(int n) {
        LogBuffer.println((String)"TreeAnnoPanel.scrollToGene not implemented");
    }

    public void scrollToArray(int n) {
        LogBuffer.println((String)"TreeAnnoPanel.scrollToArray not implemented");
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.setType(this.root.getAttribute("tree_type", 0));
    }

    public ImageIcon getIcon() {
        if (treeviewIcon == null) {
            treeviewIcon = new ImageIcon("images/treeview.gif", "TreeView Icon");
        }
        return treeviewIcon;
    }
}

