/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;

abstract class Chromosome {
    public static final int LINEAR = 1;
    public static final int CIRCULAR = 1;

    Chromosome() {
    }

    public abstract ChromosomeLocus getLeftEnd();

    public abstract ChromosomeLocus getRightEnd();

    public boolean isEmpty() {
        return this.getLeftEnd() == this.getRightEnd() && this.getRightEnd() == null;
    }

    public abstract int getType();

    public abstract double getMaxPosition();

    public abstract double getMaxPosition(int var1);

    public abstract ChromosomeLocus getClosestLocus(int var1, double var2);

    public abstract ChromosomeLocus getLocus(int var1, int var2);

    public abstract void insertLocus(ChromosomeLocus var1);

    protected int insertLocusIntoArray(ChromosomeLocus[] chromosomeLocusArray, ChromosomeLocus chromosomeLocus) {
        for (int i = 0; i < chromosomeLocusArray.length; ++i) {
            if (chromosomeLocusArray[i] == null) {
                chromosomeLocusArray[i] = chromosomeLocus;
                return i;
            }
            if (!(chromosomeLocusArray[i].getPosition() > chromosomeLocus.getPosition())) continue;
            for (int j = chromosomeLocusArray.length - 1; j > i; --j) {
                chromosomeLocusArray[j] = chromosomeLocusArray[j - 1];
            }
            chromosomeLocusArray[i] = chromosomeLocus;
            return i;
        }
        System.out.println(" array " + chromosomeLocusArray);
        LogBuffer.println((String)("Error in Genome.insertLocusIntoArray(): we weren't about to fit locus " + chromosomeLocus + " into data structure on account of not allocating enough space"));
        return -1;
    }

    protected ChromosomeLocus getLocusRecursive(double d, ChromosomeLocus[] chromosomeLocusArray, int n, int n2) {
        double d2;
        if (n == n2) {
            return chromosomeLocusArray[n];
        }
        int n3 = (n2 + n) / 2;
        int n4 = n3 + 1;
        if (chromosomeLocusArray[n3].getPosition() > d) {
            return this.getLocusRecursive(d, chromosomeLocusArray, n, n3);
        }
        if (chromosomeLocusArray[n4].getPosition() < d) {
            return this.getLocusRecursive(d, chromosomeLocusArray, n4, n2);
        }
        double d3 = Math.abs(chromosomeLocusArray[n3].getPosition() - d);
        if (d3 > (d2 = Math.abs(chromosomeLocusArray[n4].getPosition() - d))) {
            return chromosomeLocusArray[n4];
        }
        return chromosomeLocusArray[n3];
    }
}

