/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.plugin.karyoview.Chromosome;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.CircularChromosome;
import edu.stanford.genetics.treeview.plugin.karyoview.LinearChromosome;

class ChromosomeLoci {
    private ChromosomeLocus[] loci;
    private Chromosome[] chromosomes;
    private boolean structValid;

    public void addLocus(ChromosomeLocus chromosomeLocus) {
        this.loci[chromosomeLocus.getCdtIndex()] = chromosomeLocus;
        this.setStructValid(false);
    }

    public double getPosition(int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        ChromosomeLocus chromosomeLocus;
        if (!this.isStructValid()) {
            this.buildTree();
        }
        if ((chromosomeLocus = this.chromosomes[n - 1].getLocus(n2, n3)) == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return chromosomeLocus.getPosition();
    }

    public ChromosomeLocus getClosestLocus(int n, int n2, double d) {
        return this.chromosomes[n - 1].getClosestLocus(n2, d);
    }

    public ChromosomeLocus getLocus(int n) {
        return this.loci[n];
    }

    public double getMaxPosition(int n, int n2) {
        if (!this.isStructValid()) {
            this.buildTree();
        }
        return this.chromosomes[n - 1].getMaxPosition(n2);
    }

    public double getMaxPosition() {
        if (!this.isStructValid()) {
            this.buildTree();
        }
        double d = -1.0;
        for (int i = 0; i < this.chromosomes.length; ++i) {
            double d2 = this.chromosomes[i].getMaxPosition();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public int getMaxChromosome() {
        if (!this.isStructValid()) {
            this.buildTree();
        }
        return this.chromosomes.length;
    }

    private boolean isStructValid() {
        return this.structValid;
    }

    private void setStructValid(boolean bl) {
        this.structValid = bl;
    }

    ChromosomeLoci(int n) {
        this.loci = new ChromosomeLocus[n];
        this.structValid = false;
    }

    private void buildTree() {
        if (this.isStructValid()) {
            return;
        }
        this.allocateDataStructure();
        this.loadDataStructure();
        this.setStructValid(true);
    }

    private void loadDataStructure() {
        for (int i = 0; i < this.loci.length; ++i) {
            ChromosomeLocus chromosomeLocus = this.loci[i];
            if (chromosomeLocus.getChromosome() <= 0) continue;
            this.chromosomes[chromosomeLocus.getChromosome() - 1].insertLocus(chromosomeLocus);
        }
    }

    private void allocateDataStructure() {
        int n;
        int n2 = -1;
        for (int i = 0; i < this.loci.length; ++i) {
            if (this.loci[i] == null || this.loci[i].getChromosome() <= n2) continue;
            n2 = this.loci[i].getChromosome();
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = 0;
            nArray2[n] = 0;
            nArray3[n] = 0;
        }
        for (n = 0; n < this.loci.length; ++n) {
            int n3 = this.loci[n].getChromosome();
            int n4 = this.loci[n].getArm();
            if (n4 == 1) {
                int n5 = n3 - 1;
                nArray[n5] = nArray[n5] + 1;
            }
            if (n4 == 2) {
                int n6 = n3 - 1;
                nArray2[n6] = nArray2[n6] + 1;
            }
            if (n4 != 3) continue;
            int n7 = n3 - 1;
            nArray3[n7] = nArray3[n7] + 1;
        }
        this.chromosomes = new Chromosome[n2];
        for (n = 0; n < n2; ++n) {
            this.chromosomes[n] = nArray3[n] != 0 ? new CircularChromosome(nArray3[n]) : new LinearChromosome(nArray[n], nArray2[n]);
        }
    }
}

