/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DataMatrix;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.SwingWorker;
import edu.stanford.genetics.treeview.plugin.karyoview.Averager;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.Genome;
import edu.stanford.genetics.treeview.plugin.karyoview.IntervalAverager;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoDrawer;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoViewParameterPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.NearestAverager;
import edu.stanford.genetics.treeview.plugin.karyoview.NeighborAverager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public class KaryoView
extends ModelView
implements Observer {
    private KaryoViewParameterPanel parameterPanel = null;
    private int currentCol = 0;
    private KaryoDrawer karyoDrawer = null;
    private AveragerSettingsPanel averagerSettingsPanel;
    private int defaultAverager = 3;
    private Averager simpleAverager;
    private NeighborAverager neighborAverager;
    private NearestAverager nearestAverager;
    private IntervalAverager intervalAverager;
    private JScrollPane scrollPane;
    private DataMatrix dataMatrix;
    private double nodata;
    private HeaderInfo experimentInfo;
    private HeaderInfo geneInfo;
    ProgressMonitor averagerMonitor;
    Timer averageTimer;
    AveragerTask averagerTask;
    Averager averager = null;
    MouseTracker mouseTracker = new MouseTracker();
    Rectangle clipRect = new Rectangle();
    Rectangle repaintRect = new Rectangle();
    private boolean justZoomed = false;
    private Point zoomPoint = new Point();
    private String[] statusText = new String[5];
    private ConfigNode configNode = new DummyConfigNode("KaryoView");

    public KaryoViewParameterPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public void setParameterPanel(KaryoViewParameterPanel karyoViewParameterPanel) {
        this.parameterPanel = karyoViewParameterPanel;
    }

    public int getCurrentCol() {
        return this.currentCol;
    }

    public void setCurrentCol(int n) {
        if (this.currentCol == n) {
            return;
        }
        this.currentCol = n;
        this.recalculateAverages();
        this.offscreenValid = false;
    }

    public void setKaryoDrawer(KaryoDrawer karyoDrawer) {
        if (this.karyoDrawer != null) {
            this.karyoDrawer.deleteObserver(this);
        }
        this.karyoDrawer = karyoDrawer;
        if (this.karyoDrawer != null) {
            this.karyoDrawer.addObserver(this);
        }
    }

    public KaryoDrawer getKaryoDrawer() {
        return this.karyoDrawer;
    }

    public SettingsPanel getAveragerSettingsPanel() {
        return this.averagerSettingsPanel;
    }

    public int getAveragingType() {
        return this.averager.getType();
    }

    public String getAveragingArg() {
        return this.averager.getArg();
    }

    public void setSimpleAveraging() {
        this.averagerSettingsPanel.setEnabled(false);
        this.configNode.setAttribute("averager", this.simpleAverager.getType(), this.defaultAverager);
        this.recalculateAverages();
    }

    public void setNearestAveraging(int n) {
        this.averagerSettingsPanel.setEnabled(false);
        this.configNode.setAttribute("averager", this.nearestAverager.getType(), this.defaultAverager);
        this.nearestAverager.setNum(n);
        this.recalculateAverages();
    }

    public void setNeighborAveraging(int n) {
        this.averagerSettingsPanel.setEnabled(false);
        this.configNode.setAttribute("averager", this.neighborAverager.getType(), this.defaultAverager);
        this.neighborAverager.setNum(n);
        this.recalculateAverages();
    }

    public void setIntervalAveraging(double d) {
        this.averagerSettingsPanel.setEnabled(false);
        this.configNode.setAttribute("averager", this.intervalAverager.getType(), this.defaultAverager);
        this.intervalAverager.setWidth(d);
        this.recalculateAverages();
    }

    private Averager getAverager(int n) {
        switch (n) {
            case 0: {
                return this.simpleAverager;
            }
            case 1: {
                return this.nearestAverager;
            }
            case 2: {
                return this.neighborAverager;
            }
            case 3: {
                return this.intervalAverager;
            }
        }
        return this.getAverager(this.defaultAverager);
    }

    public void setDataMatrix(DataMatrix dataMatrix) {
        this.dataMatrix = dataMatrix;
    }

    public DataMatrix getDataMatrix() {
        return this.dataMatrix;
    }

    public int getNumCol() {
        return this.dataMatrix.getNumCol();
    }

    public void setNodata(double d) {
        this.nodata = d;
    }

    public double getNodata() {
        return this.nodata;
    }

    public void setGeneInfo(HeaderInfo headerInfo) {
        this.geneInfo = headerInfo;
    }

    public HeaderInfo getGeneInfo() {
        return this.geneInfo;
    }

    public void cleanup() {
        this.dataMatrix = null;
        this.scrollPane = null;
        this.karyoDrawer = null;
        this.experimentInfo = null;
        this.geneInfo = null;
    }

    public void update(Observable observable, Object object) {
        if (observable == this.karyoDrawer) {
            this.offscreenValid = false;
            ((JComponent)((Object)this)).revalidate();
            ((Component)((Object)this)).repaint();
        } else {
            LogBuffer.println((String)("KaryoView got weird update from " + observable));
        }
    }

    public KaryoView(KaryoDrawer karyoDrawer, DataModel dataModel) {
        this.setKaryoDrawer(karyoDrawer);
        this.dataMatrix = dataModel.getDataMatrix();
        this.nodata = -1.0E7;
        this.experimentInfo = dataModel.getArrayHeaderInfo();
        this.geneInfo = dataModel.getGeneHeaderInfo();
        this.simpleAverager = new Averager();
        this.simpleAverager.setKaryoView(this);
        this.nearestAverager = new NearestAverager();
        this.nearestAverager.setKaryoView(this);
        this.neighborAverager = new NeighborAverager();
        this.neighborAverager.setKaryoView(this);
        this.intervalAverager = new IntervalAverager();
        this.intervalAverager.setKaryoView(this);
        this.averagerSettingsPanel = new AveragerSettingsPanel(this);
        this.averager = this.simpleAverager;
        this.averageTimer = new Timer(1000, new TimerListener());
        this.averageTimer.stop();
        this.mouseTracker = new MouseTracker();
        this.statusText[1] = "Mouse over for info on genes...";
        this.statusText[2] = "";
        this.statusText[3] = "";
        this.scrollPane = new JScrollPane((Component)((Object)this));
        this.panel = this.scrollPane;
        ((Component)((Object)this)).addMouseMotionListener(this.mouseTracker);
        ((Component)((Object)this)).addMouseListener(this.mouseTracker);
        ((Component)((Object)this)).addKeyListener(this.mouseTracker);
    }

    public void recalculateAverages() {
        this.averager = this.getAverager(this.configNode.getAttribute("averager", this.defaultAverager));
        this.averagerTask = new AveragerTask();
        this.averagerMonitor = new ProgressMonitor((Component)((Object)this), "Calculating Averaged Values", "Note", 0, this.averagerTask.getLengthOfTask());
        this.averagerMonitor.setProgress(0);
        this.averagerTask.go();
        this.averageTimer.start();
    }

    public synchronized void paintComposite(Graphics graphics) {
        this.mouseTracker.paintComposite(graphics);
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        if (dimension == null) {
            return;
        }
        if (this.karyoDrawer.getPixelPerVal() == 0.0 && this.getKaryoDrawer().getGenome().getMaxChromosome() > 0) {
            if (this.getKaryoDrawer().getGenome().getNonemptyCount() > 0) {
                this.redoScale();
            } else {
                return;
            }
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (((Component)((Object)this)).isEnabled()) {
            this.offscreenValid = false;
            this.updateBuffer(graphics);
            this.paintComposite(graphics);
        }
    }

    public void updateBuffer(Graphics graphics) {
        if (this.justZoomed) {
            this.justZoomed = false;
            this.scrollPane.getViewport().setViewPosition(this.zoomPoint);
            ((Component)((Object)this)).repaint();
            return;
        }
        try {
            this.clipRect = graphics.getClipBounds(this.clipRect);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.clipRect.setBounds(graphics.getClipBounds());
        }
        this.karyoDrawer.paint(graphics, this.clipRect);
    }

    public String viewName() {
        return "KaryoView";
    }

    public void redoScale() {
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        this.karyoDrawer.setWidth(dimension.width);
        this.karyoDrawer.setHeight(dimension.height);
        this.karyoDrawer.autoScale();
        ((JComponent)((Object)this)).revalidate();
        this.repaintRect.setBounds(0, 0, dimension.width, dimension.height);
        ((JComponent)((Object)this)).repaint(this.repaintRect);
        if (this.parameterPanel != null) {
            this.parameterPanel.getValues();
        }
    }

    public String[] getExperiments() {
        String[] stringArray = new String[this.getNumCol()];
        for (int i = 0; i < this.getNumCol(); ++i) {
            stringArray[i] = this.experimentInfo.getHeader(i)[0];
        }
        return stringArray;
    }

    public Dimension getPreferredSize() {
        if (this.karyoDrawer.getWidth() >= 0) {
            Dimension dimension = new Dimension(this.karyoDrawer.getWidth(), this.karyoDrawer.getHeight());
            return dimension;
        }
        return super.getPreferredSize();
    }

    public boolean isChromosomeVisible(int n) {
        JViewport jViewport = this.scrollPane.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        int n2 = this.karyoDrawer.minVisibleChromosome(rectangle);
        int n3 = this.karyoDrawer.maxVisibleChromosome(rectangle);
        System.out.println("min " + n2 + " max " + n3);
        return n <= n3 && n >= n2;
    }

    private void zoomRectangle(Rectangle rectangle) {
        JViewport jViewport = this.scrollPane.getViewport();
        Dimension dimension = jViewport.getExtentSize();
        double d = (double)dimension.width / (double)rectangle.width;
        double d2 = (double)dimension.height / (double)rectangle.height;
        this.karyoDrawer.setWidth((int)((double)this.karyoDrawer.getWidth() * d));
        this.karyoDrawer.setHeight((int)((double)this.karyoDrawer.getHeight() * d2));
        this.karyoDrawer.setPixelPerMap(d * this.karyoDrawer.getPixelPerMap());
        this.karyoDrawer.setPixelPerVal(d2 * this.karyoDrawer.getPixelPerVal());
        ((JComponent)((Object)this)).revalidate();
        this.zoomPoint.setLocation((int)(d * (double)rectangle.x), (int)(d2 * (double)rectangle.y));
        this.justZoomed = true;
        this.scrollPane.repaint();
        if (this.parameterPanel != null) {
            this.parameterPanel.getValues();
        }
    }

    private void zoomFactor(double d, Point point) {
        JViewport jViewport = this.scrollPane.getViewport();
        Dimension dimension = jViewport.getExtentSize();
        Point point2 = jViewport.getViewPosition();
        if (point == null) {
            point = new Point(point2.x + dimension.width / 2, point2.y + dimension.height / 2);
        }
        this.karyoDrawer.setWidth((int)((double)this.karyoDrawer.getWidth() * d));
        this.karyoDrawer.setHeight((int)((double)this.karyoDrawer.getHeight() * d));
        this.karyoDrawer.setPixelPerMap(this.karyoDrawer.getPixelPerMap() * d);
        this.karyoDrawer.setPixelPerVal(this.karyoDrawer.getPixelPerVal() * d);
        ((JComponent)((Object)this)).revalidate();
        this.zoomPoint.setLocation((int)((double)point.x * d - (double)(point.x - point2.x)), (int)((double)point.y * d - (double)(point.y - point2.y)));
        this.justZoomed = true;
        this.scrollPane.repaint();
        if (this.parameterPanel != null) {
            this.parameterPanel.getValues();
        }
    }

    private void updateStatus(ChromosomeLocus chromosomeLocus) {
        if (chromosomeLocus == null) {
            this.statusText[0] = "KeyBoard Shortcuts:";
            this.statusText[1] = "";
            this.statusText[2] = "'+' zooms in on mouse";
            this.statusText[3] = "'-' zooms out on mouse";
            this.statusText[4] = "";
        } else {
            int n = chromosomeLocus.getChromosome();
            int n2 = chromosomeLocus.getArm();
            double d = chromosomeLocus.getPosition();
            int n3 = chromosomeLocus.getCdtIndex();
            this.statusText[0] = "Cursor is over Chromosome " + n + " arm " + n2 + " position " + d;
            if (n3 != -1) {
                this.statusText[1] = this.geneInfo.getHeader(n3, "NAME");
                double d2 = this.karyoDrawer.getMapValue(n3);
                this.statusText[2] = d2 == this.nodata ? "Value: No Data" : "Value: " + d2;
                String[] stringArray = this.averager.getDescription(chromosomeLocus, this.getCurrentCol());
                this.statusText[3] = stringArray[0];
                this.statusText[4] = stringArray[1];
            } else {
                this.statusText[1] = "Mouse over for info on genes...";
                this.statusText[2] = "";
                this.statusText[3] = "";
                this.statusText[4] = "";
            }
        }
        if (this.status != null) {
            this.status.setMessages(this.getStatus());
        }
    }

    public String[] getStatus() {
        return this.statusText;
    }

    private int getClosest(int n, int n2, double d) {
        return 0;
    }

    public void bindConfig(ConfigNode configNode) {
        this.configNode = configNode;
        this.simpleAverager.bindConfig(this.getFirst("SimpleAverager"));
        this.intervalAverager.bindConfig(this.getFirst("IntervalAverager"));
        this.nearestAverager.bindConfig(this.getFirst("NearestAverager"));
        this.neighborAverager.bindConfig(this.getFirst("NeighborAverager"));
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    private ConfigNode getFirst(String string) {
        ConfigNode configNode = this.getConfigNode().fetchFirst(string);
        return configNode == null ? this.getConfigNode().create(string) : configNode;
    }

    private class AveragerSettingsPanel
    extends JPanel
    implements SettingsPanel {
        private KaryoView karyoView;
        private JButton simpleButton;
        private JButton nearestButton;
        private JButton neighborButton;
        private JButton intervalButton;
        private JTextField nearestField;
        private JTextField neighborField;
        private JTextField intervalField;

        public void setKaryoView(KaryoView karyoView) {
            this.karyoView = karyoView;
        }

        public KaryoView getKaryoView() {
            return this.karyoView;
        }

        public void setEnabled(boolean bl) {
            this.simpleButton.setEnabled(bl);
            this.nearestButton.setEnabled(bl);
            this.neighborButton.setEnabled(bl);
            this.intervalButton.setEnabled(bl);
            this.nearestField.setEnabled(bl);
            this.neighborField.setEnabled(bl);
            this.intervalField.setEnabled(bl);
        }

        public AveragerSettingsPanel(KaryoView karyoView2) {
            this.setKaryoView(karyoView2);
            this.configureWidgets();
            this.addWidgets();
        }

        private void addWidgets() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            this.add(new JLabel("Options"));
            gridBagConstraints.gridy = 1;
            this.add((Component)this.simpleButton, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.nearestButton, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.add((Component)this.neighborButton, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            this.add((Component)this.intervalButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add(new JLabel("Options"));
            gridBagConstraints.gridy = 2;
            this.add((Component)this.nearestField, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.add((Component)this.neighborField, gridBagConstraints);
            gridBagConstraints.gridy = 4;
            this.add((Component)this.intervalField, gridBagConstraints);
        }

        private void configureWidgets() {
            this.nearestField = new JTextField("" + KaryoView.this.nearestAverager.getNum());
            this.neighborField = new JTextField("" + KaryoView.this.neighborAverager.getNum());
            this.intervalField = new JTextField("" + KaryoView.this.intervalAverager.getWidth());
            this.nearestField.setColumns(5);
            this.neighborField.setColumns(5);
            this.intervalField.setColumns(5);
            this.simpleButton = new JButton("No Averaging");
            this.simpleButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AveragerSettingsPanel.this.karyoView.setSimpleAveraging();
                }
            });
            this.nearestButton = new JButton("Nearest :");
            this.nearestButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AveragerSettingsPanel.this.karyoView.setNearestAveraging(Integer.parseInt(AveragerSettingsPanel.this.nearestField.getText()));
                }
            });
            this.neighborButton = new JButton("Neighbor :");
            this.neighborButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AveragerSettingsPanel.this.karyoView.setNeighborAveraging(Integer.parseInt(AveragerSettingsPanel.this.neighborField.getText()));
                }
            });
            this.intervalButton = new JButton("Interval :");
            this.intervalButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Double d = new Double(AveragerSettingsPanel.this.intervalField.getText());
                    AveragerSettingsPanel.this.karyoView.setIntervalAveraging(d);
                }
            });
        }

        public void synchronizeTo() {
        }

        public void synchronizeFrom() {
        }
    }

    class MouseTracker
    implements MouseMotionListener,
    MouseListener,
    KeyListener {
        Point startPoint = new Point();
        Point endPoint = new Point();
        Rectangle dragRect = null;
        Point tip = null;
        Rectangle highlight = null;
        Rectangle repaintRect = new Rectangle();

        MouseTracker() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case '-': {
                    KaryoView.this.zoomFactor(0.5, this.startPoint);
                    this.startPoint.x = (int)((double)this.startPoint.x * 0.5);
                    this.startPoint.y = (int)((double)this.startPoint.y * 0.5);
                    this.mouseMoved(new MouseEvent((Component)((Object)KaryoView.this), 503, 10L, 0, this.startPoint.x, this.startPoint.y, 1, false));
                    break;
                }
                case '+': {
                    KaryoView.this.zoomFactor(2.0, this.startPoint);
                    this.startPoint.x = (int)((double)this.startPoint.x * 2.0);
                    this.startPoint.y = (int)((double)this.startPoint.y * 2.0);
                    this.mouseMoved(new MouseEvent((Component)((Object)KaryoView.this), 503, 10L, 0, this.startPoint.x, this.startPoint.y, 1, false));
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ((JComponent)((Object)KaryoView.this)).requestFocus();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
            if (this.tip != null) {
                this.repaintRect.setLocation(this.tip.x, this.tip.y);
            }
            this.repaintRect.setSize(0, 0);
            if (this.highlight != null) {
                this.repaintRect.add(this.highlight);
            }
            this.tip = null;
            this.highlight = null;
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
            KaryoView.this.updateStatus(null);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (!KaryoView.this.viewFrame.windowActive()) {
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            this.startPoint.setLocation(n2, n3);
            ChromosomeLocus chromosomeLocus = KaryoView.this.karyoDrawer.getClosest(this.startPoint);
            if (chromosomeLocus != null && (n = chromosomeLocus.getCdtIndex()) != -1 && KaryoView.this.viewFrame != null) {
                KaryoView.this.viewFrame.displayURL(n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.startPoint.setLocation(n, n2);
            ChromosomeLocus chromosomeLocus = KaryoView.this.karyoDrawer.getClosest(this.startPoint);
            KaryoView.this.updateStatus(chromosomeLocus);
            this.moveHighlight(chromosomeLocus);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseExited(mouseEvent);
            if (!KaryoView.this.viewFrame.windowActive()) {
                return;
            }
            this.startPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.endPoint.setLocation(this.startPoint.x, this.startPoint.y);
            this.dragRect = new Rectangle();
            this.dragRect.setLocation(this.startPoint.x, this.startPoint.y);
            this.dragRect.setSize(this.endPoint.x - this.dragRect.x, this.endPoint.y - this.dragRect.y);
            ((JComponent)((Object)KaryoView.this)).repaint(this.dragRect);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!KaryoView.this.viewFrame.windowActive()) {
                return;
            }
            if (this.dragRect == null) {
                return;
            }
            this.mouseDragged(mouseEvent);
            this.repaintRect.setBounds(this.dragRect);
            this.tip = null;
            this.highlight = null;
            this.dragRect = null;
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
            if (this.repaintRect.width > 3 && this.repaintRect.height > 3) {
                KaryoView.this.zoomRectangle(this.repaintRect);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragRect == null) {
                LogBuffer.println((String)"dragRect null");
                return;
            }
            this.endPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.dragRect.setLocation(this.startPoint.x, this.startPoint.y);
            this.dragRect.setSize(0, 0);
            this.dragRect.add(this.endPoint.x, this.endPoint.y);
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
            this.repaintRect.setBounds(this.dragRect);
            this.repaintRect.grow(1, 1);
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
        }

        public void paintComposite(Graphics graphics) {
            int n;
            int n2;
            if (this.highlight != null) {
                graphics.setColor(KaryoView.this.karyoDrawer.getKaryoColorSet().getColor("Highlight"));
                n2 = this.highlight.x;
                n = n2 + this.highlight.width;
                int n3 = this.highlight.y;
                int n4 = n3 + this.highlight.height;
                graphics.drawLine(n2, n4, n, n3);
                graphics.drawLine(n2, n3, n, n4);
            }
            if (this.tip != null) {
                n2 = this.startPoint.x;
                n = this.startPoint.y;
                graphics.drawLine(n2, n, this.tip.x, this.tip.y);
            }
            if (this.dragRect != null) {
                this.drawBand(this.dragRect, graphics);
            }
        }

        private void drawBand(Rectangle rectangle, Graphics graphics) {
            graphics.setColor(Color.yellow);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setPaintMode();
        }

        private void removeHighlight() {
            this.highlight = null;
            this.tip = null;
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
        }

        private void moveHighlight(ChromosomeLocus chromosomeLocus) {
            if (chromosomeLocus == null) {
                this.removeHighlight();
                return;
            }
            double d = 0.0;
            try {
                d = KaryoView.this.averager.getValue(chromosomeLocus, KaryoView.this.getCurrentCol());
            }
            catch (Exception exception) {
                this.removeHighlight();
                return;
            }
            if (d == KaryoView.this.nodata) {
                this.removeHighlight();
                return;
            }
            this.tip = KaryoView.this.karyoDrawer.getEnd(chromosomeLocus);
            if (this.highlight == null) {
                this.highlight = new Rectangle();
            }
            this.highlight.setBounds(this.tip.x - 5, this.tip.y - 5, 11, 11);
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
            this.repaintRect.setLocation(this.tip.x, this.tip.y);
            this.repaintRect.setSize(0, 0);
            this.repaintRect.add(this.highlight);
            this.repaintRect.add(this.tip);
            this.repaintRect.add(this.startPoint);
            this.repaintRect.grow(1, 1);
            ((JComponent)((Object)KaryoView.this)).repaint(this.repaintRect);
        }
    }

    class AveragerTask {
        private int current = 0;
        private String statMessage;

        AveragerTask() {
        }

        void go() {
            this.setCurrent(0);
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    return new ActualTask();
                }
            };
            swingWorker.start();
        }

        int getLengthOfTask() {
            return KaryoView.this.karyoDrawer.getGenome().getNumLoci();
        }

        int getCurrent() {
            return this.current;
        }

        void setCurrent(int n) {
            this.current = n;
        }

        public void incrCurrent() {
            ++this.current;
        }

        void stop() {
            this.current = this.getLengthOfTask();
        }

        boolean done() {
            return this.current >= this.getLengthOfTask();
        }

        String getMessage() {
            return this.statMessage;
        }

        class ActualTask {
            ActualTask() {
                KaryoView.this.karyoDrawer.setNodata(KaryoView.this.nodata);
                Genome genome = KaryoView.this.karyoDrawer.getGenome();
                int n = genome.getMaxChromosome();
                AveragerTask.this.setCurrent(0);
                for (int i = 1; i <= n; ++i) {
                    AveragerTask.this.statMessage = "Processing Chromosome " + i;
                    ChromosomeLocus chromosomeLocus = genome.getChromosome(i).getLeftEnd();
                    if (chromosomeLocus == null) continue;
                    ChromosomeLocus chromosomeLocus2 = chromosomeLocus;
                    int n2 = KaryoView.this.getCurrentCol();
                    double d = KaryoView.this.getNodata();
                    while (!AveragerTask.this.done()) {
                        if (chromosomeLocus2.getCdtIndex() != -1) {
                            try {
                                KaryoView.this.karyoDrawer.setMapValue(chromosomeLocus2, ((AveragerTask)AveragerTask.this).KaryoView.this.averager.getValue(chromosomeLocus2, n2));
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                KaryoView.this.karyoDrawer.setMapValue(chromosomeLocus2, d);
                            }
                        } else {
                            KaryoView.this.karyoDrawer.setMapValue(chromosomeLocus2, d);
                        }
                        chromosomeLocus2 = chromosomeLocus2.getRight();
                        AveragerTask.this.incrCurrent();
                        if (chromosomeLocus2 != chromosomeLocus && chromosomeLocus2 != null) continue;
                    }
                    if (AveragerTask.this.done()) break;
                }
                AveragerTask.this.stop();
            }
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (KaryoView.this.averagerMonitor.isCanceled() || KaryoView.this.averagerTask.done()) {
                KaryoView.this.averagerMonitor.close();
                KaryoView.this.averagerTask.stop();
                KaryoView.this.averagerSettingsPanel.setEnabled(true);
                KaryoView.this.averageTimer.stop();
                if (KaryoView.this.averagerTask.done()) {
                    KaryoView.this.averagerMonitor.setNote("Averaging complete");
                }
            } else {
                KaryoView.this.averagerMonitor.setNote(KaryoView.this.averagerTask.getMessage());
                KaryoView.this.averagerMonitor.setProgress(KaryoView.this.averagerTask.getCurrent());
            }
            ((Component)((Object)KaryoView.this)).repaint();
        }
    }
}

