/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.plugin.karyoview.KaryoDrawer;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class KaryoViewParameterPanel
extends JPanel {
    private KaryoView karyoView;
    private KaryoDrawer karyoDrawer;
    private KaryoPanel karyoPanel;
    private SizePanel sizePanel;
    private ExperimentPanel experimentPanel;
    private PopupPanel popupPanel;

    public KaryoViewParameterPanel(KaryoDrawer karyoDrawer, KaryoView karyoView, KaryoPanel karyoPanel) {
        this.setLayout(new BoxLayout(this, 1));
        this.karyoDrawer = karyoDrawer;
        this.karyoView = karyoView;
        this.karyoPanel = karyoPanel;
        this.experimentPanel = new ExperimentPanel();
        this.add(this.experimentPanel);
        this.sizePanel = new SizePanel();
        this.add(this.sizePanel);
        this.popupPanel = new PopupPanel();
        this.add(this.popupPanel);
    }

    public void getValues() {
        this.sizePanel.getValues();
        this.experimentPanel.getValues();
    }

    public void setValues() {
        this.sizePanel.setValues();
        this.experimentPanel.setValues();
        this.karyoDrawer.notifyObservers();
    }

    private static String reformatInt(int n) {
        Integer n2 = new Integer(n);
        return n2.toString();
    }

    private static String reformatDouble(double d) {
        int n = 1;
        if (Math.abs(d) < 1.0E-4) {
            Double d2 = new Double(d);
            return d2.toString();
        }
        while (Math.abs(d * (double)n) < 1000.0) {
            n *= 10;
        }
        int n2 = (int)(d * (double)n);
        Double d3 = new Double((double)n2 / (double)n);
        return d3.toString();
    }

    class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            JButton jButton = new JButton("Prev");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoViewParameterPanel.this.experimentPanel.prev();
                    KaryoViewParameterPanel.this.setValues();
                }
            });
            JButton jButton2 = new JButton("Same");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoViewParameterPanel.this.setValues();
                }
            });
            JButton jButton3 = new JButton("Next");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoViewParameterPanel.this.experimentPanel.next();
                    KaryoViewParameterPanel.this.setValues();
                }
            });
            this.add(jButton);
            this.add(jButton2);
            this.add(jButton3);
        }
    }

    class SelectedPanel
    extends JPanel {
        JComboBox iconBox = new JComboBox();
        JComboBox iconSize;

        public SelectedPanel() {
            String[] stringArray = KaryoViewParameterPanel.this.karyoDrawer.getIconTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                this.iconBox.addItem(stringArray[i]);
            }
            this.iconSize = new JComboBox();
            int[] nArray = KaryoViewParameterPanel.this.karyoDrawer.getIconSizes();
            for (int i = 0; i < nArray.length; ++i) {
                this.iconSize.addItem(KaryoViewParameterPanel.reformatInt(nArray[i]));
            }
            this.add(new JLabel("Highlight Selected with "));
            this.add(this.iconBox);
            this.add(this.iconSize);
            this.getValues();
            this.iconBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SelectedPanel.this.setValues();
                }
            });
            this.iconSize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SelectedPanel.this.setValues();
                }
            });
        }

        public void getValues() {
            this.iconBox.setSelectedIndex(KaryoViewParameterPanel.this.karyoDrawer.getIconType());
            this.iconSize.setSelectedIndex(KaryoViewParameterPanel.this.karyoDrawer.getIconSize());
            this.revalidate();
        }

        public void setValues() {
            KaryoViewParameterPanel.this.karyoDrawer.setIconType(this.iconBox.getSelectedIndex());
            KaryoViewParameterPanel.this.karyoDrawer.setIconSize(this.iconSize.getSelectedIndex());
            KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
        }
    }

    class PopupPanel
    extends JPanel {
        public PopupPanel() {
            JButton jButton = new JButton("Display...");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoViewParameterPanel.this.karyoPanel.showDisplayPopup();
                }
            });
            JButton jButton2 = new JButton("Coordinates...");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoViewParameterPanel.this.karyoPanel.showCoordinatesPopup();
                }
            });
            JButton jButton3 = new JButton("Averaging...");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoViewParameterPanel.this.karyoPanel.showAveragingPopup();
                }
            });
            this.add(jButton);
            this.add(jButton2);
            this.add(jButton3);
        }
    }

    class SizePanel
    extends JPanel {
        JTextField widthField;
        JTextField heightField;
        private ScalePanel scalePanel;

        public SizePanel() {
            DocumentListener documentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    SizePanel.this.setMyValues();
                    KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    SizePanel.this.setMyValues();
                    KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SizePanel.this.setMyValues();
                    KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
                }
            };
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Size"));
            jPanel.add(new JLabel("Width"));
            this.widthField = new JTextField();
            this.widthField.setColumns(5);
            jPanel.add(this.widthField);
            jPanel.add(new JLabel("Height"));
            this.heightField = new JTextField();
            this.heightField.setColumns(5);
            jPanel.add(this.heightField);
            JButton jButton = new JButton("Auto");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KaryoViewParameterPanel.this.karyoView.redoScale();
                }
            });
            jPanel.add(jButton);
            this.scalePanel = new ScalePanel();
            this.getValues();
            this.add(jPanel);
            this.add(this.scalePanel);
            this.widthField.getDocument().addDocumentListener(documentListener);
            this.heightField.getDocument().addDocumentListener(documentListener);
        }

        public void getValues() {
            int n = KaryoViewParameterPanel.this.karyoDrawer.getWidth();
            int n2 = KaryoViewParameterPanel.this.karyoDrawer.getHeight();
            this.widthField.setText(KaryoViewParameterPanel.reformatInt(n));
            this.heightField.setText(KaryoViewParameterPanel.reformatInt(n2));
            this.scalePanel.getValues();
            this.revalidate();
        }

        public void setMyValues() {
            try {
                Double d = new Double(this.widthField.getText());
                Double d2 = new Double(this.heightField.getText());
                KaryoViewParameterPanel.this.karyoDrawer.setWidth((int)d.doubleValue());
                KaryoViewParameterPanel.this.karyoDrawer.setHeight((int)d2.doubleValue());
                KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setValues() {
            try {
                this.scalePanel.setValues();
                Double d = new Double(this.widthField.getText());
                Double d2 = new Double(this.heightField.getText());
                KaryoViewParameterPanel.this.karyoDrawer.setWidth((int)d.doubleValue());
                KaryoViewParameterPanel.this.karyoDrawer.setHeight((int)d2.doubleValue());
                KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class ScalePanel
    extends JPanel {
        JTextField ppmField;
        JTextField ppvField;

        public ScalePanel() {
            DocumentListener documentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setValues();
                    KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setValues();
                    KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ScalePanel.this.setValues();
                    KaryoViewParameterPanel.this.karyoDrawer.notifyObservers();
                }
            };
            this.add(new JLabel("Pixels per map: "));
            Double d = new Double(KaryoViewParameterPanel.this.karyoDrawer.getPixelPerMap());
            this.ppmField = new JTextField(d.toString());
            this.ppmField.setColumns(5);
            this.add(this.ppmField);
            this.add(new JLabel("Pixels per Value: "));
            Double d2 = new Double(KaryoViewParameterPanel.this.karyoDrawer.getPixelPerVal());
            this.ppvField = new JTextField(d2.toString());
            this.ppvField.setColumns(5);
            this.add(this.ppvField);
            this.getValues();
            this.ppmField.getDocument().addDocumentListener(documentListener);
            this.ppvField.getDocument().addDocumentListener(documentListener);
        }

        public void getValues() {
            double d = KaryoViewParameterPanel.this.karyoDrawer.getPixelPerMap();
            double d2 = KaryoViewParameterPanel.this.karyoDrawer.getPixelPerVal();
            this.ppmField.setText(KaryoViewParameterPanel.reformatDouble(d));
            this.ppvField.setText(KaryoViewParameterPanel.reformatDouble(d2));
            this.revalidate();
        }

        public void setValues() {
            try {
                Double d = new Double(this.ppmField.getText());
                Double d2 = new Double(this.ppvField.getText());
                KaryoViewParameterPanel.this.karyoDrawer.setPixelPerMap(d);
                KaryoViewParameterPanel.this.karyoDrawer.setPixelPerVal(d2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class ExperimentPanel
    extends JPanel {
        JComboBox pulldown;

        public ExperimentPanel() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Experiment:"));
            String[] stringArray = KaryoViewParameterPanel.this.karyoView.getExperiments();
            this.pulldown = new JComboBox<String>(stringArray);
            this.pulldown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExperimentPanel.this.setValues();
                }
            });
            jPanel.add(this.pulldown);
            this.getValues();
            this.add(jPanel);
            this.add(new ButtonPanel());
        }

        public void next() {
            int n = this.pulldown.getSelectedIndex() + 1;
            int n2 = this.pulldown.getItemCount();
            this.pulldown.setSelectedIndex(n % n2);
        }

        public void prev() {
            int n = this.pulldown.getSelectedIndex() - 1;
            if (n >= 0) {
                this.pulldown.setSelectedIndex(n);
            }
        }

        public void getValues() {
            try {
                this.pulldown.setSelectedIndex(KaryoViewParameterPanel.this.karyoView.getCurrentCol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void setValues() {
            KaryoViewParameterPanel.this.karyoView.setCurrentCol(this.pulldown.getSelectedIndex());
        }
    }
}

