/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.LinearTransformation;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.ModelViewBuffered;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ATRView
extends ModelViewBuffered
implements MouseListener,
KeyListener {
    private static final String[] hints = new String[]{"Click to select node", " - use arrow keys to navigate tree"};
    protected HeaderSummary headerSummary = new HeaderSummary();
    private TreeSelectionI arraySelection;
    private LinearTransformation xScaleEq;
    private LinearTransformation yScaleEq;
    private MapContainer map;
    private JScrollBar scrollbar;
    private InvertedTreeDrawer drawer = null;
    private TreeDrawerNode selectedNode = null;
    private Rectangle destRect = null;

    public ATRView() {
        ((ModelView)this).panel = new JPanel();
        this.scrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.destRect = new Rectangle();
        ((ModelView)this).panel.setLayout(new BorderLayout());
        ((ModelView)this).panel.add((Component)((Object)this), "Center");
        ((ModelView)this).panel.add((Component)this.scrollbar, "East");
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addKeyListener(this);
    }

    public String[] getHints() {
        return hints;
    }

    public void setSelectedNode(TreeDrawerNode treeDrawerNode) {
        if (this.selectedNode == treeDrawerNode) {
            return;
        }
        if (this.selectedNode != null) {
            this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode, false);
        }
        this.selectedNode = treeDrawerNode;
        if (this.selectedNode != null && this.xScaleEq != null) {
            this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode, true);
        }
        if (((ModelView)this).status != null && ((ModelView)this).hasMouse) {
            ((ModelView)this).status.setMessages(this.getStatus());
        }
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    private void synchMap() {
        if (this.selectedNode != null && this.arraySelection != null) {
            int n = (int)this.selectedNode.getLeftLeaf().getIndex();
            int n2 = (int)this.selectedNode.getRightLeaf().getIndex();
            this.arraySelection.deselectAllIndexes();
            this.arraySelection.setSelectedNode(this.selectedNode.getId());
            this.arraySelection.selectIndexRange(n, n2);
            this.arraySelection.notifyObservers();
        }
        if (((ModelView)this).status != null && ((ModelView)this).hasMouse) {
            ((ModelView)this).status.setMessages(this.getStatus());
        }
    }

    public void setArraySelection(TreeSelectionI treeSelectionI) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver((Observer)((Object)this));
        }
        this.arraySelection = treeSelectionI;
        this.arraySelection.addObserver((Observer)((Object)this));
    }

    public void setInvertedTreeDrawer(InvertedTreeDrawer invertedTreeDrawer) {
        if (this.drawer != null) {
            this.drawer.deleteObserver((Observer)((Object)this));
        }
        this.drawer = invertedTreeDrawer;
        this.drawer.addObserver((Observer)((Object)this));
    }

    public void setMap(MapContainer mapContainer) {
        if (this.map != null) {
            this.map.deleteObserver((Observer)((Object)this));
        }
        this.map = mapContainer;
        this.map.addObserver((Observer)((Object)this));
    }

    public void update(Observable observable, Object object) {
        if (!((Component)((Object)this)).isEnabled()) {
            return;
        }
        if (observable == this.map) {
            ((ModelView)this).offscreenValid = false;
            ((Component)((Object)this)).repaint();
        } else if (observable == this.drawer) {
            ((ModelView)this).offscreenValid = false;
            ((Component)((Object)this)).repaint();
        } else if (observable == this.arraySelection) {
            TreeDrawerNode treeDrawerNode = null;
            if (this.arraySelection.getNSelectedIndexes() > 0) {
                if (this.arraySelection.getMinIndex() == this.arraySelection.getMaxIndex()) {
                    treeDrawerNode = this.drawer.getLeaf(this.arraySelection.getMinIndex());
                }
                if (this.arraySelection.getMinIndex() == this.map.getMinIndex() && this.arraySelection.getMaxIndex() == this.map.getMaxIndex()) {
                    treeDrawerNode = this.drawer.getRootNode();
                }
            }
            if (treeDrawerNode != null && treeDrawerNode.getId() != this.arraySelection.getSelectedNode()) {
                this.arraySelection.setSelectedNode(treeDrawerNode.getId());
                this.arraySelection.notifyObservers();
            } else {
                this.setSelectedNode(this.drawer.getNodeById(this.arraySelection.getSelectedNode()));
            }
        } else {
            System.out.println(this.viewName() + "Got an update from unknown " + observable);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        ((Component)((Object)this)).repaint();
    }

    public String viewName() {
        return "ATRView";
    }

    public String[] getStatus() {
        String[] stringArray;
        if (this.selectedNode != null) {
            if (this.selectedNode.isLeaf()) {
                stringArray = new String[]{"Leaf Node " + this.selectedNode.getId(), "Pos " + this.selectedNode.getCorr()};
            } else {
                int[] nArray = this.getHeaderSummary().getIncluded();
                stringArray = new String[nArray.length * 2];
                HeaderInfo headerInfo = this.getViewFrame().getDataModel().getAtrHeaderInfo();
                String[] stringArray2 = headerInfo.getNames();
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray[2 * i] = stringArray2[nArray[i]] + ":";
                    stringArray[2 * i + 1] = " " + headerInfo.getHeader(headerInfo.getHeaderIndex(this.selectedNode.getId()))[nArray[i]];
                }
            }
        } else {
            stringArray = new String[]{"Select Node to ", "view annotation."};
        }
        return stringArray;
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void updateBuffer(Graphics graphics) {
        if (((ModelView)this).offscreenChanged) {
            ((ModelView)this).offscreenValid = false;
        }
        if (!((ModelView)this).offscreenValid && this.drawer != null) {
            this.map.setAvailablePixels(((ModelView)this).offscreenSize.width);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, ((ModelView)this).offscreenSize.width, ((ModelView)this).offscreenSize.height);
            graphics.setColor(Color.black);
            this.destRect.setBounds(0, 0, this.map.getUsedPixels(), ((ModelView)this).offscreenSize.height);
            this.xScaleEq = new LinearTransformation((double)this.map.getIndex(this.destRect.x), (double)this.destRect.x, (double)this.map.getIndex(this.destRect.x + this.destRect.width), (double)(this.destRect.x + this.destRect.width));
            this.yScaleEq = new LinearTransformation(this.drawer.getCorrMin(), (double)this.destRect.y, this.drawer.getCorrMax(), (double)(this.destRect.y + this.destRect.height));
            this.drawer.paint(graphics, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!((Component)((Object)this)).isEnabled()) {
            return;
        }
        if (this == null) {
            return;
        }
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        if (this.drawer != null) {
            this.setSelectedNode(this.drawer.getClosest(this.xScaleEq.inverseTransform((double)mouseEvent.getX()), this.yScaleEq.inverseTransform((double)mouseEvent.getY()), this.yScaleEq.getSlope() / this.xScaleEq.getSlope()));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.selectedNode == null) {
            return;
        }
        int n = keyEvent.getKeyCode();
        Object var3_3 = null;
        switch (n) {
            case 38: {
                this.selectParent();
                break;
            }
            case 37: {
                if (this.selectedNode.isLeaf()) break;
                this.selectLeft();
                break;
            }
            case 39: {
                if (this.selectedNode.isLeaf()) break;
                this.selectRight();
                break;
            }
            case 40: {
                if (this.selectedNode.isLeaf()) break;
                TreeDrawerNode treeDrawerNode = this.selectedNode.getRight();
                TreeDrawerNode treeDrawerNode2 = this.selectedNode.getLeft();
                if (treeDrawerNode.getRange() > treeDrawerNode2.getRange()) {
                    this.selectRight();
                    break;
                }
                this.selectLeft();
            }
        }
    }

    private void selectParent() {
        TreeDrawerNode treeDrawerNode = this.selectedNode;
        this.selectedNode = treeDrawerNode.getParent();
        if (this.selectedNode == null) {
            this.selectedNode = treeDrawerNode;
            return;
        }
        treeDrawerNode = treeDrawerNode == this.selectedNode.getLeft() ? this.selectedNode.getRight() : this.selectedNode.getLeft();
        this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, treeDrawerNode, true);
        this.drawer.paintSingle(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, this.selectedNode, true);
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    private void selectRight() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode treeDrawerNode = this.selectedNode;
        this.selectedNode = treeDrawerNode.getRight();
        this.drawer.paintSingle(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, treeDrawerNode, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, treeDrawerNode.getLeft(), false);
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    private void selectLeft() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode treeDrawerNode = this.selectedNode;
        this.selectedNode = treeDrawerNode.getLeft();
        this.drawer.paintSingle(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, treeDrawerNode, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.xScaleEq, this.yScaleEq, this.destRect, treeDrawerNode.getRight(), false);
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

