/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

public abstract class ArrayDrawer
extends Observable
implements Observer {
    private ConfigNode root;

    public abstract Color getColor(int var1, int var2);

    protected abstract void setDefaults();

    public abstract boolean isMissing(int var1, int var2);

    public abstract boolean isEmpty(int var1, int var2);

    public abstract String getSummary(int var1, int var2);

    public abstract int getNumRow();

    public abstract int getNumCol();

    public abstract void paint(int[] var1, Rectangle var2, Rectangle var3, int var4, int[] var5);

    public ArrayDrawer() {
        this.setDefaults();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public void paint(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, int[] nArray) {
        int n = rectangle2.y;
        for (int i = 0; i < rectangle.height; ++i) {
            int n2 = n;
            n = rectangle2.y + (rectangle2.height + i * rectangle2.height) / rectangle.height;
            int n3 = rectangle2.x;
            for (int j = 0; j < rectangle.width; ++j) {
                int n4 = n3;
                n3 = rectangle2.x + (rectangle2.width + j * rectangle2.width) / rectangle.width;
                int n5 = n3 - n4;
                int n6 = n - n2;
                if (n5 <= 0 || n6 <= 0) continue;
                try {
                    int n7 = rectangle.y + i;
                    if (nArray != null) {
                        n7 = nArray[n7];
                    }
                    Color color = this.getColor(j + rectangle.x, n7);
                    graphics.setColor(color);
                    graphics.fillRect(n4, n2, n5, n6);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public void paint(int[] nArray, Rectangle rectangle, Rectangle rectangle2, int n) {
        this.paint(nArray, rectangle, rectangle2, n, null);
    }

    public void paintPixel(Graphics graphics, MapContainer mapContainer, MapContainer mapContainer2, int n, int n2, int[] nArray) {
        try {
            int n3 = mapContainer2.getIndex(n2);
            if (nArray != null) {
                n3 = nArray[n3];
            }
            Color color = this.getColor(mapContainer.getIndex(n), n3);
            graphics.setColor(color);
            graphics.fillRect(n, n2, 1, 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers();
    }

    public ConfigNode getRoot() {
        return this.root;
    }

    public void setRoot(ConfigNode configNode) {
        this.root = configNode;
    }
}

