/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.plugin.dendroview.AtrAnalysisNode;
import edu.stanford.genetics.treeview.plugin.dendroview.DendroException;
import java.util.Hashtable;
import java.util.Vector;

public class AtrAligner {
    public static int[] align(HeaderInfo headerInfo, HeaderInfo headerInfo2, HeaderInfo headerInfo3, HeaderInfo headerInfo4) throws DendroException {
        int n = headerInfo2.getNumHeaders();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        AtrAnalysisNode atrAnalysisNode = AtrAligner.createAnalysisTree(headerInfo, headerInfo2);
        AtrAligner.alignTree(atrAnalysisNode, headerInfo2, headerInfo4, nArray);
        return nArray;
    }

    private static AtrAnalysisNode createAnalysisTree(HeaderInfo headerInfo, HeaderInfo headerInfo2) throws DendroException {
        int n = headerInfo2.getNumHeaders();
        AtrAnalysisNode[] atrAnalysisNodeArray = new AtrAnalysisNode[n];
        Hashtable<String, AtrAnalysisNode> hashtable = new Hashtable<String, AtrAnalysisNode>(headerInfo.getNumHeaders() * 4 / 3 / 2, 0.75f);
        for (int i = 0; i < headerInfo.getNumHeaders(); ++i) {
            int n2;
            String string = headerInfo.getHeader(i, "NODEID");
            String string2 = headerInfo.getHeader(i, "LEFT");
            String string3 = headerInfo.getHeader(i, "RIGHT");
            AtrAnalysisNode atrAnalysisNode = (AtrAnalysisNode)hashtable.get(string);
            AtrAnalysisNode atrAnalysisNode2 = (AtrAnalysisNode)hashtable.get(string2);
            AtrAnalysisNode atrAnalysisNode3 = (AtrAnalysisNode)hashtable.get(string3);
            if (atrAnalysisNode != null) {
                System.out.println("Symbol '" + string + "' appeared twice, building weird tree");
            } else {
                atrAnalysisNode = new AtrAnalysisNode(string, null);
                hashtable.put(string, atrAnalysisNode);
            }
            if (atrAnalysisNode2 == null) {
                n2 = headerInfo2.getHeaderIndex(string2);
                if (n2 == -1) {
                    throw new DendroException("Identifier " + string2 + " from tree file not found in CDT");
                }
                atrAnalysisNode2 = new AtrAnalysisNode(string2, atrAnalysisNode);
                atrAnalysisNode2.setIndex(n2);
                atrAnalysisNode2.setName(headerInfo2.getHeader(n2, "GID"));
                atrAnalysisNodeArray[n2] = atrAnalysisNode2;
                hashtable.put(string2, atrAnalysisNode2);
            }
            if (atrAnalysisNode3 == null) {
                n2 = headerInfo2.getHeaderIndex(string3);
                if (n2 == -1) {
                    throw new DendroException("Identifier " + string3 + " from tree file not found in CDT.");
                }
                atrAnalysisNode3 = new AtrAnalysisNode(string3, atrAnalysisNode);
                atrAnalysisNode3.setIndex(n2);
                atrAnalysisNode3.setName(headerInfo2.getHeader(n2, "GID"));
                atrAnalysisNodeArray[n2] = atrAnalysisNode3;
                hashtable.put(string3, atrAnalysisNode3);
            }
            if (atrAnalysisNode2.getIndex() > atrAnalysisNode3.getIndex()) {
                AtrAnalysisNode atrAnalysisNode4 = atrAnalysisNode2;
                atrAnalysisNode2 = atrAnalysisNode3;
                atrAnalysisNode3 = atrAnalysisNode4;
            }
            atrAnalysisNode3.setParent(atrAnalysisNode);
            atrAnalysisNode2.setParent(atrAnalysisNode);
            atrAnalysisNode.setLeft(atrAnalysisNode2);
            atrAnalysisNode.setRight(atrAnalysisNode3);
        }
        return (AtrAnalysisNode)atrAnalysisNodeArray[0].findRoot();
    }

    private static void alignTree(AtrAnalysisNode atrAnalysisNode, HeaderInfo headerInfo, HeaderInfo headerInfo2, int[] nArray) {
        int n;
        Vector vector = new Vector();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n2 = headerInfo2.getIndex("GID");
        for (n = 0; n < headerInfo2.getNumHeaders(); ++n) {
            hashtable.put(headerInfo2.getHeader(n)[n2], new Integer(n));
        }
        atrAnalysisNode.indexTree(headerInfo2, hashtable);
        atrAnalysisNode.enumerate(vector);
        for (n = 0; n < vector.size(); ++n) {
            nArray[n] = headerInfo.getHeaderIndex(((AtrAnalysisNode)vector.get(n)).getID());
        }
    }
}

