/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.CharColorExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class CharArrayDrawer
extends ArrayDrawer {
    protected CharColorExtractor colorExtractor;
    protected HeaderInfo headerInfo;
    protected String headerName;

    public void setColorExtractor(CharColorExtractor charColorExtractor) {
        if (this.colorExtractor != null) {
            this.colorExtractor.deleteObserver(this);
        }
        this.colorExtractor = charColorExtractor;
        charColorExtractor.addObserver(this);
        this.setChanged();
    }

    public CharColorExtractor getColorExtractor() {
        return this.colorExtractor;
    }

    public void setHeaderInfo(HeaderInfo headerInfo, String string) {
        if (this.headerInfo != headerInfo || this.headerName != string) {
            this.headerInfo = headerInfo;
            this.headerName = string;
            this.setChanged();
        }
    }

    public void paint(int[] nArray, Rectangle rectangle, Rectangle rectangle2, int n, int[] nArray2) {
        if (this.headerInfo == null) {
            System.out.println("header info wasn't set");
        }
        int n2 = rectangle2.y;
        int n3 = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            n2 = rectangle2.y + (rectangle2.height + i * rectangle2.height) / rectangle.height;
            int n4 = n2;
            if (n2 == n4) continue;
            int n5 = rectangle2.x;
            int n6 = 0;
            for (int j = 0; j < rectangle.width; ++j) {
                n5 = rectangle2.x + (rectangle2.width + j * rectangle2.width) / rectangle.width;
                int n7 = n5;
                if (n5 == n7) continue;
                try {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    for (n10 = n3; n10 <= i; ++n10) {
                        for (n9 = n6; n9 <= j; ++n9) {
                            n8 = rectangle.y + n10;
                            if (nArray2 != null) {
                                n8 = nArray2[n8];
                            }
                            Color color = this.getColor(n9 + rectangle.x, n8);
                            n11 += color.getRed();
                            n12 += color.getGreen();
                            n13 += color.getBlue();
                            ++n14;
                        }
                    }
                    if (n14 == 0) {
                        n10 = this.getColorExtractor().getMissing().getRGB();
                    } else {
                        Color color = new Color(n11 / n14, n12 / n14, n13 / n14);
                        n10 = color.getRGB();
                    }
                    for (n9 = n7; n9 < n5; ++n9) {
                        for (n8 = n4; n8 < n2; ++n8) {
                            nArray[n9 + n8 * n] = n10;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                n6 = j + 1;
            }
            n3 = i + 1;
        }
    }

    public void paintChars(Graphics graphics, MapContainer mapContainer, MapContainer mapContainer2, Rectangle rectangle) {
        for (int i = mapContainer2.getIndex(rectangle.y); i < mapContainer2.getIndex(rectangle.height); ++i) {
            for (int j = mapContainer.getIndex(rectangle.x); j < mapContainer.getIndex(rectangle.width); ++j) {
                int n = mapContainer.getPixel(j);
                int n2 = mapContainer2.getPixel(i + 1);
                graphics.drawString(this.getSummary(j, i), n, n2);
            }
        }
    }

    public void paintChars(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent();
        for (int i = 0; i < rectangle.height; ++i) {
            for (int j = 0; j < rectangle.width; ++j) {
                int n2 = rectangle2.x + j * rectangle2.width / rectangle.width;
                int n3 = rectangle2.y + (i + 1) * rectangle2.height / rectangle.height;
                int n4 = rectangle2.x + (j + 1) * rectangle2.width / rectangle.width;
                int n5 = rectangle2.y + i * rectangle2.height / rectangle.height;
                String string = this.getSummary(j + rectangle.x, i + rectangle.y);
                int n6 = fontMetrics.stringWidth(string);
                int n7 = (n4 - n2 - n6) / 2;
                int n8 = (n3 - n5 - n) / 2;
                graphics.drawString(string, n2 + n7, n3 - n8);
            }
        }
    }

    public char getChar(int n, int n2) {
        String string = this.headerInfo.getHeader(n2, this.headerName);
        try {
            if (string != null) {
                return string.charAt(n);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return '\u0000';
    }

    public String getSummary(int n, int n2) {
        return "" + this.getChar(n, n2);
    }

    public boolean isMissing(int n, int n2) {
        String string = this.headerInfo.getHeader(n2, this.headerName);
        try {
            if (string != null) {
                char c = string.charAt(n);
            }
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return true;
        }
    }

    public boolean isEmpty(int n, int n2) {
        return false;
    }

    public int getNumRow() {
        if (this.headerInfo != null && this.headerName != null) {
            return this.headerInfo.getNumHeaders();
        }
        return 0;
    }

    public int getNumCol() {
        try {
            if (this.headerInfo != null && this.headerName != null) {
                int n = 0;
                for (int i = 0; i < this.headerInfo.getNumHeaders(); ++i) {
                    int n2;
                    String string = this.headerInfo.getHeader(i, this.headerName);
                    if (string == null || (n2 = string.length()) <= n) continue;
                    n = n2;
                }
                return n;
            }
        }
        catch (NullPointerException nullPointerException) {
            LogBuffer.println((String)("CharArrayDrawer.getNumCol() got error " + nullPointerException));
            nullPointerException.printStackTrace();
        }
        return 0;
    }

    public Color getColor(int n, int n2) {
        return this.colorExtractor.getColor(this.getChar(n, n2));
    }

    protected void setDefaults() {
        this.headerInfo = null;
    }
}

