/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.RotateImageFilter;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.DoubleArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.SimpleDataMatrix;
import edu.stanford.genetics.treeview.plugin.dendroview.TestColorBarExportPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class ColorBarExportPanel
extends JPanel
implements ConfigNodePersistent {
    private ConfigNode root;
    private FileSet sourceSet;
    private ColorExtractor colorExtractor;
    protected final int extraWidth = 5;
    protected final int extraHeight = 5;
    private FilePanel filePanel;
    private SettingsPanel settingsPanel;
    private PreviewPanel previewPanel;
    final int insetVal = 5;

    public void setColorExtractor(ColorExtractor colorExtractor) {
        this.colorExtractor = colorExtractor;
    }

    public ColorExtractor getColorExtractor() {
        return this.colorExtractor;
    }

    public FileSet getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(FileSet fileSet) {
        this.sourceSet = fileSet;
        if (this.filePanel != null) {
            this.filePanel.setFilePath(this.getInitialFilePath());
        }
    }

    protected boolean hasBbox() {
        return true;
    }

    protected boolean includeBbox() {
        return this.settingsPanel.useBbox();
    }

    protected File getFile() {
        return this.filePanel.getFile();
    }

    public String getFilePath() {
        return this.filePanel.getFilePath();
    }

    public void setFilePath(String string) {
        this.filePanel.setFilePath(string);
    }

    protected String getInitialExtension() {
        return ".ps";
    }

    protected String getInitialFilePath() {
        String string = null;
        string = this.sourceSet == null ? System.getProperty("user.home") : this.sourceSet.getDir() + this.sourceSet.getRoot() + this.getInitialExtension();
        if (this.root == null) {
            return string;
        }
        return this.root.getAttribute("file", string);
    }

    public ColorBarExportPanel(ColorExtractor colorExtractor) {
        this.colorExtractor = colorExtractor;
        this.setupWidgets();
    }

    public static final void main(String[] stringArray) {
        ColorExtractor colorExtractor = new ColorExtractor();
        colorExtractor.setDefaults();
        double d = colorExtractor.getContrast();
        colorExtractor.setMissing(d * 2.0, d * 2.0);
        TestColorBarExportPanel testColorBarExportPanel = new TestColorBarExportPanel(colorExtractor);
        JFrame jFrame = new JFrame("Test Export Panel");
        jFrame.getContentPane().add(testColorBarExportPanel);
        jFrame.pack();
        jFrame.show();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    private void setupWidgets() {
        Box box = new Box(0);
        this.settingsPanel = new SettingsPanel();
        this.settingsPanel.recalculateBbox();
        box.add(this.settingsPanel);
        this.previewPanel = new PreviewPanel();
        box.add(this.previewPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(box);
        this.filePanel = new FilePanel(this.getInitialFilePath());
        this.add(this.filePanel);
    }

    public double getXscale() {
        return this.settingsPanel.getXscale();
    }

    public double getYscale() {
        return this.settingsPanel.getYscale();
    }

    public int getDecimals() {
        return this.settingsPanel.getDecimals();
    }

    public int getNumBoxes() {
        return this.settingsPanel.getNumBoxes();
    }

    public boolean drawVertical() {
        return this.settingsPanel.drawVertical();
    }

    public int getBboxWidth() {
        return this.settingsPanel.getBboxWidth();
    }

    public int getBboxHeight() {
        return this.settingsPanel.getBboxHeight();
    }

    public Font getFont() {
        return new Font("Courier", 0, 12);
    }

    public String formatValue(double d) {
        try {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(this.getDecimals());
            numberFormat.setMinimumFractionDigits(this.getDecimals());
            return numberFormat.format(d);
        }
        catch (Exception exception) {
            int n;
            for (n = 0; n < this.getDecimals(); ++n) {
                d *= 10.0;
            }
            n = (int)d;
            double d2 = n;
            for (int i = 0; i < this.getDecimals(); ++i) {
                d2 /= 10.0;
            }
            return "" + d2;
        }
    }

    public int textLength() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        double d = this.getColorExtractor().getContrast();
        int n = this.getNumBoxes();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d * 2.0 / ((double)n - 1.0) - d;
            int n3 = fontMetrics.stringWidth(this.formatValue(d2));
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2 + 5;
    }

    public int estimateHeight() {
        if (this.drawVertical()) {
            return (int)((double)this.getNumBoxes() * this.getYscale());
        }
        return (int)(this.getXscale() + (double)this.textLength());
    }

    public int estimateWidth() {
        if (this.drawVertical()) {
            return (int)(this.getXscale() + (double)this.textLength());
        }
        return (int)((double)this.getNumBoxes() * this.getXscale());
    }

    protected BufferedImage generateImage() {
        Rectangle rectangle = new Rectangle(0, 0, this.estimateWidth(), this.estimateHeight());
        BufferedImage bufferedImage = new BufferedImage(rectangle.width + 5, rectangle.height + 5, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, rectangle.width + 1 + 5, rectangle.height + 1 + 5);
        graphics.setColor(Color.black);
        graphics.translate(2, 2);
        this.drawAll(graphics);
        return bufferedImage;
    }

    private void drawAll(Graphics graphics) {
        int n = this.estimateWidth();
        int n2 = this.estimateHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        double d = 1.0;
        this.drawBoxes(graphics, 0, 0, d);
        if (this.drawVertical()) {
            this.drawNumbers(graphics, (int)(this.getXscale() * d), 0, d);
        } else {
            this.drawNumbers(graphics, 0, 0, d);
        }
    }

    protected void drawBoxes(Graphics graphics, int n, int n2, double d) {
        DoubleArrayDrawer doubleArrayDrawer = new DoubleArrayDrawer();
        doubleArrayDrawer.setColorExtractor(this.getColorExtractor());
        int n3 = this.getNumBoxes();
        double[] dArray = new double[this.getNumBoxes()];
        double d2 = this.getColorExtractor().getContrast();
        for (int i = 0; i < n3; ++i) {
            double d3 = (double)i * d2 * 2.0 / ((double)n3 - 1.0) - d2;
            if (this.drawVertical()) {
                d3 = (double)(this.getNumBoxes() - i - 1) * d2 * 2.0 / ((double)n3 - 1.0) - d2;
            }
            dArray[i] = d3;
        }
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        if (this.drawVertical()) {
            doubleArrayDrawer.setDataMatrix(new SimpleDataMatrix(dArray, n3, 1));
            rectangle.width = 1;
            rectangle.height = n3;
            rectangle2.x = n;
            rectangle2.y = n2;
            rectangle2.height = (int)(this.getYscale() * (double)n3 * d);
            rectangle2.width = (int)(this.getXscale() * d);
        } else {
            doubleArrayDrawer.setDataMatrix(new SimpleDataMatrix(dArray, n3, 1));
            rectangle.width = n3;
            rectangle.height = 1;
            rectangle2.x = n;
            rectangle2.y = n2 + (int)((double)this.textLength() * d);
            rectangle2.width = (int)(this.getXscale() * (double)n3 * d);
            rectangle2.height = (int)(this.getYscale() * d);
        }
        doubleArrayDrawer.paint(graphics, rectangle, rectangle2, null);
    }

    protected void drawNumbersBox(Graphics graphics, int n, int n2, double d) {
        double d2;
        double d3;
        if (this.drawVertical()) {
            d3 = (double)this.textLength() * d;
            d2 = (double)this.getNumBoxes() * this.getYscale() * d;
        } else {
            d2 = (double)this.textLength() * d;
            d3 = (double)this.getNumBoxes() * this.getXscale() * d;
        }
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = (int)((double)this.textLength() * d);
        int n4 = (int)((double)fontMetrics.getHeight() * d);
        int n5 = (int)(d * 5.0);
        for (int i = 0; i < this.getNumBoxes(); ++i) {
            double d4;
            if (this.drawVertical()) {
                d4 = d2 / (double)this.getNumBoxes();
                graphics.fillRect(n + n5, n2 + (int)((double)i * d4 + (d4 - (double)n4) / 2.0), n3, n4);
                continue;
            }
            d4 = d3 / (double)this.getNumBoxes();
            graphics.fillRect(n + (int)((double)i * d4 + (d4 - (double)n4) / 2.0), n2, n4, n3);
        }
    }

    protected void drawNumbers(Graphics graphics, int n, int n2, double d) {
        double d2;
        double d3;
        if (this.drawVertical()) {
            d3 = (double)this.textLength() * d;
            d2 = (double)this.getNumBoxes() * this.getYscale() * d;
        } else {
            d2 = (double)this.textLength() * d;
            d3 = (double)this.getNumBoxes() * this.getXscale() * d;
        }
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        double d4 = (double)this.textLength() * d;
        double d5 = (double)fontMetrics.getHeight() * d;
        double d6 = d * 5.0;
        double d7 = this.getColorExtractor().getContrast();
        int n3 = this.getNumBoxes();
        if (this.drawVertical()) {
            double d8 = d2 / (double)this.getNumBoxes();
            for (int i = 0; i < this.getNumBoxes(); ++i) {
                double d9 = (double)(this.getNumBoxes() - i - 1) * d7 * 2.0 / ((double)n3 - 1.0) - d7;
                graphics.drawString(this.formatValue(d9), (int)((double)n + d6), n2 + (int)((double)i * d8 + (d8 + d5) / 2.0));
            }
        } else {
            double d10 = d3 / (double)this.getNumBoxes();
            Image image = this.createImage((int)(d2 + 5.0), (int)(d3 + 5.0));
            Graphics graphics2 = image.getGraphics();
            for (int i = 0; i < this.getNumBoxes(); ++i) {
                double d11 = (double)i * d7 * 2.0 / ((double)n3 - 1.0) - d7;
                graphics2.drawString(this.formatValue(d11), n2, n + (int)((double)i * d10 + (d10 + d5) / 2.0));
            }
            image = RotateImageFilter.rotate((Component)this, (Image)image);
            graphics.drawImage(image, n, (int)((double)n2 - d6), null);
        }
    }

    class FilePanel
    extends JPanel {
        private JTextField fileField;

        String getFilePath() {
            return this.fileField.getText();
        }

        File getFile() {
            return new File(this.getFilePath());
        }

        void setFilePath(String string) {
            this.fileField.setText(string);
            this.fileField.invalidate();
            this.fileField.revalidate();
            this.fileField.repaint();
        }

        public FilePanel(String string) {
            this.add(new JLabel("Export To: "));
            this.fileField = new JTextField(string);
            this.add(this.fileField);
            JButton jButton = new JButton("Browse");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JFileChooser jFileChooser = new JFileChooser();
                        int n = jFileChooser.showSaveDialog(ColorBarExportPanel.this);
                        if (n == 0) {
                            FilePanel.this.fileField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                        }
                    }
                    catch (IOException iOException) {
                        LogBuffer.println((String)("Got exception " + iOException));
                    }
                }
            });
            this.add(jButton);
        }
    }

    class SettingsPanel
    extends JPanel {
        JCheckBox verticalBox;
        JCheckBox bboxBox;
        JTextField xScaleField;
        JTextField yScaleField;
        JTextField decimalsField;
        JTextField numBoxesField;
        BboxRow bboxRow;
        SizeRow sizeRow;
        DocumentListener documentListener = null;

        public boolean useBbox() {
            return this.bboxBox.isSelected();
        }

        public boolean drawVertical() {
            return this.verticalBox.isSelected();
        }

        public int getNumBoxes() {
            try {
                Double d = new Double(this.numBoxesField.getText());
                return (int)d.doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                return 1;
            }
        }

        public int getDecimals() {
            try {
                Double d = new Double(this.decimalsField.getText());
                return (int)d.doubleValue();
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public double getXscale() {
            try {
                Double d = new Double(this.xScaleField.getText());
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }

        public double getYscale() {
            try {
                Double d = new Double(this.yScaleField.getText());
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }

        public int getBboxWidth() {
            try {
                return this.bboxRow.xSize();
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public int getBboxHeight() {
            try {
                return this.bboxRow.ySize();
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public void recalculateBbox() {
            if (this.drawVertical()) {
                this.bboxRow.setXsize(ColorBarExportPanel.this.textLength());
                this.bboxRow.setYsize(0);
            } else {
                this.bboxRow.setYsize(ColorBarExportPanel.this.textLength());
                this.bboxRow.setXsize(0);
            }
        }

        public void updateSize() {
            try {
                this.sizeRow.setXsize(ColorBarExportPanel.this.estimateWidth());
                this.sizeRow.setYsize(ColorBarExportPanel.this.estimateHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        SettingsPanel() {
            this.documentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    SettingsPanel.this.updateSize();
                    if (ColorBarExportPanel.this.previewPanel != null) {
                        ColorBarExportPanel.this.previewPanel.updatePreview();
                    }
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    SettingsPanel.this.updateSize();
                    if (ColorBarExportPanel.this.previewPanel != null) {
                        ColorBarExportPanel.this.previewPanel.updatePreview();
                    }
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SettingsPanel.this.updateSize();
                    if (ColorBarExportPanel.this.previewPanel != null) {
                        ColorBarExportPanel.this.previewPanel.updatePreview();
                    }
                }
            };
            this.setupWidgets();
        }

        private void setupWidgets() {
            this.setLayout(new BoxLayout(this, 1));
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SettingsPanel.this.updateSize();
                    if (ColorBarExportPanel.this.previewPanel != null) {
                        ColorBarExportPanel.this.previewPanel.updatePreview();
                    }
                }
            };
            this.add(new JLabel("Settings"));
            this.verticalBox = new JCheckBox("Draw Vertically");
            this.verticalBox.addActionListener(actionListener);
            JPanel jPanel = new JPanel();
            jPanel.add(this.verticalBox);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            this.numBoxesField = new JTextField(Double.toString(7.0));
            jPanel2.add(new JLabel("Number of Boxes"));
            jPanel2.add(this.numBoxesField);
            this.add(jPanel2);
            this.numBoxesField.getDocument().addDocumentListener(this.documentListener);
            JPanel jPanel3 = new JPanel();
            this.decimalsField = new JTextField(Double.toString(2.0));
            jPanel3.add(new JLabel("decimals"));
            jPanel3.add(this.decimalsField);
            this.add(jPanel3);
            this.decimalsField.getDocument().addDocumentListener(this.documentListener);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            JPanel jPanel5 = new JPanel();
            this.xScaleField = new JTextField(Double.toString(12.0));
            jPanel5.add(new JLabel("x scale"));
            jPanel5.add(this.xScaleField);
            jPanel4.add(jPanel5);
            this.yScaleField = new JTextField(Double.toString(12.0));
            JPanel jPanel6 = new JPanel();
            jPanel6.add(new JLabel("y scale"));
            jPanel6.add(this.yScaleField);
            jPanel4.add(jPanel6);
            jPanel4.add(new JLabel("Use apple key to select multiple headers"));
            this.add(jPanel4);
            this.xScaleField.getDocument().addDocumentListener(this.documentListener);
            this.yScaleField.getDocument().addDocumentListener(this.documentListener);
            this.bboxBox = new JCheckBox("Bounding Box?", ColorBarExportPanel.this.hasBbox());
            this.bboxBox.addActionListener(actionListener);
            jPanel = new JPanel();
            jPanel.add(this.bboxBox);
            this.bboxRow = new BboxRow();
            if (ColorBarExportPanel.this.hasBbox()) {
                this.add(jPanel);
                this.add(this.bboxRow);
            }
            this.sizeRow = new SizeRow();
            this.add(this.sizeRow);
        }

        class SizeRow
        extends JPanel {
            JTextField xSize;
            JTextField ySize;

            public SizeRow() {
                this.setupWidgets();
            }

            protected void setupWidgets() {
                this.add(new JLabel("Total Size:"));
                this.xSize = new JTextField("2", 5);
                this.ySize = new JTextField("2", 5);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(inch)"));
            }

            int xSize() {
                Double d = new Double(this.xSize.getText());
                return (int)(d * 72.0);
            }

            void setXsize(int n) {
                this.xSize.setText(this.convert(n));
            }

            void setYsize(int n) {
                this.ySize.setText(this.convert(n));
            }

            private String convert(int n) {
                Double d = new Double(Math.rint((double)n * 100.0 / 72.0) / 100.0);
                return d.toString();
            }

            int ySize() {
                Double d = new Double(this.ySize.getText());
                return (int)(d * 72.0);
            }

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.xSize.setEnabled(bl);
                this.ySize.setEnabled(bl);
            }
        }

        class BboxRow
        extends SizeRow {
            BboxRow() {
            }

            protected void setupWidgets() {
                DocumentListener documentListener = new DocumentListener(){

                    public void changedUpdate(DocumentEvent documentEvent) {
                        SettingsPanel.this.updateSize();
                        if (ColorBarExportPanel.this.previewPanel != null) {
                            ColorBarExportPanel.this.previewPanel.updatePreview();
                        }
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        SettingsPanel.this.updateSize();
                        if (ColorBarExportPanel.this.previewPanel != null) {
                            ColorBarExportPanel.this.previewPanel.updatePreview();
                        }
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        SettingsPanel.this.updateSize();
                        if (ColorBarExportPanel.this.previewPanel != null) {
                            ColorBarExportPanel.this.previewPanel.updatePreview();
                        }
                    }
                };
                this.add(new JLabel("BBox size:"));
                this.xSize = new JTextField("2", 4);
                this.ySize = new JTextField("2", 4);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(inch)"));
                this.xSize.getDocument().addDocumentListener(documentListener);
                this.ySize.getDocument().addDocumentListener(documentListener);
            }
        }
    }

    class PreviewPanel
    extends JPanel {
        JCheckBox drawPreview;

        public void updatePreview() {
            this.repaint();
        }

        PreviewPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Preview"), "North");
            this.add((Component)new DrawingPanel(), "Center");
            this.drawPreview = new JCheckBox("Draw Preview");
            this.drawPreview.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreviewPanel.this.updatePreview();
                }
            });
            this.drawPreview.setSelected(true);
            this.add((Component)this.drawPreview, "South");
        }

        class DrawingPanel
        extends JPanel {
            double scale;

            DrawingPanel() {
            }

            public void paintComponent(Graphics graphics) {
                Dimension dimension = this.getSize();
                int n = ColorBarExportPanel.this.estimateWidth();
                int n2 = ColorBarExportPanel.this.estimateHeight();
                if (n == 0 || n2 == 0) {
                    return;
                }
                if (n * dimension.height > n2 * dimension.width) {
                    n2 = n2 * dimension.width / n;
                    n = dimension.width;
                } else {
                    n = n * dimension.height / n2;
                    n2 = dimension.height;
                }
                this.scale = (double)n / (double)ColorBarExportPanel.this.estimateWidth();
                if (this.scale > 1.0) {
                    this.scale = 1.0;
                }
                n = (int)((double)ColorBarExportPanel.this.estimateWidth() * this.scale);
                n2 = (int)((double)ColorBarExportPanel.this.estimateHeight() * this.scale);
                if (PreviewPanel.this.drawPreview == null || PreviewPanel.this.drawPreview.isSelected()) {
                    BufferedImage bufferedImage = ColorBarExportPanel.this.generateImage();
                    graphics.drawImage(bufferedImage, 0, 0, n, n2, null);
                } else {
                    graphics.setColor(Color.red);
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[4];
                    nArray[0] = 0;
                    nArray[1] = 5;
                    nArray[2] = n;
                    nArray[3] = n - 5;
                    nArray2[0] = 5;
                    nArray2[1] = 0;
                    nArray2[2] = n2 - 5;
                    nArray2[3] = n2;
                    graphics.fillPolygon(nArray, nArray2, 4);
                    nArray2[0] = n2 - 5;
                    nArray2[1] = n2;
                    nArray2[2] = 5;
                    nArray2[3] = 0;
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
    }
}

