/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresets;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSetEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ColorPresetEditor
extends JPanel
implements SettingsPanel {
    private ColorPresets presets;
    private Window window;
    private String title = "Color Preset Editor";
    private PresetEditPanel presetEditPanel;

    public ColorPresetEditor(ColorPresets colorPresets) {
        this.presets = colorPresets;
        this.presetEditPanel = new PresetEditPanel();
        this.add(this.presetEditPanel);
    }

    public void showConfig(Frame frame) {
        if (this.window == null) {
            Dialog dialog = new Dialog(frame, this.getTitle(), true);
            dialog.setLayout(new BorderLayout());
            dialog.add(new JScrollPane(this.presetEditPanel));
            dialog.add((Component)new JLabel(this.getTitle()), "North");
            dialog.add((Component)new ButtonPanel(), "South");
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getWindow().dispose();
                }
            });
            dialog.pack();
            this.window = dialog;
        }
        this.window.show();
    }

    public static void main(String[] stringArray) {
        ColorPresets colorPresets = new ColorPresets((ConfigNode)new DummyConfigNode("ColorPresets"));
        ColorPresetEditor colorPresetEditor = new ColorPresetEditor(colorPresets);
        Frame frame = new Frame(colorPresetEditor.getTitle());
        colorPresetEditor.showConfig(frame);
        System.out.println("on exit, presets were\n" + colorPresets.toString());
        System.exit(0);
    }

    public void addToFrame(Frame frame) {
        frame.setLayout(new BorderLayout());
        this.presetEditPanel = new PresetEditPanel();
        frame.add(new JScrollPane(this.presetEditPanel));
        frame.add((Component)new ButtonPanel(), "South");
        this.window = frame;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void synchronizeFrom() {
        this.presetEditPanel.initialize();
        this.presetEditPanel.redoLayout();
    }

    public void synchronizeTo() {
        this.presetEditPanel.saveAll();
    }

    private class PresetEditPanel
    extends JPanel {
        private GridBagConstraints gbc;
        private JRadioButton[] defaultButtons;
        private JTextField[] presetNames;
        private ColorSet[] presetColors;
        private ButtonGroup bob = new ButtonGroup();

        PresetEditPanel() {
            this.initialize();
            this.redoLayout();
        }

        private void initialize() {
            int n = ColorPresetEditor.this.presets.getNumPresets();
            this.defaultButtons = new JRadioButton[n];
            this.presetNames = new JTextField[n];
            this.presetColors = new ColorSet[n];
            for (int i = 0; i < n; ++i) {
                this.initializePreset(i);
                this.bob.add(this.defaultButtons[i]);
            }
            if (n > 0) {
                if (ColorPresetEditor.this.presets.getDefaultIndex() == -1) {
                    this.defaultButtons[0].setSelected(true);
                } else {
                    this.defaultButtons[ColorPresetEditor.this.presets.getDefaultIndex()].setSelected(true);
                }
            }
        }

        private void initializePreset(int n) {
            JRadioButton jRadioButton;
            final int n2 = n;
            ColorSet colorSet = new ColorSet();
            JTextField jTextField = new JTextField();
            jTextField.setText(ColorPresetEditor.this.presets.getPresetNames()[n2]);
            this.presetNames[n2] = jTextField;
            colorSet.copyStateFrom(ColorPresetEditor.this.presets.getColorSet(n2));
            this.presetColors[n2] = colorSet;
            this.defaultButtons[n2] = jRadioButton = new JRadioButton();
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPresetEditor.this.presets.setDefaultIndex(n2);
                }
            });
        }

        public void redoLayout() {
            int n = this.defaultButtons.length - 1;
            this.removeAll();
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.weighty = 100.0;
            this.gbc.gridwidth = 1;
            this.gbc.fill = 2;
            this.gbc.anchor = 11;
            this.gbc.gridy = 0;
            this.gbc.gridx = 0;
            this.gbc.weighty = 100.0;
            this.add((Component)new JLabel("Modify Color Presets", 0), this.gbc);
            this.gbc.weighty = 0.0;
            this.gbc.gridy = 1;
            this.gbc.gridx = 0;
            this.add((Component)new JLabel("Name"), this.gbc);
            this.gbc.gridx = 1;
            this.add((Component)new JLabel("Colors"), this.gbc);
            this.gbc.gridx = 3;
            this.add((Component)new JLabel("Default?"), this.gbc);
            for (int i = 0; i < n; ++i) {
                ++this.gbc.gridy;
                this.addPreset(i);
            }
            ++this.gbc.gridy;
            JButton jButton = new JButton("Add New");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PresetEditPanel.this.createPreset();
                }
            });
            ++this.gbc.gridy;
            this.gbc.gridx = 2;
            this.add((Component)jButton, this.gbc);
            JButton jButton2 = new JButton("Add Standards");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorSet[] colorSetArray = ColorPresets.defaultColorSets;
                    for (int i = 0; i < colorSetArray.length; ++i) {
                        PresetEditPanel.this.addPreset(colorSetArray[i]);
                    }
                }
            });
            ++this.gbc.gridy;
            this.gbc.gridx = 2;
            this.add((Component)jButton2, this.gbc);
            this.revalidate();
            this.repaint();
        }

        private void addPreset(int n) {
            final int n2 = n;
            this.gbc.gridx = 0;
            this.add((Component)this.presetNames[n2], this.gbc);
            this.gbc.gridx = 1;
            this.gbc.weightx = 100.0;
            this.add((Component)new ColorSetEditor(this.presetColors[n2]), this.gbc);
            this.gbc.gridx = 2;
            this.gbc.weightx = 0.0;
            JButton jButton = new JButton("Remove");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PresetEditPanel.this.removePreset(n2);
                }
            });
            this.add((Component)jButton, this.gbc);
            this.gbc.gridx = 3;
            this.add((Component)this.defaultButtons[n2], this.gbc);
        }

        private void saveAll() {
            int n;
            int n2;
            int n3 = this.presetNames.length - 1;
            for (n2 = ColorPresetEditor.this.presets.getNumPresets(); n3 > n2; ++n2) {
                ColorSet colorSet = new ColorSet();
                colorSet.setName("Preset" + n2);
                ColorPresetEditor.this.presets.addColorSet(colorSet);
            }
            while (n2 > n3) {
                ColorPresetEditor.this.presets.removeColorSet(--n2);
            }
            for (n = 0; n < n3; ++n) {
                this.presetColors[n].setName(this.presetNames[n].getText());
            }
            for (n = 0; n < n3; ++n) {
                ColorPresetEditor.this.presets.getColorSet(n).copyStateFrom(this.presetColors[n]);
            }
        }

        private void removePreset(int n) {
            int n2;
            int n3;
            ColorSet[] colorSetArray = new ColorSet[this.presetColors.length - 1];
            JTextField[] jTextFieldArray = new JTextField[this.presetNames.length - 1];
            JRadioButton[] jRadioButtonArray = new JRadioButton[this.defaultButtons.length - 1];
            for (n3 = 0; n3 < colorSetArray.length; ++n3) {
                n2 = n3;
                if (n3 >= n) {
                    ++n2;
                }
                colorSetArray[n3] = this.presetColors[n2];
                jTextFieldArray[n3] = this.presetNames[n2];
                jRadioButtonArray[n3] = this.defaultButtons[n2];
            }
            this.bob.remove(this.defaultButtons[n]);
            n3 = 0;
            for (n2 = 0; n2 < this.defaultButtons.length; ++n2) {
                if (this.defaultButtons[n2] == null || !this.defaultButtons[n2].isSelected()) continue;
                n3 = n2;
            }
            if (n3 > jTextFieldArray.length - 2) {
                jRadioButtonArray[jTextFieldArray.length - 2].setSelected(true);
            } else {
                jRadioButtonArray[n3].setSelected(true);
            }
            this.presetNames = jTextFieldArray;
            this.presetColors = colorSetArray;
            this.defaultButtons = jRadioButtonArray;
            this.redoLayout();
        }

        private void createPreset() {
            ColorSet colorSet = new ColorSet();
            this.addPreset(colorSet);
        }

        private void addPreset(ColorSet colorSet) {
            JRadioButton jRadioButton;
            int n;
            ColorSet[] colorSetArray = new ColorSet[this.presetColors.length + 1];
            JTextField[] jTextFieldArray = new JTextField[this.presetNames.length + 1];
            JRadioButton[] jRadioButtonArray = new JRadioButton[this.defaultButtons.length + 1];
            for (n = 0; n < this.presetColors.length; ++n) {
                colorSetArray[n] = this.presetColors[n];
                jTextFieldArray[n] = this.presetNames[n];
                jRadioButtonArray[n] = this.defaultButtons[n];
            }
            n = jTextFieldArray.length - 2;
            colorSetArray[n + 1] = colorSetArray[n];
            jTextFieldArray[n + 1] = this.presetNames[n];
            jRadioButtonArray[n + 1] = jRadioButtonArray[n];
            jTextFieldArray[n] = new JTextField("Preset" + n);
            colorSetArray[n] = colorSet;
            jRadioButtonArray[n] = jRadioButton = new JRadioButton();
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPresetEditor.this.presets.setDefaultIndex(n);
                }
            });
            this.bob.add(jRadioButton);
            this.presetNames = jTextFieldArray;
            this.presetColors = colorSetArray;
            this.defaultButtons = jRadioButtonArray;
            this.redoLayout();
        }
    }

    private class ButtonPanel
    extends JPanel {
        ButtonPanel() {
            JButton jButton = new JButton("Save");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPresetEditor.this.synchronizeTo();
                    ColorPresetEditor.this.window.dispose();
                }
            });
            this.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorPresetEditor.this.synchronizeFrom();
                    ColorPresetEditor.this.window.dispose();
                }
            });
            this.add(jButton2);
        }
    }
}

