/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ColorIcon;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ColorSetEditor
extends JPanel {
    private static final int UP = 0;
    private static final int ZERO = 1;
    private static final int DOWN = 2;
    private static final int MISSING = 3;
    private ColorSet colorSet;

    public ColorSetEditor(ColorSet colorSet) {
        this.colorSet = colorSet;
        this.add(new ColorPanel(0));
        this.add(new ColorPanel(1));
        this.add(new ColorPanel(2));
        this.add(new ColorPanel(3));
    }

    public static final void main(String[] stringArray) {
        ColorSet colorSet = new ColorSet();
        ColorSetEditor colorSetEditor = new ColorSetEditor(colorSet);
        JFrame jFrame = new JFrame("ColorSetEditor Test");
        jFrame.getContentPane().add(colorSetEditor);
        jFrame.pack();
        jFrame.show();
    }

    class ColorPanel
    extends JPanel {
        ColorIcon colorIcon;
        int type;

        ColorPanel(int n) {
            this.type = n;
            this.redoComps();
        }

        public void redoComps() {
            this.removeAll();
            this.colorIcon = new ColorIcon(10, 10, this.getColor());
            JButton jButton = new JButton(this.getLabel(), (Icon)this.colorIcon);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(ColorSetEditor.this, "Pick Color for " + ColorPanel.this.getLabel(), ColorPanel.this.getColor());
                    if (color != null) {
                        ColorPanel.this.setColor(color);
                    }
                }
            });
            this.add(jButton);
        }

        private void setColor(Color color) {
            switch (this.type) {
                case 0: {
                    ColorSetEditor.this.colorSet.setUp(color);
                    break;
                }
                case 1: {
                    ColorSetEditor.this.colorSet.setZero(color);
                    break;
                }
                case 2: {
                    ColorSetEditor.this.colorSet.setDown(color);
                    break;
                }
                case 3: {
                    ColorSetEditor.this.colorSet.setMissing(color);
                }
            }
            this.colorIcon.setColor(this.getColor());
            this.repaint();
        }

        private String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Positive";
                }
                case 1: {
                    return "Zero";
                }
                case 2: {
                    return "Negative";
                }
                case 3: {
                    return "Missing";
                }
            }
            return null;
        }

        private Color getColor() {
            switch (this.type) {
                case 0: {
                    return ColorSetEditor.this.colorSet.getUp();
                }
                case 1: {
                    return ColorSetEditor.this.colorSet.getZero();
                }
                case 2: {
                    return ColorSetEditor.this.colorSet.getDown();
                }
                case 3: {
                    return ColorSetEditor.this.colorSet.getMissing();
                }
            }
            return null;
        }
    }
}

