/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ContrastSelectable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ContrastSelector
extends JPanel
implements AdjustmentListener {
    private JTextField contrastTextField;
    private JFrame top;
    private JDialog d;
    private JScrollBar scrollbar;
    private double contrast;
    private ContrastSelectable client = null;

    public ContrastSelector(ContrastSelectable contrastSelectable) {
        this.client = contrastSelectable;
        this.contrast = this.client.getContrast();
        this.setupWidgets();
    }

    private void setupWidgets() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Value:", 2);
        jPanel.add(jLabel);
        jLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.contrastTextField = new JTextField(Double.toString(this.contrast), 5);
        this.contrastTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel.add(this.contrastTextField);
        this.contrastTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ContrastSelector.this.signalAll();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ContrastSelector.this.signalAll();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ContrastSelector.this.signalAll();
            }
        });
        this.add(jPanel);
        this.scrollbar = new JScrollBar(0);
        this.scrollbar.setValues((int)(this.contrast * 100.0), 0, 1, 500);
        this.scrollbar.addAdjustmentListener(this);
        this.add(this.scrollbar);
    }

    public void signalAll() {
        try {
            Double d = new Double(this.contrastTextField.getText());
            this.contrast = d;
            this.client.setContrast(this.contrast);
            this.client.notifyObservers();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.contrastTextField.setText("" + (double)this.scrollbar.getValue() / 100.0);
        this.signalAll();
    }

    public void makeTop() {
        this.top = new JFrame(this.getTitle());
        this.top.add(this);
        this.top.addWindowListener(new WindowCloser());
        this.top.pack();
        ((Component)this.top).setVisible(true);
    }

    public void showDialog(JFrame jFrame) {
        this.d = new JDialog((Frame)jFrame, this.getTitle());
        this.d.setLayout(new BorderLayout());
        this.d.add((Component)this, "Center");
        this.top.addWindowListener(new WindowCloser());
        this.d.pack();
        ((Component)this.d).setVisible(true);
    }

    protected String getTitle() {
        return "Contrast Selection";
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            windowEvent.getWindow().dispose();
        }
    }
}

