/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.NatField;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelectable;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class FontSelector
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final String[] fonts = Toolkit.getDefaultToolkit().getFontList();
    private String title;
    private Choice font_choice;
    private Choice style_choice;
    private NatField size_field;
    private Button display_button;
    private Frame top;
    private Dialog d;
    private FontSelectable client;
    String size_prop;
    String face_prop;
    String style_prop;
    public static final String[] styles = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};

    private GridBagConstraints place(GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.anchor = n4;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        return gridBagConstraints;
    }

    private void setupWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Label label = new Label("Font:", 0);
        this.add(label);
        this.font_choice = new Choice();
        for (int i = 0; i < fonts.length; ++i) {
            this.font_choice.addItem(fonts[i]);
        }
        this.font_choice.select(this.client.getFace());
        this.add(this.font_choice);
        Label label2 = new Label("Style:", 0);
        this.add(label2);
        this.style_choice = new Choice();
        for (int i = 0; i < styles.length; ++i) {
            this.style_choice.addItem(styles[i]);
        }
        this.style_choice.select(FontSelector.decode_style(this.client.getStyle()));
        this.add(this.style_choice);
        Label label3 = new Label("Size:", 0);
        this.add(label3);
        this.size_field = new NatField(this.client.getPoints(), 3);
        this.add((Component)this.size_field);
        this.display_button = new Button("Display");
        this.display_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = FontSelector.this.font_choice.getSelectedItem();
                int n = FontSelector.encode_style(FontSelector.this.style_choice.getSelectedItem());
                int n2 = FontSelector.this.size_field.getNat();
                FontSelector.this.client.setFace(string);
                FontSelector.this.client.setStyle(n);
                FontSelector.this.client.setPoints(n2);
            }
        });
        this.add(this.display_button);
        this.place(gridBagLayout, label, 0, 0, 1, 17);
        this.place(gridBagLayout, this.font_choice, 1, 0, 1, 13);
        this.place(gridBagLayout, label2, 0, 1, 1, 17);
        this.place(gridBagLayout, this.style_choice, 1, 1, 1, 13);
        this.place(gridBagLayout, label3, 0, 2, 1, 17);
        this.place(gridBagLayout, (Component)this.size_field, 1, 2, 1, 13);
        this.place(gridBagLayout, this.display_button, 0, 3, 2, 17);
    }

    public static final String decode_style(int n) {
        switch (n) {
            case 0: {
                return styles[0];
            }
            case 2: {
                return styles[1];
            }
            case 1: {
                return styles[2];
            }
        }
        return styles[3];
    }

    public static final int encode_style(String string) {
        return string == styles[0] ? 0 : (string == styles[1] ? 2 : (string == styles[2] ? 1 : 3));
    }

    public FontSelector(FontSelectable fontSelectable, String string) {
        this.title = string;
        this.client = fontSelectable;
        this.setupWidgets();
    }

    public void makeTop() {
        this.top = new Frame(this.getTitle());
        this.top.add(this);
        this.top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        this.top.pack();
        this.top.show();
    }

    public void showDialog(Frame frame) {
        this.d = new Dialog(frame, this.getTitle());
        this.d.add(this);
        this.d.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        this.d.pack();
        this.d.show();
    }

    protected String getTitle() {
        return this.title;
    }
}

