/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.DummyHeaderInfo;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.NatField;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.UrlExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelectable;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelector;
import edu.stanford.genetics.treeview.plugin.dendroview.TextView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontSettingsPanel
extends JPanel
implements SettingsPanel {
    private FontSelectable client;
    public static final String[] styles = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
    private JComboBox font_choice;
    private JComboBox style_choice;
    private NatField size_field;
    private JButton display_button;
    private JLabel exampleField;
    String size_prop;
    String face_prop;
    String style_prop;

    public FontSettingsPanel(FontSelectable fontSelectable) {
        this.client = fontSelectable;
        this.setupWidgets();
        this.updateExample();
    }

    public static void main(String[] stringArray) {
        DummyHeaderInfo dummyHeaderInfo = new DummyHeaderInfo();
        UrlExtractor urlExtractor = new UrlExtractor((HeaderInfo)dummyHeaderInfo);
        TextView textView = new TextView((HeaderInfo)dummyHeaderInfo, urlExtractor);
        textView.setPoints(10);
        FontSettingsPanel fontSettingsPanel = new FontSettingsPanel(textView);
        JFrame jFrame = new JFrame("Font Settings Test");
        jFrame.add(fontSettingsPanel);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        jFrame.show();
    }

    public void synchronizeFrom() {
        this.setupWidgets();
    }

    public void synchronizeTo() {
    }

    public static final String decode_style(int n) {
        switch (n) {
            case 0: {
                return styles[0];
            }
            case 2: {
                return styles[1];
            }
            case 1: {
                return styles[2];
            }
        }
        return styles[3];
    }

    public static final int encode_style(String string) {
        return string == styles[0] ? 0 : (string == styles[1] ? 2 : (string == styles[2] ? 1 : 3));
    }

    public void showDialog(Frame frame, String string) {
        JDialog jDialog = new JDialog(frame, string);
        jDialog.setLayout(new BorderLayout());
        jDialog.add((Component)this, "Center");
        jDialog.add((Component)new ButtonPanel(jDialog), "South");
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        jDialog.pack();
        ((Component)jDialog).setVisible(true);
    }

    private void setupFontChoice() {
        this.font_choice = new JComboBox<String>(FontSelector.fonts);
        this.font_choice.setSelectedItem(this.client.getFace());
    }

    private void setupStyleChoice() {
        this.style_choice = new JComboBox<String>(styles);
        this.style_choice.setSelectedItem(FontSettingsPanel.decode_style(this.client.getStyle()));
    }

    private void synchronizeClient() {
        String string = (String)this.font_choice.getSelectedItem();
        int n = FontSettingsPanel.encode_style((String)this.style_choice.getSelectedItem());
        int n2 = this.size_field.getNat();
        this.client.setFace(string);
        this.client.setStyle(n);
        this.client.setPoints(n2);
    }

    private void setupWidgets() {
        this.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        this.setupFontChoice();
        this.add((Component)this.font_choice, gridBagConstraints);
        this.setupStyleChoice();
        gridBagConstraints.gridx = 1;
        this.add((Component)this.style_choice, gridBagConstraints);
        this.size_field = new NatField(this.client.getPoints(), 3);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.size_field, gridBagConstraints);
        this.display_button = new JButton("Set");
        this.display_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSettingsPanel.this.updateExample();
                FontSettingsPanel.this.synchronizeClient();
            }
        });
        gridBagConstraints.gridx = 3;
        this.add((Component)this.display_button, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.exampleField = new JLabel("Font Example Text", 0);
        this.add((Component)this.exampleField, gridBagConstraints);
    }

    private void updateExample() {
        String string = (String)this.font_choice.getSelectedItem();
        int n = FontSettingsPanel.encode_style((String)this.style_choice.getSelectedItem());
        int n2 = this.size_field.getNat();
        this.exampleField.setFont(new Font(string, n, n2));
        this.exampleField.revalidate();
        this.exampleField.repaint();
    }

    private class ButtonPanel
    extends JPanel {
        ButtonPanel(Window window) {
            final Window window2 = window;
            JButton jButton = new JButton("Close");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    window2.hide();
                }
            });
            this.add(jButton);
        }
    }
}

