/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.ModelViewProduced;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

class GlobalView
extends ModelViewProduced
implements MouseMotionListener,
MouseListener,
KeyListener {
    private static final String[] hints = new String[]{"use arrow keys to move selection", "click and drag to select genes", "- hold shift to select arrays too"};
    protected boolean hasDrawn = false;
    private ArrayDrawer drawer;
    private Point startPoint = new Point();
    private Point endPoint = new Point();
    private Rectangle dragRect = new Rectangle();
    private Rectangle selectionRect = null;
    private Rectangle zoomRect = null;
    protected TreeSelectionI geneSelection;
    protected TreeSelectionI arraySelection;
    protected MapContainer xmap;
    protected MapContainer ymap;
    protected MapContainer zoomXmap;
    protected MapContainer zoomYmap;

    public GlobalView() {
        ((ModelView)this).panel = this;
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
        ((Component)((Object)this)).addKeyListener(this);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.xmap.getRequiredPixels(), this.ymap.getRequiredPixels());
        return dimension;
    }

    public String[] getStatus() {
        String[] stringArray = new String[4];
        if (this.geneSelection == null || this.arraySelection == null) {
            stringArray[0] = "ERROR: GlobalView improperly configured";
            stringArray[1] = " geneSelection is null";
            stringArray[2] = " thus, gene selection will not work.";
            stringArray[3] = "";
        } else {
            int n = this.arraySelection.getMinIndex();
            int n2 = this.arraySelection.getMaxIndex();
            int n3 = this.geneSelection.getMinIndex();
            int n4 = this.geneSelection.getMaxIndex();
            stringArray[0] = n4 - n3 + 1 + " genes selected";
            stringArray[1] = n2 - n + 1 + " arrays selected";
            stringArray[2] = "Genes from " + n3 + " to " + n4;
            stringArray[3] = "Arrays from " + n + " to " + n2;
        }
        return stringArray;
    }

    public String[] getHints() {
        return hints;
    }

    public void setGeneSelection(TreeSelectionI treeSelectionI) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver((Observer)((Object)this));
        }
        this.geneSelection = treeSelectionI;
        this.geneSelection.addObserver((Observer)((Object)this));
    }

    public void setArraySelection(TreeSelectionI treeSelectionI) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver((Observer)((Object)this));
        }
        this.arraySelection = treeSelectionI;
        this.arraySelection.addObserver((Observer)((Object)this));
    }

    public void setArrayDrawer(ArrayDrawer arrayDrawer) {
        if (this.drawer != null) {
            this.drawer.deleteObserver((Observer)((Object)this));
        }
        this.drawer = arrayDrawer;
        this.drawer.addObserver((Observer)((Object)this));
    }

    public ArrayDrawer getArrayDrawer() {
        return this.drawer;
    }

    public void setXMap(MapContainer mapContainer) {
        if (this.xmap != null) {
            this.xmap.deleteObserver((Observer)((Object)this));
        }
        this.xmap = mapContainer;
        this.xmap.addObserver((Observer)((Object)this));
    }

    public void setYMap(MapContainer mapContainer) {
        if (this.ymap != null) {
            this.ymap.deleteObserver((Observer)((Object)this));
        }
        this.ymap = mapContainer;
        this.ymap.addObserver((Observer)((Object)this));
    }

    public MapContainer getXMap() {
        return this.xmap;
    }

    public MapContainer getYMap() {
        return this.ymap;
    }

    public void setZoomXMap(MapContainer mapContainer) {
        if (this.zoomXmap != null) {
            this.zoomXmap.deleteObserver((Observer)((Object)this));
        }
        this.zoomXmap = mapContainer;
        this.zoomXmap.addObserver((Observer)((Object)this));
    }

    public void setZoomYMap(MapContainer mapContainer) {
        if (this.zoomYmap != null) {
            this.zoomYmap.deleteObserver((Observer)((Object)this));
        }
        this.zoomYmap = mapContainer;
        this.zoomYmap.addObserver((Observer)((Object)this));
    }

    public String viewName() {
        return "GlobalView";
    }

    protected void updateBuffer(Graphics graphics) {
        if (((ModelView)this).offscreenChanged) {
            this.xmap.setAvailablePixels(((ModelView)this).offscreenSize.width);
            this.ymap.setAvailablePixels(((ModelView)this).offscreenSize.height);
            if (!this.hasDrawn) {
                this.xmap.recalculateScale();
                this.ymap.recalculateScale();
                this.hasDrawn = true;
            }
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!((ModelView)this).offscreenValid) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, ((ModelView)this).offscreenSize.width, ((ModelView)this).offscreenSize.height);
            graphics.setColor(Color.black);
            Rectangle rectangle = new Rectangle(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            Rectangle rectangle2 = new Rectangle(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(rectangle.width) - this.xmap.getIndex(0), this.ymap.getIndex(rectangle.height) - this.ymap.getIndex(0));
            if (rectangle2.x >= 0 && rectangle2.y >= 0) {
                this.drawer.paint(graphics, rectangle2, rectangle, null);
            }
        }
    }

    protected void updatePixels() {
        if (((ModelView)this).offscreenChanged) {
            ((ModelView)this).offscreenValid = false;
            this.xmap.setAvailablePixels(((ModelView)this).offscreenSize.width);
            this.ymap.setAvailablePixels(((ModelView)this).offscreenSize.height);
            if (!this.hasDrawn) {
                this.xmap.recalculateScale();
                this.ymap.recalculateScale();
                this.hasDrawn = true;
            }
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!((ModelView)this).offscreenValid) {
            Rectangle rectangle = new Rectangle(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            Rectangle rectangle2 = new Rectangle(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(rectangle.width) - this.xmap.getIndex(0), this.ymap.getIndex(rectangle.height) - this.ymap.getIndex(0));
            if (rectangle2.x >= 0 && rectangle2.y >= 0) {
                this.drawer.paint(this.offscreenPixels, rectangle2, rectangle, this.offscreenScanSize);
            }
            this.offscreenSource.newPixels();
        }
    }

    public synchronized void paintComposite(Graphics graphics) {
        if (this.selectionRect != null) {
            if (this.zoomRect != null) {
                graphics.setColor(Color.cyan);
                graphics.drawRect(this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height);
            }
            graphics.setColor(Color.yellow);
            graphics.drawRect(this.selectionRect.x, this.selectionRect.y, this.selectionRect.width, this.selectionRect.height);
        }
    }

    private void repaintRect(Graphics graphics, Rectangle rectangle) {
        int n;
        if (rectangle == null) {
            return;
        }
        for (n = 0; n <= rectangle.width; ++n) {
            this.drawer.paintPixel(graphics, this.xmap, this.ymap, n + rectangle.x, rectangle.y, null);
            this.drawer.paintPixel(graphics, this.xmap, this.ymap, n + rectangle.x, rectangle.y + rectangle.height, null);
        }
        for (n = 1; n < rectangle.height; ++n) {
            this.drawer.paintPixel(graphics, this.xmap, this.ymap, rectangle.x, n + rectangle.y, null);
            this.drawer.paintPixel(graphics, this.xmap, this.ymap, rectangle.x + rectangle.width, n + rectangle.y, null);
        }
    }

    protected void recalculateOverlay() {
        if (this.geneSelection == null || this.arraySelection == null) {
            return;
        }
        int n = this.xmap.getPixel(this.arraySelection.getMinIndex());
        int n2 = this.xmap.getPixel(this.arraySelection.getMaxIndex() + 1) - 1;
        int n3 = this.ymap.getPixel(this.geneSelection.getMinIndex());
        int n4 = this.ymap.getPixel(this.geneSelection.getMaxIndex() + 1) - 1;
        if (n4 < n3) {
            n4 = n3;
        }
        if (this.selectionRect == null) {
            this.selectionRect = new Rectangle(n, n3, n2 - n, n4 - n3);
        } else {
            this.selectionRect.setBounds(n, n3, n2 - n, n4 - n3);
        }
    }

    protected void recalculateZoom() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.selectionRect == null) {
            return;
        }
        try {
            n4 = this.xmap.getPixel(this.zoomXmap.getIndex(0));
            n3 = this.xmap.getPixel(this.zoomXmap.getIndex(this.zoomXmap.getUsedPixels())) - 1;
            n2 = this.ymap.getPixel(this.zoomYmap.getIndex(0));
            n = this.ymap.getPixel(this.zoomYmap.getIndex(this.zoomYmap.getUsedPixels())) - 1;
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
        if (this.zoomRect == null) {
            this.zoomRect = new Rectangle(n4, n2, n3 - n4, n - n2);
        } else {
            this.zoomRect.setBounds(n4, n2, n3 - n4, n - n2);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.geneSelection) {
            if (this.arraySelection.getNSelectedIndexes() == 0 && this.geneSelection.getNSelectedIndexes() != 0) {
                this.arraySelection.selectAllIndexes();
                this.arraySelection.notifyObservers();
                return;
            }
            this.recalculateOverlay();
        } else if (observable == this.arraySelection) {
            if (this.geneSelection.getNSelectedIndexes() == 0 && this.arraySelection.getNSelectedIndexes() != 0) {
                this.geneSelection.selectAllIndexes();
                this.geneSelection.notifyObservers();
                return;
            }
            this.recalculateOverlay();
        } else if (observable == this.xmap || observable == this.ymap) {
            this.recalculateZoom();
            this.recalculateOverlay();
            ((ModelView)this).offscreenValid = false;
        } else if (observable == this.zoomYmap || observable == this.zoomXmap) {
            this.recalculateZoom();
            if (((ModelView)this).status != null && ((ModelView)this).hasMouse) {
                ((ModelView)this).status.setMessages(this.getStatus());
            }
        } else if (observable == this.drawer) {
            ((ModelView)this).offscreenValid = false;
        } else {
            LogBuffer.println((String)("GlobalView got weird update : " + observable));
        }
        ((Component)((Object)this)).repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        this.startPoint.setLocation(this.xmap.getIndex(mouseEvent.getX()), this.ymap.getIndex(mouseEvent.getY()));
        this.endPoint.setLocation(this.startPoint.x, this.startPoint.y);
        this.dragRect.setLocation(this.startPoint.x, this.startPoint.y);
        this.dragRect.setSize(this.endPoint.x - this.dragRect.x, this.endPoint.y - this.dragRect.y);
        this.drawBand(this.dragRect);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        this.mouseDragged(mouseEvent);
        this.drawBand(this.dragRect);
        if (mouseEvent.isShiftDown()) {
            this.selectRectangle(this.startPoint, this.endPoint);
        } else {
            Point point = new Point(this.xmap.getMinIndex(), this.startPoint.y);
            Point point2 = new Point(this.xmap.getMaxIndex(), this.endPoint.y);
            this.selectRectangle(point, point2);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.drawBand(this.dragRect);
        this.endPoint.setLocation(this.xmap.getIndex(mouseEvent.getX()), this.ymap.getIndex(mouseEvent.getY()));
        if (mouseEvent.isShiftDown()) {
            this.dragRect.setLocation(this.startPoint.x, this.startPoint.y);
            this.dragRect.setSize(0, 0);
            this.dragRect.add(this.endPoint.x, this.endPoint.y);
        } else {
            this.dragRect.setLocation(this.xmap.getMinIndex(), this.startPoint.y);
            this.dragRect.setSize(0, 0);
            this.dragRect.add(this.xmap.getMaxIndex(), this.endPoint.y);
        }
        this.drawBand(this.dragRect);
    }

    private void drawBand(Rectangle rectangle) {
        Graphics graphics = ((JComponent)((Object)this)).getGraphics();
        graphics.setXORMode(((Component)((Object)this)).getBackground());
        int n = this.xmap.getPixel(rectangle.x);
        int n2 = this.ymap.getPixel(rectangle.y);
        int n3 = this.xmap.getPixel(rectangle.x + rectangle.width + 1) - n;
        int n4 = this.ymap.getPixel(rectangle.y + rectangle.height + 1) - n2;
        graphics.drawRect(n, n2, n3, n4);
        graphics.setPaintMode();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        this.startPoint.setLocation(this.arraySelection.getMinIndex(), this.geneSelection.getMinIndex());
        this.endPoint.setLocation(this.arraySelection.getMaxIndex(), this.geneSelection.getMaxIndex());
        if (keyEvent.isControlDown()) {
            switch (n) {
                case 38: {
                    this.startPoint.translate(0, -1);
                    this.endPoint.translate(0, 1);
                    break;
                }
                case 40: {
                    this.startPoint.translate(0, 1);
                    this.endPoint.translate(0, -1);
                    break;
                }
                case 37: {
                    this.startPoint.translate(1, 0);
                    this.endPoint.translate(-1, 0);
                    break;
                }
                case 39: {
                    this.startPoint.translate(-1, 0);
                    this.endPoint.translate(1, 0);
                }
            }
        } else {
            switch (n) {
                case 38: {
                    this.startPoint.translate(0, -1);
                    this.endPoint.translate(0, -1);
                    break;
                }
                case 40: {
                    this.startPoint.translate(0, 1);
                    this.endPoint.translate(0, 1);
                    break;
                }
                case 37: {
                    this.startPoint.translate(-1, 0);
                    this.endPoint.translate(-1, 0);
                    break;
                }
                case 39: {
                    this.startPoint.translate(1, 0);
                    this.endPoint.translate(1, 0);
                    break;
                }
            }
        }
        int n2 = 0;
        int n3 = 0;
        if (this.startPoint.x < this.xmap.getMinIndex()) {
            n2 += this.startPoint.x - this.xmap.getMinIndex();
        }
        if (this.startPoint.y < this.ymap.getMinIndex()) {
            n3 += this.startPoint.y - this.ymap.getMinIndex();
        }
        if (this.endPoint.x > this.xmap.getMaxIndex()) {
            n2 += this.endPoint.x - this.xmap.getMaxIndex();
        }
        if (this.startPoint.y < this.ymap.getMinIndex()) {
            n3 += this.startPoint.y - this.ymap.getMinIndex();
        }
        this.startPoint.x -= n2;
        this.endPoint.x -= n2;
        this.startPoint.y -= n3;
        this.endPoint.y -= n3;
        this.selectRectangle(this.startPoint, this.endPoint);
    }

    private void selectRectangle(Point point, Point point2) {
        int n;
        if (point2.x < point.x) {
            n = point2.x;
            point2.x = point.x;
            point.x = n;
        }
        if (point2.y < point.y) {
            n = point2.y;
            point2.y = point.y;
            point.y = n;
        }
        this.geneSelection.setSelectedNode(null);
        this.geneSelection.deselectAllIndexes();
        for (n = point.y; n <= point2.y; ++n) {
            this.geneSelection.setIndex(n, true);
        }
        this.arraySelection.setSelectedNode(null);
        this.arraySelection.deselectAllIndexes();
        for (n = point.x; n <= point2.x; ++n) {
            this.arraySelection.setIndex(n, true);
        }
        this.geneSelection.notifyObservers();
        this.arraySelection.notifyObservers();
    }
}

