/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.DataMatrix;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.MessagePanel;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.model.KnnModel;
import edu.stanford.genetics.treeview.plugin.dendroview.ATRView;
import edu.stanford.genetics.treeview.plugin.dendroview.ATRZoomView;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayNameView;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresets;
import edu.stanford.genetics.treeview.plugin.dendroview.DendroView;
import edu.stanford.genetics.treeview.plugin.dendroview.DendrogramFactory;
import edu.stanford.genetics.treeview.plugin.dendroview.GTRView;
import edu.stanford.genetics.treeview.plugin.dendroview.GlobalView;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.KnnArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.TextViewManager;
import edu.stanford.genetics.treeview.plugin.dendroview.ZoomView;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollBar;

public class KnnDendroView
extends DendroView
implements ConfigNodePersistent,
MainPanel,
Observer {
    public KnnDendroView(KnnModel knnModel, ViewFrame viewFrame) {
        super((DataModel)knnModel, viewFrame);
    }

    public KnnDendroView(DataModel dataModel, ConfigNode configNode, ViewFrame viewFrame) {
        super(dataModel, configNode, viewFrame, "KnnDendrogram");
    }

    protected void setupViews() {
        DataModel dataModel = this.getDataModel();
        this.hintpanel = new MessagePanel("Usage Hints");
        this.statuspanel = new MessagePanel("View Status");
        ColorPresets colorPresets = DendrogramFactory.getColorPresets();
        ColorExtractor colorExtractor = new ColorExtractor();
        colorExtractor.setDefaultColorSet(colorPresets.getDefaultColorSet());
        colorExtractor.setMissing(-1.0E7, -2.0E7);
        KnnArrayDrawer knnArrayDrawer = new KnnArrayDrawer();
        knnArrayDrawer.setColorExtractor(colorExtractor);
        this.arrayDrawer = knnArrayDrawer;
        ((Observable)this.getDataModel()).addObserver(this.arrayDrawer);
        this.globalview = new GlobalView();
        this.globalXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.globalYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXscrollbar = new JScrollBar(0, 0, 1, 0, 1);
        this.zoomYscrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.zoomXmap = new MapContainer();
        this.zoomXmap.setDefaultScale(12.0);
        this.zoomXmap.setScrollbar(this.zoomXscrollbar);
        this.zoomYmap = new MapContainer();
        this.zoomYmap.setDefaultScale(12.0);
        this.zoomYmap.setScrollbar(this.zoomYscrollbar);
        this.globalXmap = new MapContainer();
        this.globalXmap.setDefaultScale(2.0);
        this.globalXmap.setScrollbar(this.globalXscrollbar);
        this.globalYmap = new MapContainer();
        this.globalYmap.setDefaultScale(2.0);
        this.globalYmap.setScrollbar(this.globalYscrollbar);
        this.globalview.setXMap(this.globalXmap);
        this.globalview.setYMap(this.globalYmap);
        this.globalview.setZoomYMap(this.getZoomYmap());
        this.globalview.setZoomXMap(this.getZoomXmap());
        this.arraynameview = new ArrayNameView(this.getDataModel().getArrayHeaderInfo());
        this.leftTreeDrawer = new LeftTreeDrawer();
        this.gtrview = new GTRView();
        this.gtrview.setMap(this.globalYmap);
        this.gtrview.setLeftTreeDrawer(this.leftTreeDrawer);
        this.invertedTreeDrawer = new InvertedTreeDrawer();
        this.atrview = new ATRView();
        this.atrview.setMap(this.globalXmap);
        this.atrview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.atrzview = new ATRZoomView();
        this.atrzview.setZoomMap(this.getZoomXmap());
        this.atrzview.setInvertedTreeDrawer(this.invertedTreeDrawer);
        this.zoomview = new ZoomView();
        this.zoomview.setYMap(this.getZoomYmap());
        this.zoomview.setXMap(this.getZoomXmap());
        this.zoomview.setArrayDrawer(this.arrayDrawer);
        this.globalview.setArrayDrawer(this.arrayDrawer);
        this.arraynameview.setMapping(this.getZoomXmap());
        this.arraynameview.setUrlExtractor(this.viewFrame.getArrayUrlExtractor());
        this.textview = new TextViewManager(this.getDataModel().getGeneHeaderInfo(), this.viewFrame.getUrlExtractor());
        this.textview.setMap(this.getZoomYmap());
        this.doDoubleLayout();
        this.settingsFrame = null;
        this.settingsPanel = null;
        colorExtractor.bindConfig(this.getFirst("ColorExtractor"));
        knnArrayDrawer.setDataMatrix(dataModel.getDataMatrix());
        knnArrayDrawer.bindConfig(this.getFirst("ArrayDrawer"));
        this.bindTrees();
        this.globalXmap.bindConfig(this.getFirst("GlobalXMap"));
        this.globalYmap.bindConfig(this.getFirst("GlobalYMap"));
        this.getZoomXmap().bindConfig(this.getFirst("ZoomXMap"));
        this.getZoomYmap().bindConfig(this.getFirst("ZoomYMap"));
        this.textview.bindConfig(this.getFirst("TextViewParent"));
        this.arraynameview.bindConfig(this.getFirst("ArrayNameView"));
        DataMatrix dataMatrix = this.getDataModel().getDataMatrix();
        this.globalXmap.setIndexRange(0, dataMatrix.getNumCol() - 1);
        this.globalYmap.setIndexRange(0, dataMatrix.getNumRow() - 1);
        this.getZoomXmap().setIndexRange(-1, -1);
        this.getZoomYmap().setIndexRange(-1, -1);
        this.globalXmap.notifyObservers();
        this.globalYmap.notifyObservers();
        this.getZoomXmap().notifyObservers();
        this.getZoomYmap().notifyObservers();
    }
}

