/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.plugin.dendroview.FillMap;
import edu.stanford.genetics.treeview.plugin.dendroview.FixedMap;
import edu.stanford.genetics.treeview.plugin.dendroview.IntegerMap;
import edu.stanford.genetics.treeview.plugin.dendroview.NullMap;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollBar;

public class MapContainer
extends Observable
implements Observer,
AdjustmentListener,
ConfigNodePersistent {
    private String default_map = "Fixed";
    private double default_scale = 10.0;
    private IntegerMap current = null;
    private FixedMap fixedMap = new FixedMap();
    private FillMap fillMap = new FillMap();
    private NullMap nullMap = new NullMap();
    private JScrollBar scrollbar = null;
    private TreeDrawerNode selected = null;
    private ConfigNode root = null;

    public MapContainer() {
        this.current = this.nullMap;
    }

    public MapContainer(String string) {
        this();
        this.setMap(string);
    }

    private ConfigNode fetchOrCreateNode(String string) {
        ConfigNode configNode = this.root.fetchFirst(string);
        if (configNode == null) {
            configNode = this.root.create(string);
        }
        return configNode;
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.fixedMap.bindConfig(this.fetchOrCreateNode("FixedMap"));
        this.fillMap.bindConfig(this.fetchOrCreateNode("FillMap"));
        this.nullMap.bindConfig(this.fetchOrCreateNode("NullMap"));
        this.setMap(this.root.getAttribute("current", this.default_map));
    }

    public void setDefaultScale(double d) {
        this.default_scale = d;
        this.fixedMap.setDefaultScale(d);
    }

    public void recalculateScale() {
        if (this.root.fetchFirst("FixedMap").hasAttribute("scale") && this.getScale() < (double)this.getAvailablePixels()) {
            return;
        }
        int n = this.getMaxIndex() - this.getMinIndex() + 1;
        double d = this.getAvailablePixels() / n;
        if (d > this.default_scale) {
            this.setScale(d);
        } else {
            this.setScale(this.default_scale);
        }
    }

    public void setScrollbar(JScrollBar jScrollBar) {
        if (this.scrollbar != null) {
            this.scrollbar.removeAdjustmentListener(this);
        }
        this.scrollbar = jScrollBar;
        if (this.scrollbar != null) {
            this.scrollbar.addAdjustmentListener(this);
            this.setupScrollbar();
        }
    }

    public IntegerMap setMap(String string) {
        if (this.current.type().equals(string)) {
            return this.current;
        }
        IntegerMap integerMap = null;
        if (this.nullMap.type().equals(string)) {
            integerMap = this.nullMap;
        }
        if (this.fillMap.type().equals(string)) {
            integerMap = this.fillMap;
        }
        if (this.fixedMap.type().equals(string)) {
            integerMap = this.fixedMap;
        }
        if (integerMap == null) {
            LogBuffer.println((String)("Couldn't find map matching " + string + " in MapContainer.java"));
            LogBuffer.println((String)"Choices include");
            LogBuffer.println((String)this.nullMap.type());
            LogBuffer.println((String)this.fixedMap.type());
            LogBuffer.println((String)this.fillMap.type());
            integerMap = this.fixedMap;
        }
        this.switchMap(integerMap);
        return this.current;
    }

    public void scrollToIndex(int n) {
        int n2 = this.scrollbar.getValue();
        this.scrollbar.setValue(n - this.scrollbar.getVisibleAmount() / 2);
        if (n2 != this.scrollbar.getValue()) {
            this.setChanged();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setChanged();
        this.notifyObservers(this.scrollbar);
    }

    private void setupScrollbar() {
        if (this.scrollbar != null) {
            int n;
            int n2;
            int n3 = this.scrollbar.getValue();
            if (n3 + (n2 = this.current.getViewableIndexes()) > (n = this.current.getMaxIndex() - this.current.getMinIndex() + 1)) {
                n3 = n - n2;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            this.scrollbar.setValues(n3, n2, 0, n);
            this.scrollbar.setBlockIncrement(this.current.getViewableIndexes());
        }
    }

    public void update(Observable observable, Object object) {
        System.out.println("MapContainer Got an update from unknown " + observable);
        this.notifyObservers(object);
    }

    public void underlyingChanged() {
        this.setupScrollbar();
        this.setChanged();
    }

    public boolean contains(int n) {
        return this.current.contains(n);
    }

    public double getScale() {
        return this.current.getScale();
    }

    public int getPixel(double d) {
        int n = 0;
        if (this.scrollbar != null) {
            n = this.scrollbar.getValue();
        }
        return this.current.getPixel(d - (double)n);
    }

    public int getPixel(int n) {
        int n2 = 0;
        if (this.scrollbar != null) {
            n2 = this.scrollbar.getValue();
        }
        return this.current.getPixel(n - n2);
    }

    public int getIndex(int n) {
        int n2 = 0;
        if (this.current != null) {
            n2 = this.current.getIndex(n);
        }
        if (this.scrollbar != null) {
            n2 += this.scrollbar.getValue();
        }
        return n2;
    }

    public boolean isVisible(int n) {
        int n2 = this.getIndex(0);
        int n3 = this.getIndex(this.getAvailablePixels());
        if (n < n2) {
            return false;
        }
        return n <= n3;
    }

    public int getRequiredPixels() {
        return this.current.getRequiredPixels();
    }

    public int getUsedPixels() {
        return this.current.getUsedPixels();
    }

    public void setAvailablePixels(int n) {
        int n2 = this.current.getUsedPixels();
        this.current.setAvailablePixels(n);
        this.setupScrollbar();
        if (n2 != this.current.getUsedPixels()) {
            this.setChanged();
        }
    }

    public void setIndexRange(int n, int n2) {
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (this.current.getMinIndex() != n || this.current.getMaxIndex() != n2) {
            this.current.setIndexRange(n, n2);
            this.setupScrollbar();
            this.setChanged();
        }
    }

    public void setScale(double d) {
        if (this.fixedMap.getScale() != d) {
            this.fixedMap.setScale(d);
            this.setupScrollbar();
            this.setChanged();
        }
    }

    public int getMiddlePixel(int n) {
        return (this.getPixel(n) + this.getPixel(n + 1)) / 2;
    }

    public int getMaxIndex() {
        return this.current.getMaxIndex();
    }

    public int getMinIndex() {
        return this.current.getMinIndex();
    }

    public TreeDrawerNode getSelectedNode() {
        return this.selected;
    }

    public void setSelectedNode(TreeDrawerNode treeDrawerNode) {
        if (this.selected != treeDrawerNode) {
            this.selected = treeDrawerNode;
            this.setChanged();
        }
    }

    public IntegerMap getCurrent() {
        return this.current;
    }

    public int getAvailablePixels() {
        return this.current.getAvailablePixels();
    }

    private void switchMap(IntegerMap integerMap) {
        if (this.current != integerMap) {
            if (this.root != null) {
                this.root.setAttribute("current", integerMap.type(), this.default_map);
            }
            integerMap.setAvailablePixels(this.current.getAvailablePixels());
            integerMap.setIndexRange(this.current.getMinIndex(), this.current.getMaxIndex());
            this.current = integerMap;
            this.setupScrollbar();
            this.setChanged();
        }
    }
}

