/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.plugin.dendroview.DendroView;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class SummaryViewWizard
extends JPanel {
    private DendroView dendroView;
    private GeneListPanel geneListPanel;
    private JRadioButton selectionButton;
    private JRadioButton listButton;

    public SummaryViewWizard(DendroView dendroView) {
        this.dendroView = dendroView;
        this.setLayout(new BoxLayout(this, 1));
        this.geneListPanel = new GeneListPanel();
        this.selectionButton = new JRadioButton();
        this.selectionButton.setSelected(true);
        this.listButton = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.selectionButton);
        buttonGroup.add(this.listButton);
        JPanel jPanel = new JPanel();
        jPanel.add(this.selectionButton);
        jPanel.add(new JLabel("Selected Genes"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.listButton);
        jPanel2.add(this.geneListPanel);
        this.add(jPanel);
        this.add(jPanel2);
    }

    public int[] getIndexes() {
        if (this.listButton.isSelected()) {
            return this.geneListPanel.getIndexes();
        }
        return this.dendroView.getGeneSelection().getSelectedIndexes();
    }

    class GeneListPanel
    extends JPanel {
        JTextArea textArea = new JTextArea("Paste one ID per row", 10, 50);

        public GeneListPanel() {
            this.textArea.append("\nNote: use Ctrl-V on mac (Java is cross-platform!?)");
            this.textArea.setEditable(true);
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    SummaryViewWizard.this.listButton.setSelected(true);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    SummaryViewWizard.this.listButton.setSelected(true);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SummaryViewWizard.this.listButton.setSelected(true);
                }
            });
            this.add(new JScrollPane(this.textArea));
        }

        public int[] getIndexes() {
            LineReader lineReader = new LineReader();
            String string = lineReader.readLine();
            int n = 0;
            while (string != null) {
                if (string.length() > 0) {
                    ++n;
                }
                string = lineReader.readLine();
            }
            String[] stringArray = new String[n];
            lineReader = new LineReader();
            string = lineReader.readLine();
            n = 0;
            while (string != null) {
                if (string.length() > 0) {
                    stringArray[n++] = string;
                }
                string = lineReader.readLine();
            }
            SummaryViewWizard.this.dendroView.getViewFrame().getGeneFinder().findGenesById(stringArray);
            SummaryViewWizard.this.dendroView.getViewFrame().getGeneFinder().seekAll();
            return SummaryViewWizard.this.dendroView.getGeneSelection().getSelectedIndexes();
        }

        class LineReader {
            char[] lineTerminator = System.getProperty("line.separator").toCharArray();
            int documentPosition = 0;
            Segment seg = new Segment();

            LineReader() {
            }

            public String readLine() {
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[this.lineTerminator.length];
                int n = 0;
                Document document = GeneListPanel.this.textArea.getDocument();
                try {
                    document.getText(this.documentPosition++, 1, this.seg);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                char c = this.seg.first();
                boolean bl = false;
                do {
                    if (c == this.lineTerminator[n]) {
                        cArray[n] = c;
                        ++n;
                    } else if (n + 1 < this.lineTerminator.length && c == this.lineTerminator[n + 1]) {
                        n += 2;
                    } else {
                        if (n > 0) {
                            stringBuffer.append(cArray, 0, n);
                            n = 0;
                        }
                        stringBuffer.append(c);
                    }
                    bl = n >= this.lineTerminator.length;
                    try {
                        document.getText(this.documentPosition++, 1, this.seg);
                    }
                    catch (BadLocationException badLocationException) {
                        bl = true;
                    }
                    if (bl) continue;
                    c = this.seg.first();
                } while (!bl);
                String string = new String(stringBuffer);
                return string.trim();
            }
        }
    }
}

