/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LinearTransformation;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.plugin.dendroview.DendroException;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;

abstract class TreeDrawer
extends Observable
implements Observer {
    private HeaderInfo nodeInfo = null;
    private double corrMin;
    private double corrMax;
    public static final int CORRELATION = 0;
    public static final int TIME = 1;
    private TreeDrawerNode[] leafList;
    private TreeDrawerNode rootNode;
    private Hashtable id2node;

    public TreeDrawer() {
        this.setDefaults();
    }

    public void update(Observable observable, Object object) {
        if (observable == this.nodeInfo) {
            this.setChanged();
            this.notifyObservers();
        } else {
            LogBuffer.println((String)("TreeDrawer got update from unexpected observable " + observable));
        }
    }

    public TreeDrawerNode getRootNode() {
        return this.rootNode;
    }

    public double getCorrMin() {
        return this.corrMin;
    }

    public void setCorrMin(double d) {
        this.corrMin = d;
    }

    public double getCorrMax() {
        return this.corrMax;
    }

    public void setCorrMax(double d) {
        this.corrMax = d;
    }

    public TreeDrawerNode getLeaf(int n) {
        if (this.leafList != null) {
            try {
                return this.leafList[n];
            }
            catch (Exception exception) {
                System.out.println("Got exception " + exception);
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void setData(HeaderInfo headerInfo, HeaderInfo headerInfo2) throws DendroException {
        if (headerInfo == null) {
            this.setDefaults();
            return;
        }
        if (this.nodeInfo != null) {
            this.nodeInfo.deleteObserver((Observer)this);
        }
        this.nodeInfo = headerInfo;
        headerInfo.addObserver((Observer)this);
        this.leafList = new TreeDrawerNode[headerInfo2.getNumHeaders()];
        this.id2node = new Hashtable(headerInfo.getNumHeaders() * 4 / 3 / 2, 0.75f);
        int n = headerInfo.getIndex("NODEID");
        if (n == -1) {
            throw new DendroException("Could not find header NODEID in tree header info");
        }
        for (int i = 0; i < headerInfo.getNumHeaders(); ++i) {
            int n2;
            String string = headerInfo.getHeader(i, n);
            String string2 = headerInfo.getHeader(i, "LEFT");
            String string3 = headerInfo.getHeader(i, "RIGHT");
            TreeDrawerNode treeDrawerNode = (TreeDrawerNode)this.id2node.get(string);
            TreeDrawerNode treeDrawerNode2 = (TreeDrawerNode)this.id2node.get(string2);
            TreeDrawerNode treeDrawerNode3 = (TreeDrawerNode)this.id2node.get(string3);
            if (treeDrawerNode != null) {
                System.out.println("Symbol '" + treeDrawerNode + "' appeared twice, building weird tree");
            }
            if (treeDrawerNode2 == null) {
                n2 = headerInfo2.getHeaderIndex(string2);
                if (n2 == -1) {
                    throw new DendroException("Identifier " + string2 + " from tree file not found in CDT.");
                }
                this.leafList[n2] = treeDrawerNode2 = new TreeDrawerNode(string2, 1.0, (double)n2);
                this.id2node.put(string2, treeDrawerNode2);
            }
            if (treeDrawerNode3 == null) {
                n2 = headerInfo2.getHeaderIndex(string3);
                if (n2 == -1) {
                    throw new DendroException("Identifier " + string3 + " from tree file not found in CDT!");
                }
                this.leafList[n2] = treeDrawerNode3 = new TreeDrawerNode(string3, 1.0, (double)n2);
                this.id2node.put(string3, treeDrawerNode3);
            }
            if (treeDrawerNode2.getIndex() > treeDrawerNode3.getIndex()) {
                TreeDrawerNode treeDrawerNode4 = treeDrawerNode2;
                treeDrawerNode2 = treeDrawerNode3;
                treeDrawerNode3 = treeDrawerNode4;
            }
            this.rootNode = new TreeDrawerNode(string, 0.0, treeDrawerNode2, treeDrawerNode3);
            treeDrawerNode2.setParent(this.rootNode);
            treeDrawerNode3.setParent(this.rootNode);
            this.id2node.put(string, this.rootNode);
        }
        this.setBranchHeights(headerInfo, headerInfo2);
        this.setChanged();
    }

    public void setBranchHeights(HeaderInfo headerInfo, HeaderInfo headerInfo2) {
        if (this.rootNode == null) {
            return;
        }
        int n = headerInfo.getIndex("TIME");
        int n2 = 1;
        if (n == -1) {
            n = headerInfo.getIndex("CORRELATION");
            n2 = 0;
        }
        this.setBranchHeightsIter(headerInfo, n, n2, this.rootNode);
        if (n2 == 0) {
            this.setCorrMin(this.rootNode.getMinCorr());
            this.setCorrMax(1.0);
            for (int i = 0; i < this.leafList.length; ++i) {
                if (this.leafList[i] == null) continue;
                this.leafList[i].setCorr(this.getCorrMax());
            }
        } else {
            double d;
            int n3;
            for (n3 = 0; n3 < this.leafList.length; ++n3) {
                d = this.rootNode.getCorr();
                try {
                    d = TreeDrawer.parseDouble(headerInfo2.getHeader((int)this.leafList[n3].getIndex(), "LEAF"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.leafList[n3].setCorr(d);
            }
            this.setCorrMin(this.rootNode.getMinCorr());
            this.setCorrMax(this.rootNode.getMaxCorr());
            for (n3 = 0; n3 < this.leafList.length; ++n3) {
                d = this.getCorrMax();
                try {
                    d = TreeDrawer.parseDouble(headerInfo2.getHeader((int)this.leafList[n3].getIndex(), "LEAF"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.leafList[n3].setCorr(d);
            }
        }
    }

    public void setBranchHeightsIter(HeaderInfo headerInfo, int n, int n2, TreeDrawerNode treeDrawerNode) {
        Stack<TreeDrawerNode> stack = new Stack<TreeDrawerNode>();
        stack.push(treeDrawerNode);
        while (!stack.empty()) {
            TreeDrawerNode treeDrawerNode2 = (TreeDrawerNode)stack.pop();
            if (treeDrawerNode2.isLeaf()) continue;
            int n3 = headerInfo.getHeaderIndex(treeDrawerNode2.getId());
            Double d = new Double(headerInfo.getHeader(n3)[n]);
            double d2 = d;
            if (n2 == 0) {
                if (d2 < -1.0 || d2 > 1.0) {
                    System.out.println("Got illegal correlation " + d2 + " at line j");
                }
                treeDrawerNode2.setCorr(d2);
            } else {
                treeDrawerNode2.setCorr(d2);
            }
            stack.push(treeDrawerNode2.getLeft());
            stack.push(treeDrawerNode2.getRight());
        }
    }

    public abstract void paint(Graphics var1, LinearTransformation var2, LinearTransformation var3, Rectangle var4, TreeDrawerNode var5);

    public TreeDrawerNode getClosest(double d, double d2, double d3) {
        if (this.rootNode == null) {
            return null;
        }
        IterativeClosestFinder iterativeClosestFinder = new IterativeClosestFinder(d, d2, d3);
        return iterativeClosestFinder.find(this.rootNode);
    }

    public TreeDrawerNode getNodeById(String string) {
        if (string == null) {
            return null;
        }
        return (TreeDrawerNode)this.id2node.get(string);
    }

    private void setDefaults() {
        this.id2node = null;
        this.rootNode = null;
        this.leafList = null;
        if (this.nodeInfo != null) {
            this.nodeInfo.deleteObserver((Observer)this);
        }
        this.nodeInfo = null;
        this.setChanged();
    }

    public static double parseDouble(String string) {
        Double d = Double.valueOf(string);
        return d;
    }

    class IterativeClosestFinder {
        private double index;
        private double correlation;
        private double weight;

        public IterativeClosestFinder(double d, double d2, double d3) {
            this.index = d;
            this.correlation = d2;
            this.weight = d3;
        }

        public TreeDrawerNode find(TreeDrawerNode treeDrawerNode) {
            if (treeDrawerNode.isLeaf()) {
                return treeDrawerNode;
            }
            TreeDrawerNode treeDrawerNode2 = treeDrawerNode;
            Stack<TreeDrawerNode> stack = new Stack<TreeDrawerNode>();
            stack.push(treeDrawerNode);
            while (!stack.empty()) {
                TreeDrawerNode treeDrawerNode3 = (TreeDrawerNode)stack.pop();
                if (treeDrawerNode3.getDist(this.index, this.correlation, this.weight) < treeDrawerNode2.getDist(this.index, this.correlation, this.weight)) {
                    treeDrawerNode2 = treeDrawerNode3;
                }
                TreeDrawerNode treeDrawerNode4 = treeDrawerNode3.getLeft();
                TreeDrawerNode treeDrawerNode5 = treeDrawerNode3.getRight();
                if (!treeDrawerNode4.isLeaf()) {
                    stack.push(treeDrawerNode4);
                }
                if (treeDrawerNode5.isLeaf()) continue;
                stack.push(treeDrawerNode5);
            }
            return treeDrawerNode2;
        }
    }
}

