/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.ModelViewProduced;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.CharArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

class ZoomView
extends ModelViewProduced
implements MouseMotionListener {
    private int overx;
    private int overy;
    private static final String[] hints = new String[]{"Mouse over to get info"};
    boolean showVal = false;
    protected TreeSelectionI geneSelection;
    protected TreeSelectionI arraySelection;
    private ArrayDrawer drawer;
    private String[] statustext = new String[]{"Mouseover Selection", "", ""};
    private Rectangle sourceRect = new Rectangle();
    private Rectangle destRect = new Rectangle();
    private MapContainer xmap;
    private MapContainer ymap;
    private HeaderInfo arrayHI;
    private HeaderInfo geneHI;

    public ZoomView() {
        ((ModelView)this).panel = this;
        ((JComponent)((Object)this)).setToolTipText("This Turns Tooltips On");
        ((Component)((Object)this)).addMouseListener((MouseListener)((Object)this));
        ((Component)((Object)this)).addMouseMotionListener(this);
    }

    public String[] getHints() {
        return hints;
    }

    public boolean getShowVal() {
        return this.showVal;
    }

    public void setShowVal(boolean bl) {
        this.showVal = bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xmap.getRequiredPixels(), this.ymap.getRequiredPixels());
    }

    public void setGeneSelection(TreeSelectionI treeSelectionI) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver((Observer)((Object)this));
        }
        this.geneSelection = treeSelectionI;
        if (this.geneSelection != null) {
            this.geneSelection.addObserver((Observer)((Object)this));
        }
    }

    public void setArraySelection(TreeSelectionI treeSelectionI) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver((Observer)((Object)this));
        }
        this.arraySelection = treeSelectionI;
        if (this.arraySelection != null) {
            this.arraySelection.addObserver((Observer)((Object)this));
        }
    }

    public void setArrayDrawer(ArrayDrawer arrayDrawer) {
        if (this.drawer != null) {
            this.drawer.deleteObserver((Observer)((Object)this));
        }
        this.drawer = arrayDrawer;
        if (this.drawer != null) {
            this.drawer.addObserver((Observer)((Object)this));
        }
    }

    public ArrayDrawer getArrayDrawer() {
        return this.drawer;
    }

    public void setXMap(MapContainer mapContainer) {
        if (this.xmap != null) {
            this.xmap.deleteObserver((Observer)((Object)this));
        }
        this.xmap = mapContainer;
        if (this.xmap != null) {
            this.xmap.addObserver((Observer)((Object)this));
        }
    }

    public void setYMap(MapContainer mapContainer) {
        if (this.ymap != null) {
            this.ymap.deleteObserver((Observer)((Object)this));
        }
        this.ymap = mapContainer;
        if (this.ymap != null) {
            this.ymap.addObserver((Observer)((Object)this));
        }
    }

    public MapContainer getXMap() {
        return this.xmap;
    }

    public MapContainer getZoomXmap() {
        return this.xmap;
    }

    public MapContainer getYMap() {
        return this.ymap;
    }

    public MapContainer getZoomYmap() {
        return this.ymap;
    }

    public String viewName() {
        return "ZoomView";
    }

    public String[] getStatus() {
        block8: {
            try {
                if (!this.xmap.contains(this.overx) || !this.ymap.contains(this.overy)) break block8;
                this.statustext[0] = "Row:    " + (this.overy + 1);
                if (this.geneHI != null) {
                    int n = this.overy;
                    try {
                        this.statustext[0] = this.statustext[0] + " (" + this.geneHI.getHeader(n, 1) + ")";
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.statustext[0] = this.statustext[0] + " (N/A)";
                    }
                }
                this.statustext[1] = "Column: " + (this.overx + 1);
                if (this.arrayHI != null) {
                    try {
                        this.statustext[1] = this.statustext[1] + " (" + this.arrayHI.getHeader(this.overx, 0) + ")";
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.statustext[1] = this.statustext[1] + " (N/A)";
                    }
                }
                this.statustext[2] = this.drawer.isMissing(this.overx, this.overy) ? "Value:  No Data" : (this.drawer.isEmpty(this.overx, this.overy) ? "" : "Value:  " + this.drawer.getSummary(this.overx, this.overy));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return this.statustext;
    }

    public void updateBuffer(Graphics graphics) {
        if (((ModelView)this).offscreenChanged) {
            this.xmap.setAvailablePixels(((ModelView)this).offscreenSize.width);
            this.ymap.setAvailablePixels(((ModelView)this).offscreenSize.height);
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!((ModelView)this).offscreenValid) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, ((ModelView)this).offscreenSize.width, ((ModelView)this).offscreenSize.height);
            graphics.setColor(Color.black);
            this.destRect.setBounds(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            this.sourceRect.setBounds(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(this.destRect.width) - this.xmap.getIndex(0), this.ymap.getIndex(this.destRect.height) - this.ymap.getIndex(0));
            if (this.sourceRect.x >= 0 && this.sourceRect.y >= 0) {
                this.drawer.paint(graphics, this.sourceRect, this.destRect, null);
            }
        }
    }

    public void paintComposite(Graphics graphics) {
        if (this.getShowVal()) {
            try {
                ((CharArrayDrawer)this.drawer).paintChars(graphics, this.xmap, this.ymap, this.destRect);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog((Component)((Object)this), "ZoomView had trouble compositing:" + exception);
                this.setShowVal(false);
            }
        }
    }

    public void updatePixels() {
        if (((ModelView)this).offscreenChanged) {
            this.xmap.setAvailablePixels(((ModelView)this).offscreenSize.width);
            this.ymap.setAvailablePixels(((ModelView)this).offscreenSize.height);
            this.xmap.notifyObservers();
            this.ymap.notifyObservers();
        }
        if (!((ModelView)this).offscreenValid) {
            this.destRect.setBounds(0, 0, this.xmap.getUsedPixels(), this.ymap.getUsedPixels());
            this.sourceRect.setBounds(this.xmap.getIndex(0), this.ymap.getIndex(0), this.xmap.getIndex(this.destRect.width) - this.xmap.getIndex(0), this.ymap.getIndex(this.destRect.height) - this.ymap.getIndex(0));
            if (this.sourceRect.x >= 0 && this.sourceRect.y >= 0) {
                this.drawer.paint(this.offscreenPixels, this.sourceRect, this.destRect, this.offscreenScanSize);
            }
            this.offscreenSource.newPixels();
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.drawer) {
            ((ModelView)this).offscreenValid = false;
        } else if (observable == this.xmap || observable == this.ymap) {
            ((ModelView)this).offscreenValid = false;
        } else if (observable == this.geneSelection || observable == this.arraySelection) {
            MapContainer mapContainer = this.getZoomXmap();
            MapContainer mapContainer2 = this.getZoomYmap();
            mapContainer2.setIndexRange(this.geneSelection.getMinIndex(), this.geneSelection.getMaxIndex());
            mapContainer.setIndexRange(this.arraySelection.getMinIndex(), this.arraySelection.getMaxIndex());
            mapContainer.notifyObservers();
            mapContainer2.notifyObservers();
        } else {
            LogBuffer.println((String)("ZoomView got weird update : " + observable));
        }
        if (!((ModelView)this).offscreenValid) {
            ((Component)((Object)this)).repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.overx;
        int n2 = this.overy;
        this.overx = this.xmap.getIndex(mouseEvent.getX());
        this.overy = this.ymap.getIndex(mouseEvent.getY());
        if ((n2 != this.overy || n != this.overx) && ((ModelView)this).status != null) {
            ((ModelView)this).status.setMessages(this.getStatus());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object object = "";
        if (this.drawer != null) {
            int n = this.overy;
            if (this.xmap.contains(this.overx) && this.ymap.contains(this.overy)) {
                object = this.drawer.isMissing(this.overx, n) ? "No data" : (this.drawer.isEmpty(this.overx, n) ? null : "" + this.drawer.getSummary(this.overx, n));
            }
        }
        return object;
    }

    public void setHeaders(HeaderInfo headerInfo, HeaderInfo headerInfo2) {
        this.geneHI = headerInfo;
        this.arrayHI = headerInfo2;
    }
}

