/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.CoordinatesPresets;
import edu.stanford.genetics.treeview.plugin.karyoview.FileSetEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CoordinatesPresetEditor
extends JPanel
implements SettingsPanel {
    private CoordinatesPresets presets;
    private Window window;
    private String title = "Coordinates Presets Editor";
    private PresetEditPanel presetEditPanel;

    public CoordinatesPresetEditor(CoordinatesPresets coordinatesPresets) {
        this.presets = coordinatesPresets;
        this.presetEditPanel = new PresetEditPanel();
        this.add(new JScrollPane(this.presetEditPanel));
    }

    public void showConfig(Frame frame) {
        if (this.window == null) {
            Dialog dialog = new Dialog(frame, this.getTitle(), true);
            dialog.setLayout(new BorderLayout());
            dialog.add(new JScrollPane(this.presetEditPanel));
            dialog.add((Component)new JLabel(this.getTitle()), "North");
            dialog.add((Component)new ButtonPanel(), "South");
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getWindow().dispose();
                }
            });
            dialog.pack();
            this.window = dialog;
        }
        this.window.show();
    }

    public static void main(String[] stringArray) {
        CoordinatesPresets coordinatesPresets = new CoordinatesPresets((ConfigNode)new DummyConfigNode("CoordinatesPresets"));
        CoordinatesPresetEditor coordinatesPresetEditor = new CoordinatesPresetEditor(coordinatesPresets);
        Frame frame = new Frame(coordinatesPresetEditor.getTitle());
        coordinatesPresetEditor.showConfig(frame);
        System.out.println("on exit, presets were\n" + coordinatesPresets.toString());
        System.exit(0);
    }

    public void addToFrame(Frame frame) {
        frame.setLayout(new BorderLayout());
        this.presetEditPanel = new PresetEditPanel();
        frame.add(new JScrollPane(this.presetEditPanel));
        frame.add((Component)new ButtonPanel(), "South");
        this.window = frame;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void synchronizeFrom() {
        this.presetEditPanel.initialize();
        this.presetEditPanel.redoLayout();
    }

    public void synchronizeTo() {
        this.presetEditPanel.saveAll();
    }

    private class PresetEditPanel
    extends JPanel {
        private GridBagConstraints gbc;
        private JRadioButton[] defaultButtons;
        private JTextField[] presetNames;
        private FileSet[] presetFiles;
        private ButtonGroup bob = new ButtonGroup();

        PresetEditPanel() {
            this.initialize();
            this.redoLayout();
        }

        private void initialize() {
            int n = CoordinatesPresetEditor.this.presets.getNumPresets();
            this.defaultButtons = new JRadioButton[n + 1];
            this.presetNames = new JTextField[n + 1];
            this.presetFiles = new FileSet[n + 1];
            for (int i = 0; i < n; ++i) {
                this.initializePreset(i);
                this.bob.add(this.defaultButtons[i]);
            }
            this.initializeNonePreset(n);
            this.bob.add(this.defaultButtons[n]);
            if (CoordinatesPresetEditor.this.presets.getDefaultIndex() == -1) {
                this.defaultButtons[n].setSelected(true);
            } else {
                this.defaultButtons[CoordinatesPresetEditor.this.presets.getDefaultIndex()].setSelected(true);
            }
        }

        private void initializeNonePreset(int n) {
            JRadioButton jRadioButton;
            int n2 = n;
            JTextField jTextField = new JTextField();
            JTextField jTextField2 = new JTextField();
            jTextField2.setText("None");
            this.presetNames[n2] = jTextField2;
            this.presetFiles[n2] = null;
            this.defaultButtons[n2] = jRadioButton = new JRadioButton();
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CoordinatesPresetEditor.this.presets.setDefaultIndex(-1);
                }
            });
        }

        private void initializePreset(int n) {
            JRadioButton jRadioButton;
            final int n2 = n;
            FileSet fileSet = new FileSet((ConfigNode)new DummyConfigNode("Dummy FileSet"));
            JTextField jTextField = new JTextField();
            jTextField.setText(CoordinatesPresetEditor.this.presets.getPresetNames()[n2]);
            this.presetNames[n2] = jTextField;
            fileSet.copyState(CoordinatesPresetEditor.this.presets.getFileSet(n2));
            this.presetFiles[n2] = fileSet;
            this.defaultButtons[n2] = jRadioButton = new JRadioButton();
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CoordinatesPresetEditor.this.presets.setDefaultIndex(n2);
                }
            });
        }

        public void redoLayout() {
            int n = this.defaultButtons.length;
            this.removeAll();
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.weighty = 100.0;
            this.gbc.gridwidth = 1;
            this.gbc.fill = 2;
            this.gbc.anchor = 11;
            this.gbc.gridy = 0;
            this.gbc.gridx = 0;
            this.gbc.weighty = 100.0;
            this.add((Component)new JLabel("Modify Coordinates Presets", 0), this.gbc);
            this.gbc.weighty = 0.0;
            this.gbc.gridy = 1;
            this.gbc.gridx = 0;
            this.add((Component)new JLabel("Name"), this.gbc);
            this.gbc.gridx = 1;
            this.add((Component)new JLabel("Source"), this.gbc);
            this.gbc.gridx = 3;
            this.add((Component)new JLabel("Default?"), this.gbc);
            for (int i = 0; i < n; ++i) {
                ++this.gbc.gridy;
                this.addPreset(i);
            }
            ++this.gbc.gridy;
            JButton jButton = new JButton("Add");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PresetEditPanel.this.createPreset();
                }
            });
            ++this.gbc.gridy;
            this.gbc.gridx = 2;
            this.add((Component)jButton, this.gbc);
            this.revalidate();
            this.repaint();
        }

        private void addPreset(int n) {
            final int n2 = n;
            this.gbc.gridx = 0;
            this.add((Component)this.presetNames[n2], this.gbc);
            this.gbc.gridx = 1;
            this.gbc.weightx = 100.0;
            if (this.presetFiles[n2] != null) {
                this.add((Component)new FileSetEditor(this.presetFiles[n2], CoordinatesPresetEditor.this.window), this.gbc);
                this.gbc.gridx = 2;
                this.gbc.weightx = 0.0;
                JButton jButton = new JButton("Remove");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PresetEditPanel.this.removePreset(n2);
                    }
                });
                this.add((Component)jButton, this.gbc);
            }
            this.gbc.gridx = 3;
            this.add((Component)this.defaultButtons[n2], this.gbc);
        }

        private void saveAll() {
            int n;
            int n2;
            int n3 = this.presetNames.length - 1;
            for (n2 = CoordinatesPresetEditor.this.presets.getNumPresets(); n3 > n2; ++n2) {
                FileSet fileSet = new FileSet((ConfigNode)new DummyConfigNode("Dummy FileSet"));
                fileSet.setName("Preset" + n2);
                CoordinatesPresetEditor.this.presets.addFileSet(fileSet);
            }
            while (n2 > n3) {
                CoordinatesPresetEditor.this.presets.removeFileSet(--n2);
            }
            for (n = 0; n < n3; ++n) {
                this.presetFiles[n].setName(this.presetNames[n].getText());
            }
            for (n = 0; n < n3; ++n) {
                CoordinatesPresetEditor.this.presets.getFileSet(n).copyState(this.presetFiles[n]);
            }
        }

        private void removePreset(int n) {
            int n2;
            int n3;
            FileSet[] fileSetArray = new FileSet[this.presetFiles.length - 1];
            JTextField[] jTextFieldArray = new JTextField[this.presetNames.length - 1];
            JRadioButton[] jRadioButtonArray = new JRadioButton[this.defaultButtons.length - 1];
            for (n3 = 0; n3 < fileSetArray.length; ++n3) {
                n2 = n3;
                if (n3 >= n) {
                    ++n2;
                }
                fileSetArray[n3] = this.presetFiles[n2];
                jTextFieldArray[n3] = this.presetNames[n2];
                jRadioButtonArray[n3] = this.defaultButtons[n2];
            }
            this.bob.remove(this.defaultButtons[n]);
            n3 = 0;
            for (n2 = 0; n2 < this.defaultButtons.length; ++n2) {
                if (this.defaultButtons[n2] == null || !this.defaultButtons[n2].isSelected()) continue;
                n3 = n2;
            }
            if (n3 > jTextFieldArray.length - 2) {
                jRadioButtonArray[jTextFieldArray.length - 2].setSelected(true);
            } else {
                jRadioButtonArray[n3].setSelected(true);
            }
            this.presetNames = jTextFieldArray;
            this.presetFiles = fileSetArray;
            this.defaultButtons = jRadioButtonArray;
            this.redoLayout();
        }

        private void createPreset() {
            JRadioButton jRadioButton;
            int n;
            FileSet[] fileSetArray = new FileSet[this.presetFiles.length + 1];
            JTextField[] jTextFieldArray = new JTextField[this.presetNames.length + 1];
            JRadioButton[] jRadioButtonArray = new JRadioButton[this.defaultButtons.length + 1];
            for (n = 0; n < this.presetFiles.length; ++n) {
                fileSetArray[n] = this.presetFiles[n];
                jTextFieldArray[n] = this.presetNames[n];
                jRadioButtonArray[n] = this.defaultButtons[n];
            }
            n = jTextFieldArray.length - 2;
            fileSetArray[n + 1] = fileSetArray[n];
            jTextFieldArray[n + 1] = this.presetNames[n];
            jRadioButtonArray[n + 1] = jRadioButtonArray[n];
            jTextFieldArray[n] = new JTextField("Preset" + n);
            fileSetArray[n] = new FileSet((ConfigNode)new DummyConfigNode("DummyFileSet"));
            jRadioButtonArray[n] = jRadioButton = new JRadioButton();
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CoordinatesPresetEditor.this.presets.setDefaultIndex(n);
                }
            });
            this.bob.add(jRadioButton);
            this.presetNames = jTextFieldArray;
            this.presetFiles = fileSetArray;
            this.defaultButtons = jRadioButtonArray;
            this.redoLayout();
        }
    }

    private class ButtonPanel
    extends JPanel {
        ButtonPanel() {
            JButton jButton = new JButton("Save");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CoordinatesPresetEditor.this.synchronizeTo();
                    CoordinatesPresetEditor.this.window.dispose();
                }
            });
            this.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CoordinatesPresetEditor.this.synchronizeFrom();
                    CoordinatesPresetEditor.this.window.dispose();
                }
            });
            this.add(jButton2);
        }
    }
}

